/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionRegistBeanInterface;
import jp.mosp.platform.bean.system.SectionSearchBeanInterface;
import jp.mosp.platform.comparator.system.SectionMasterClassRouteComparator;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.SectionMasterVo;

public class SectionMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2200";
    public static final String CMD_SET_ACTIVATION_DATE = "PF2201";
    public static final String CMD_SEARCH = "PF2202";
    public static final String CMD_SORT = "PF2204";
    public static final String CMD_PAGE = "PF2205";
    public static final String CMD_REGIST = "PF2207";
    public static final String CMD_DELETE = "PF2209";
    public static final String CMD_INSERT_MODE = "PF2211";
    public static final String CMD_EDIT_MODE = "PF2212";
    public static final String CMD_ADD_MODE = "PF2213";
    public static final String CMD_BATCH_UPDATE = "PF2214";
    public static final String CMD_SET_BATCH_ACTIVATION_DATE = "PF2215";
    public static final String CMD_SET_BATCH_UPDATE_TYPE = "PF2216";
    public static final String TYPE_BATCH_UPDATE_CLASS_ROUTE = "classRoute";
    public static final String TYPE_BATCH_UPDATE_INACTIVATE = "inactivate";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_BATCH_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setBatchActivationDate();
            this.setJsScrollTo("divMoveUp");
        } else if (this.mospParams.getCommand().equals(CMD_SET_BATCH_UPDATE_TYPE)) {
            this.prepareVo();
            this.setBatchUpdateType();
            this.setJsScrollTo("divMoveUp");
        }
    }

    protected BaseVo getSpecificVo() {
        return new SectionMasterVo();
    }

    protected void show() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        vo.setTxtEditSectionCode("");
        vo.setTxtEditSectionName("");
        vo.setPltEditInactivate("");
        vo.setTxtEditSectionAbbr("");
        vo.setPltSectionType("");
        vo.setPltSearchSectionAbbr("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(SectionMasterClassRouteComparator.class.getName());
        this.insertMode();
        vo.setRadBatchUpdateType(TYPE_BATCH_UPDATE_CLASS_ROUTE);
        this.setBatchUpdateType();
        vo.setUseDisplay(this.reference().section().useDisplayName());
    }

    protected void setActivationDate() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        SectionReferenceBeanInterface reference = this.reference().section();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setEditPulldown();
        SectionDtoInterface scheduleDto = reference.getSectionInfo(vo.getTxtEditSectionCode(), this.getEditActivateDate());
        if (scheduleDto == null) {
            return;
        }
        vo.setPltEditClassRoute(scheduleDto.getClassRoute());
    }

    protected void search() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        SectionSearchBeanInterface search = this.reference().sectionSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setSectionCode(vo.getTxtSearchSectionCode());
        search.setSectionName(vo.getTxtSearchSectionName());
        search.setSectionAbbr(vo.getPltSearchSectionAbbr());
        search.setSectionType(vo.getPltSectionType());
        search.setCloseFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(SectionMasterClassRouteComparator.class.getName());
        vo.setAscending(false);
        vo.setSearchDate(this.getSearchActivateDate());
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void regist() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        SectionRegistBeanInterface regist = this.platform().sectionRegist();
        SectionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getSectionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        SectionRegistBeanInterface regist = this.platform().sectionRegist();
        SectionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getSectionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        SectionRegistBeanInterface regist = this.platform().sectionRegist();
        SectionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getSectionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().sectionRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        if (vo.getRadBatchUpdateType().equals(TYPE_BATCH_UPDATE_CLASS_ROUTE)) {
            this.platform().sectionRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), vo.getPltUpdateClassRoute());
        } else {
            this.platform().sectionRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        vo.setTxtEditSectionCode("");
        vo.setTxtEditSectionName("");
        vo.setTxtEditSectionAbbr("");
        vo.setTxtEditSectionDisplay("");
        vo.setPltEditClassRoute("");
        vo.setModeActivateDate("chaning");
        this.setEditPulldown();
    }

    protected void addMode() throws MospException {
        this.setEditAddMode();
        this.setModeActivateDate("chaning");
        this.setEditPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String sectionCode, Date activateDate) throws MospException {
        SectionDtoInterface dto = this.reference().section().findForKey(sectionCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.reference().section().getSectionHistory(sectionCode));
        this.setModeActivateDate("fixed");
        this.setEditPulldown();
    }

    protected void setBatchActivationDate() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        if (vo.getModeUpdateActivateDate().equals("chaning")) {
            vo.setModeUpdateActivateDate("fixed");
        } else {
            vo.setModeUpdateActivateDate("chaning");
        }
        this.setBatchPulldown();
    }

    protected void setBatchUpdateType() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        vo.setModeUpdateActivateDate("chaning");
        this.setBatchPulldown();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        SectionReferenceBeanInterface reference = this.reference().section();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblSectionCode = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblSectionName = new String[list.size()];
        String[] aryLblClassRoute = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SectionDtoInterface dto = (SectionDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getPfmSectionId();
            aryLblSectionCode[i] = dto.getSectionCode();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblSectionName[i] = dto.getSectionName();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getCloseFlag());
            aryLblClassRoute[i] = reference.getClassRouteAbbr(dto, vo.getSearchDate());
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblSectionCode(aryLblSectionCode);
        vo.setAryLblSectionName(aryLblSectionName);
        vo.setAryLblClassRoute(aryLblClassRoute);
        vo.setAryLblInactivate(aryLblInactivate);
        vo.setAryCkbRecordId(aryCkbRecordId);
    }

    protected void setDtoFields(SectionDtoInterface dto) {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        dto.setPfmSectionId(vo.getRecordId());
        dto.setSectionCode(vo.getTxtEditSectionCode());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setSectionName(vo.getTxtEditSectionName());
        dto.setSectionAbbr(vo.getTxtEditSectionAbbr());
        dto.setSectionDisplay(vo.getTxtEditSectionDisplay());
        dto.setClassRoute(vo.getPltEditClassRoute());
        dto.setInactivateFlag(Integer.parseInt(vo.getPltEditInactivate()));
    }

    public void setVoFields(SectionDtoInterface dto) {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmSectionId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditSectionCode(dto.getSectionCode());
        vo.setTxtEditSectionName(dto.getSectionName());
        vo.setTxtEditSectionAbbr(dto.getSectionAbbr());
        vo.setTxtEditSectionDisplay(dto.getSectionDisplay());
        vo.setPltEditInactivate(String.valueOf(dto.getCloseFlag()));
        vo.setPltEditClassRoute(dto.getClassRoute());
    }

    protected void setEditPulldown() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("fixed")) {
            vo.setAryPltEditClassRoute(this.reference().section().getSelectArrayForMaintenance(this.getEditActivateDate()));
            return;
        }
        vo.setAryPltEditClassRoute(this.getInputActivateDatePulldown());
    }

    protected void setBatchPulldown() throws MospException {
        SectionMasterVo vo = (SectionMasterVo)this.mospParams.getVo();
        if (vo.getModeUpdateActivateDate().equals("fixed")) {
            vo.setAryPltUpdateClassRoute(this.reference().section().getSelectArrayForMaintenance(this.getUpdateActivateDate()));
            return;
        }
        vo.setAryPltUpdateClassRoute(this.getInputActivateDatePulldown());
    }
}

