/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.portal.action;

import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.portal.vo.PasswordChangeVo;

public class PasswordChangeAction
extends PlatformAction {
    public static final String CMD_SHOW = "PF9110";
    public static final String CMD_SELECT = "PF9116";
    public static final String CMD_UPDATE = "PF9118";

    protected BaseVo getSpecificVo() {
        return new PasswordChangeVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        }
    }

    protected void show() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        vo.setForced(true);
        this.setNaviUrl();
        this.setCheckConditions();
    }

    protected void select() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        vo.setForced(false);
        this.setCheckConditions();
    }

    protected void update() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        String userId = this.mospParams.getUser().getUserId();
        PasswordCheckBeanInterface check = this.platform().passwordCheck();
        String newPass = check.encrypt(vo.getHdnNewPassword());
        String oldPass = check.encrypt(vo.getHdnOldPassword());
        String confirmPass = check.encrypt(vo.getHdnConfirmPassword());
        check.checkPasswordChange(newPass, confirmPass);
        check.checkPasswordChange(userId, oldPass, newPass);
        check.checkPasswordStrength(userId, newPass);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            this.setNaviUrl();
            return;
        }
        this.regist(userId, newPass);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            this.setNaviUrl();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        if (vo.isForced()) {
            this.mospParams.setNextCommand("PF0040");
        }
    }

    protected void regist(String userId, String password) throws MospException {
        this.platform().userAccountRegist().updatePassword(userId, password);
    }

    protected void setCheckConditions() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        PasswordCheckBeanInterface check = this.platform().passwordCheck();
        vo.setMinPassword(check.getMinPassword());
        vo.setCharPassword(check.getCharPassword());
        vo.setAttentionList(check.getAttentionList());
    }

    protected void setNaviUrl() {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        if (vo.isForced()) {
            this.mospParams.setNaviUrl(null);
        }
    }
}

