/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.portal.action;

import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.portal.vo.LoginVo;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class AuthAction
extends PlatformAction {
    public static final String CMD_AUTHENTICATE = "PF0020";
    public static final String CMD_SEND_MAIL = "PF0021";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_AUTHENTICATE)) {
            this.prepareVo();
            this.auth();
        } else if (this.mospParams.getCommand().equals(CMD_SEND_MAIL)) {
            this.prepareVo();
            this.sendMail();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new LoginVo();
    }

    protected void auth() throws MospException {
        LoginVo vo = (LoginVo)this.mospParams.getVo();
        String userId = vo.getTxtUserId();
        String pass = vo.getTxtPassWord();
        this.authAndSetMospUser(userId, pass);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.platform().passwordCheck().checkPasswordStrength(userId);
        if (this.mospParams.hasErrorMessage()) {
            this.mospParams.setNextCommand("PF9110");
            return;
        }
        this.platform().passwordCheck().checkPasswordPeriod(userId, this.getSystemDate());
        if (this.mospParams.hasErrorMessage()) {
            this.mospParams.setNextCommand("PF9110");
            return;
        }
        this.mospParams.setNextCommand("PF0041");
        LogUtility.application((MospParams)this.mospParams, (String)PlatformNamingUtility.login((MospParams)this.mospParams));
    }

    protected void authAndSetMospUser(String userId, String pass) throws MospException {
        this.platform().auth().authenticate(userId, pass);
        if (this.mospParams.hasErrorMessage()) {
            this.addAuthFailedMessage();
            return;
        }
        this.platform().mospUser().setMospUser(userId);
        if (this.mospParams.hasErrorMessage()) {
            this.addAuthFailedMessage();
            return;
        }
    }

    protected void sendMail() throws MospException {
    }

    protected void addAuthFailedMessage() {
        this.mospParams.addMessage("PFI0002", new String[]{this.mospParams.getName("Login")});
        this.mospParams.getStoredInfo().initStoredInfo();
    }
}

