/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalRegistBeanInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanNormalCardVo;

public class HumanNormalCardAction
extends PlatformHumanAction {
    public static final String CMD_SELECT = "PF1511";
    public static final String CMD_SEARCH = "PF1512";
    public static final String CMD_REGIST = "PF1516";
    public static final String CMD_DELETE = "PF1517";
    public static final String CMD_TRANSFER = "PF1519";
    public static final String KEY_VIEW_NORMAL_CARD = "NormalCard";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new HumanNormalCardVo();
    }

    protected void select() throws MospException {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information")));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.setNormalInfo(false);
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setNormalInfo(false);
    }

    protected void regist() throws MospException {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        HumanNormalRegistBeanInterface regist = this.platform().humanNormalRegist();
        regist.regist(vo.getDivision(), KEY_VIEW_NORMAL_CARD, vo.getPersonalId(), vo.getAryRecordIdMap());
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setNormalInfo(false);
    }

    protected void delete() throws MospException {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        HumanNormalRegistBeanInterface regist = this.platform().humanNormalRegist();
        regist.delete(vo.getDivision(), KEY_VIEW_NORMAL_CARD, vo.getPersonalId(), vo.getAryRecordIdMap());
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.setDefaultValues();
    }

    protected void transfer() {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        vo.getHumanNormalMap().clear();
        vo.getAryRecordIdMap().clear();
    }

    protected void setNormalInfo(boolean isPulldownName) throws MospException {
        HumanNormalCardVo vo = (HumanNormalCardVo)this.mospParams.getVo();
        String division = vo.getDivision();
        HumanNormalReferenceBeanInterface normalReference = this.reference().humanNormal();
        vo.putPltItem(normalReference.getHumanGeneralPulldown(division, KEY_VIEW_NORMAL_CARD, this.getSystemDate()));
        normalReference.getHumanNormalRecordMapInfo(division, KEY_VIEW_NORMAL_CARD, vo.getPersonalId(), this.getSystemDate(), isPulldownName);
        vo.setModeCardEdit("insert");
        if (!normalReference.getRecordsMap().isEmpty()) {
            vo.setModeCardEdit("edit");
        }
        vo.setAryRecordIdMap(normalReference.getRecordsMap());
        vo.putNormalItem(division, normalReference.getNormalMap());
    }
}

