/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanHistoryListVo;

public class HumanHistoryListAction
extends PlatformHumanAction {
    public static final String CMD_SEARCH = "PF1542";
    public static final String CMD_SELECT = "PF1546";
    public static final String CMD_RE_SEARCH = "PF1547";
    public static final String CMD_DELETE = "PF1548";
    public static final String CMD_TRANSFER = "PF1549";
    public static final String KEY_VIEW_HISTORY_LIST = "HistoryList";
    public static final String KEY_VIEW_HUMAN_HISTORY_CARD = "HistoryCard";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo(true, false);
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    public HumanHistoryListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new HumanHistoryListVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void select() throws MospException {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("History", new String[]{"List"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void reSearch() throws MospException {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void delete() throws MospException {
        this.deleteHistoryBasicInfo();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void deleteHistoryBasicInfo() throws MospException {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        String division = this.getTransferredType();
        Date activeDate = DateUtility.getDate((String)this.getTransferredActivateDate());
        this.platform().humanHistoryRegist().delete(division, KEY_VIEW_HUMAN_HISTORY_CARD, vo.getAryHistoryRecordIdMap(DateUtility.getStringDate((Date)activeDate)));
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.addDeleteMessage();
        this.commit();
    }

    protected void transfer() {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals("PF1536")) {
            this.mospParams.setNextCommand("PF1536");
        } else if (actionName.equals("PF1534")) {
            this.mospParams.setNextCommand("PF1534");
        } else if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        vo.setAryActiveteDate(new String[0]);
    }

    protected void getHistoryList() throws MospException {
        HumanHistoryListVo vo = (HumanHistoryListVo)this.mospParams.getVo();
        String division = vo.getDivision();
        String personalId = vo.getPersonalId();
        if (personalId.isEmpty()) {
            personalId = this.reference().human().getPersonalId(vo.getEmployeeCode(), this.getSystemDate());
        }
        HumanHistoryReferenceBeanInterface humanReference = this.reference().humanHistory();
        humanReference.getActiveDateHistoryMapInfo(division, KEY_VIEW_HUMAN_HISTORY_CARD, personalId, vo.getTargetDate());
        humanReference.getHistoryListData(division, KEY_VIEW_HISTORY_LIST);
        if (humanReference.getHistoryHumanInfoMap().isEmpty()) {
            return;
        }
        boolean isLastHistory = false;
        if (humanReference.getHistoryHumanInfoMap().size() == 1) {
            isLastHistory = true;
        }
        vo.setJsIsLastHistory(isLastHistory);
        String[] activeDate = humanReference.getArrayActiveDate(humanReference.getHistoryHumanInfoMap());
        vo.putHistoryItem(division, humanReference.getHistoryHumanInfoMap());
        vo.setAryHistoryRecordIdMap(humanReference.getHistoryReferenceInfoMap());
        vo.setAryActiveteDate(activeDate);
    }
}

