/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.human.action.HumanHistoryListAction;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanHistoryCardVo;

public class HumanHistoryCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1531";
    public static final String CMD_SEARCH = "PF1532";
    public static final String CMD_RE_SEARCH = "PF1533";
    public static final String CMD_ADD_SELECT = "PF1534";
    public static final String CMD_ADD = "PF1535";
    public static final String CMD_EDIT_SELECT = "PF1536";
    public static final String CMD_UPDATE = "PF1538";
    public static final String CMD_TRANSFER = "PF1539";
    public static final String KEY_VIEW_HUMAN_HISTORY_CARD = "HistoryCard";

    protected BaseVo getSpecificVo() {
        return new HumanHistoryCardVo();
    }

    public HumanHistoryCardAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_SELECT)) {
            this.prepareVo(true, false);
            this.addSelect();
        } else if (this.mospParams.getCommand().equals(CMD_ADD)) {
            this.prepareVo();
            this.add();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_SELECT)) {
            this.prepareVo(false, false);
            this.editSelect();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
        this.setCardCommonInfo();
    }

    protected void setActivationDate() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date activateDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        if (vo.getModeActivateDate().equals("chaning")) {
            HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, activateDate);
            if (humanDto == null) {
                this.addNotHumanErrorMessage();
                return;
            }
            if (this.getSamaActiveDateInfo(personalId, activateDate, vo.getDivision())) {
                return;
            }
            vo.setModeActivateDate("fixed");
            vo.setModeCardEdit("insert");
            this.setPersonalInfo(personalId, activateDate);
        } else if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        String imageName = this.getTransferredCommand();
        this.mospParams.addGeneralParam(KEY_VIEW_HUMAN_HISTORY_CARD, (Object)imageName);
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
    }

    protected void reSearch() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("insert");
    }

    protected void addSelect() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information", new String[]{"Insert"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.mospParams.addGeneralParam(KEY_VIEW_HUMAN_HISTORY_CARD, (Object)CMD_ADD_SELECT);
    }

    protected void add() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        String division = vo.getDivision();
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        HumanHistoryRegistBeanInterface regist = this.platform().humanHistoryRegist();
        HumanHistoryReferenceBeanInterface historyRefer = this.reference().humanHistory();
        regist.add(vo.getDivision(), KEY_VIEW_HUMAN_HISTORY_CARD, vo.getPersonalId(), activeDate);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setHumanCommonInfo(vo.getPersonalId(), activeDate);
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)DateUtility.getStringDate((Date)activeDate));
        vo.putPltItem(historyRefer.getHumanGeneralPulldown(division, KEY_VIEW_HUMAN_HISTORY_CARD, activeDate));
        this.setHistoryItem(division, activeDate);
        vo.setModeCardEdit("edit");
    }

    protected void editSelect() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information", new String[]{"Insert"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "codeAndName");
        this.setTargetHumanCommonInfo();
        this.setEditHistoryInfo();
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)this.getTransferredActivateDate());
        vo.setModeActivateDate("fixed");
        vo.setModeCardEdit("edit");
        this.mospParams.addGeneralParam(KEY_VIEW_HUMAN_HISTORY_CARD, (Object)CMD_EDIT_SELECT);
    }

    protected void setEditHistoryInfo() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.getHumanHistoryMap().clear();
        Date activeDate = DateUtility.getDate((String)this.getTransferredActivateDate());
        String division = vo.getDivision();
        HumanHistoryReferenceBeanInterface historyRefer = this.reference().humanHistory();
        vo.putPltItem(historyRefer.getHumanGeneralPulldown(division, KEY_VIEW_HUMAN_HISTORY_CARD, activeDate));
        this.setHistoryItem(division, activeDate);
        vo.setTxtActivateYear(DateUtility.getStringYear((Date)activeDate));
        vo.setTxtActivateMonth(DateUtility.getStringMonth((Date)activeDate));
        vo.setTxtActivateDay(DateUtility.getStringDay((Date)activeDate));
    }

    protected void update() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanHistoryRegistBeanInterface regist = this.platform().humanHistoryRegist();
        String division = vo.getDivision();
        String personalId = vo.getPersonalId();
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        regist.update(division, KEY_VIEW_HUMAN_HISTORY_CARD, personalId, activeDate, vo.getAryRecordIdMap());
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        vo.getHumanHistoryMap().clear();
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)DateUtility.getStringDate((Date)activeDate));
        this.setHistoryItem(division, activeDate);
    }

    protected void transfer() {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        } else if (actionName.equals(HumanHistoryListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1546");
        }
    }

    private void setDefaultValues() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("insert");
        this.setPulldown();
    }

    private void setPulldown() throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        HumanHistoryReferenceBeanInterface historyRefere = this.reference().humanHistory();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.putPltItem(historyRefere.getInputActiveDateGeneralPulldown(vo.getDivision(), KEY_VIEW_HUMAN_HISTORY_CARD));
            return;
        }
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        vo.putPltItem(historyRefere.getHumanGeneralPulldown(vo.getDivision(), KEY_VIEW_HUMAN_HISTORY_CARD, activeDate));
    }

    protected void setPersonalInfo(String personalId, Date activeDate) throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.getHumanHistoryMap().clear();
        String division = vo.getDivision();
        HumanHistoryReferenceBeanInterface historyRefer = this.reference().humanHistory();
        Map historyMap = historyRefer.getBeforeHumanHistoryMapInfo(division, KEY_VIEW_HUMAN_HISTORY_CARD, personalId, activeDate, activeDate);
        LinkedHashMap<String, Map> historyHumanInfoMap = new LinkedHashMap<String, Map>();
        historyHumanInfoMap.put(this.getStringDate(activeDate), historyMap);
        vo.putHistoryItem(division, historyHumanInfoMap);
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)this.getStringDate(activeDate));
    }

    protected boolean getSamaActiveDateInfo(String personalId, Date activeDate, String division) throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        this.setHistoryItem(division, activeDate);
        if (!vo.getHistoryMapInfo(division).isEmpty()) {
            this.mospParams.addErrorMessage("PFW0205", new String[0]);
            return true;
        }
        return false;
    }

    public void addNotHumanErrorMessage() {
        String key = this.mospParams.getName("Personal", new String[]{"Basis", "Information"});
        this.mospParams.addErrorMessage("PFW0220", new String[]{key});
    }

    public void setCardCommonInfo() {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
    }

    protected void setHistoryItem(String division, Date activeDate) throws MospException {
        HumanHistoryCardVo vo = (HumanHistoryCardVo)this.mospParams.getVo();
        HumanHistoryReferenceBeanInterface historyRefer = this.reference().humanHistory();
        historyRefer.getHistoryRecordMapInfo(vo.getDivision(), KEY_VIEW_HUMAN_HISTORY_CARD, vo.getPersonalId(), activeDate);
        vo.setAryRecordIdMap(historyRefer.getRecordsMap());
        vo.putHistoryItem(division, historyRefer.getHistoryHumanInfoMap());
    }
}

