/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.io.InputStream;
import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.BinaryUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanBinaryHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryHistoryRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.human.action.HumanBinaryHistoryListAction;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.human.vo.HumanBinaryHistoryCardVo;

public class HumanBinaryHistoryCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1571";
    public static final String CMD_SEARCH = "PF1572";
    public static final String CMD_RE_SEARCH = "PF1573";
    public static final String CMD_ADD_SELECT = "PF1574";
    public static final String CMD_ADD = "PF1575";
    public static final String CMD_EDIT_SELECT = "PF1576";
    public static final String CMD_UPDATE = "PF1578";
    public static final String CMD_TRANSFER = "PF1579";
    public static final String KEY_VIEW_HUMAN_BINARY_HISTORY_CARD = "HistoryCard";
    public static final String PRM_FILE_BINARY_HISTORY = "fileBinaryHistory";

    public HumanBinaryHistoryCardAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_SELECT)) {
            this.prepareVo(true, false);
            this.addSelect();
        } else if (this.mospParams.getCommand().equals(CMD_ADD)) {
            this.prepareVo();
            this.add();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_SELECT)) {
            this.prepareVo(false, false);
            this.editSelect();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
        this.setCardCommonInfo();
    }

    protected void setActivationDate() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date activateDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        if (vo.getModeActivateDate().equals("chaning")) {
            HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, activateDate);
            if (humanDto == null) {
                this.addNotHumanErrorMessage();
                return;
            }
            if (!this.reference().humanBinaryHistory().findForActivateDate(personalId, activateDate).isEmpty()) {
                this.mospParams.addErrorMessage("PFW0205", new String[0]);
                return;
            }
            vo.setModeActivateDate("fixed");
        } else if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected BaseVo getSpecificVo() {
        return new HumanBinaryHistoryCardVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
    }

    protected void reSearch() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        if (vo.getModeCardEdit().equals("add")) {
            vo.setTxtActivateYear("");
            vo.setTxtActivateMonth("");
            vo.setTxtActivateDay("");
            vo.setModeActivateDate("chaning");
        } else if (vo.getModeCardEdit().equals("edit")) {
            vo.setModeActivateDate("fixed");
        }
    }

    protected void addSelect() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information", new String[]{"Insert"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
    }

    protected void add() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        String division = vo.getDivision();
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        HumanBinaryHistoryRegistBeanInterface regist = this.platform().humanBinaryHistoryRegist();
        HumanBinaryHistoryDtoInterface newDto = regist.getInitDto();
        this.setDtoFields(newDto, activeDate);
        regist.insert(newDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setHumanCommonInfo(vo.getPersonalId(), activeDate);
        HumanBinaryHistoryReferenceBeanInterface binaryHistoryRefer = this.reference().humanBinaryHistory();
        HumanBinaryHistoryDtoInterface dto = binaryHistoryRefer.findForKey(vo.getPersonalId(), division, activeDate);
        this.setVoFields(dto);
        vo.setModeCardEdit("edit");
    }

    protected void editSelect() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information") + this.mospParams.getName("Insert")));
        this.setPlatformHumanSettings(CMD_SEARCH, "codeAndName");
        this.setTargetHumanCommonInfo();
        Date activeDate = DateUtility.getDate((String)this.getTransferredActivateDate());
        this.setPulldown();
        HumanBinaryHistoryReferenceBeanInterface binaryHistoryRefer = this.reference().humanBinaryHistory();
        HumanBinaryHistoryDtoInterface dto = binaryHistoryRefer.findForKey(vo.getPersonalId(), vo.getDivision(), activeDate);
        this.setVoFields(dto);
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)this.getTransferredActivateDate());
        vo.setModeActivateDate("fixed");
        vo.setModeCardEdit("edit");
    }

    protected void update() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanBinaryHistoryRegistBeanInterface regist = this.platform().humanBinaryHistoryRegist();
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        HumanBinaryHistoryDtoInterface oldDto = this.reference().humanBinaryHistory().findForKey(vo.getHidRecordId(), false);
        oldDto.setFileName(vo.getFileBinaryHistory());
        oldDto.setFileRemark(vo.getTxtFileRemark());
        regist.update(oldDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.mospParams.addGeneralParam("transferredActivateDate", (Object)DateUtility.getStringDate((Date)activeDate));
        HumanBinaryHistoryReferenceBeanInterface binaryHistoryRefer = this.reference().humanBinaryHistory();
        HumanBinaryHistoryDtoInterface dto = binaryHistoryRefer.findForKey(vo.getPersonalId(), vo.getDivision(), activeDate);
        this.setVoFields(dto);
    }

    protected void transfer() {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        } else if (actionName.equals(HumanBinaryHistoryListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1586");
        }
    }

    private void setDefaultValues() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
        vo.setFileBinaryHistory("");
        vo.setTxtFileRemark("");
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("add");
        this.setPulldown();
    }

    protected void setVoFields(HumanBinaryHistoryDtoInterface dto) throws MospException {
        if (dto == null) {
            this.setDefaultValues();
            return;
        }
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        vo.setHidRecordId(Long.valueOf(dto.getPfaHumanBinaryHistoryId()));
        vo.setTxtActivateYear(DateUtility.getStringYear((Date)dto.getActivateDate()));
        vo.setTxtActivateMonth(DateUtility.getStringMonth((Date)dto.getActivateDate()));
        vo.setTxtActivateDay(DateUtility.getStringDay((Date)dto.getActivateDate()));
        vo.setPltFileType(dto.getFileType());
        vo.setFileBinaryHistory(dto.getFileName());
        vo.setTxtFileRemark(dto.getFileRemark());
    }

    protected void setDtoFields(HumanBinaryHistoryDtoInterface dto, Date activeDate) throws MospException {
        byte[] file = BinaryUtility.getBinaryData((InputStream)this.mospParams.getRequestFile(PRM_FILE_BINARY_HISTORY));
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        dto.setActivateDate(activeDate);
        dto.setPersonalId(vo.getPersonalId());
        dto.setHumanItemType(vo.getDivision());
        dto.setHumanItemBinary(file);
        dto.setFileType(HumanUtility.getBinaryFileType((String)vo.getFileBinaryHistory()));
        dto.setFileName(vo.getFileBinaryHistory());
        dto.setFileRemark(vo.getTxtFileRemark());
    }

    protected void setPulldown() {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryBinaryFileType = properties.getCodeArray("BinaryFileType", true);
        vo.setAryPltFileType(aryBinaryFileType);
    }

    public void addNotHumanErrorMessage() {
        String key = this.mospParams.getName("Personal", new String[]{"Basis", "Information"});
        this.mospParams.addErrorMessage("PFW0220", new String[]{key});
    }

    public void setCardCommonInfo() {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
    }
}

