/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.action;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.bean.file.ImportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.file.ImportFieldRegistBeanInterface;
import jp.mosp.platform.bean.file.ImportReferenceBeanInterface;
import jp.mosp.platform.bean.file.ImportRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.file.vo.ImportCardVo;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.utils.PlatformUtility;

public class ImportCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF1320";
    public static final String CMD_SELECT_SHOW = "PF1321";
    public static final String CMD_REGIST = "PF1325";
    public static final String CMD_DELETE = "PF1327";
    public static final String CMD_SET_TABLE_TYPE = "PF1370";
    public static final String CMD_INSERT_MODE = "PF1371";
    public static final String KEY_VIEW_HUMAN_IMPORT = "HumanImport";

    protected BaseVo getSpecificVo() {
        return new ImportCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TABLE_TYPE)) {
            this.prepareVo();
            this.setTableType();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        }
    }

    protected void show() throws MospException {
        this.setImportCardInfo();
        this.insertMode();
    }

    protected void select() throws MospException {
        this.setImportCardInfo();
        this.editMode();
    }

    protected void regist() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        ImportRegistBeanInterface regist = this.platform().importRegist();
        ImportFieldRegistBeanInterface registField = this.platform().importFieldRegist();
        String[] arySelectSelected = vo.getJsPltSelectSelected();
        ImportDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        registField.insert(vo.getTxtEditCode(), vo.getPltEditInactivate(), arySelectSelected);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getImportCode());
    }

    protected void update() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        ImportRegistBeanInterface regist = this.platform().importRegist();
        ImportFieldRegistBeanInterface registField = this.platform().importFieldRegist();
        ImportDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        String[] arySelectSelected = vo.getJsPltSelectSelected();
        regist.update(dto);
        registField.update(vo.getTxtEditCode(), vo.getPltEditInactivate(), arySelectSelected);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getImportCode());
    }

    protected void delete() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        ImportDtoInterface dto = this.reference().importRefer().findForKey(vo.getTxtEditCode());
        this.platform().importRegist().delete(dto);
        this.platform().importFieldRegist().delete(vo.getTxtEditCode());
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setTableType() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode());
    }

    protected void setEditUpdateMode(String importCode) throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        ImportReferenceBeanInterface reference = this.reference().importRefer();
        ImportFieldReferenceBeanInterface fieldReference = this.reference().importField();
        ImportDtoInterface dto = reference.findForKey(importCode);
        List list = fieldReference.getImportFieldList(importCode);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setVoFields(list);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(new ArrayList());
    }

    public void setDefaultValues() {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        vo.setTxtEditCode("");
        vo.setTxtEditName("");
        vo.setPltEditTable("");
        vo.setPltEditHeader("");
        vo.setPltEditType("1");
        vo.setJsPltSelectSelected(new String[0]);
    }

    protected void setPulldown() throws MospException {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        vo.setJsPltSelectTable(new String[0][0]);
        vo.setLblTableName("");
        if (vo.getModeActivateDate().equals("fixed")) {
            vo.setJsPltSelectTable(this.getCodeArray(vo.getPltEditTable(), false));
            vo.setLblTableName(this.getCodeName(vo.getPltEditTable(), vo.getTableTypeCodeKey()));
        }
        vo.setAryPltTableType(PlatformUtility.getTableTypeArray((MospParams)this.mospParams, (String)vo.getTableTypeCodeKey(), (boolean)false));
        if (vo.getModeActivateDate().equals("fixed") && vo.getPltEditTable().equals("pfm_human")) {
            String[] aryDivision;
            for (String division : aryDivision = this.mospParams.getApplicationProperties("HumanGeneralDivisions")) {
                String[][] aryAddItem;
                if (RoleUtility.getHiddenDivisionsList((MospParams)this.mospParams).contains(division) || RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(division) || (aryAddItem = this.reference().humanNormal().getPulldownForHumanExportImport(division, KEY_VIEW_HUMAN_IMPORT)) == null || aryAddItem.length == 0) continue;
                vo.setJsPltSelectTable(this.addArrayString(vo.getJsPltSelectTable(), aryAddItem));
            }
        }
    }

    protected void setDtoFields(ImportDtoInterface dto) {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        dto.setPfmImportId(vo.getRecordId());
        dto.setImportTable(vo.getPltEditTable());
        dto.setImportCode(vo.getTxtEditCode());
        dto.setImportName(vo.getTxtEditName());
        dto.setType(vo.getPltEditType());
        dto.setHeader(this.getInt(vo.getPltEditHeader()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(ImportDtoInterface dto) {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmImportId());
        vo.setPltEditTable(dto.getImportTable());
        vo.setTxtEditCode(dto.getImportCode());
        vo.setTxtEditName(dto.getImportName());
        vo.setPltEditType(dto.getType());
        vo.setPltEditHeader(String.valueOf(dto.getHeader()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setVoFields(List<ImportFieldDtoInterface> list) {
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        String[] jsPltSelectSelected = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ImportFieldDtoInterface dto = list.get(i);
            jsPltSelectSelected[i] = dto.getFieldName();
        }
        vo.setJsPltSelectSelected(jsPltSelectSelected);
    }

    protected void setImportCardInfo() {
        String tableTypeCodeKey = this.getTransferredType();
        String showListCommand = this.getTransferredCommand();
        if (tableTypeCodeKey == null || tableTypeCodeKey.isEmpty()) {
            return;
        }
        ImportCardVo vo = (ImportCardVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey(tableTypeCodeKey);
        vo.setShowListCommand(showListCommand);
    }
}

