/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.workflow.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.ApprovalRouteDaoInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmRouteApplicationDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmRouteApplicationDao
extends PlatformDao
implements RouteApplicationDaoInterface {
    public static final String TABLE = "pfm_route_application";
    public static final String COL_PFM_ROUTE_APPLICATION_ID = "pfm_route_application_id";
    public static final String COL_ROUTE_APPLICATION_CODE = "route_application_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_ROUTE_APPLICATION_NAME = "route_application_name";
    public static final String COL_ROUTE_CODE = "route_code";
    public static final String COL_WORKFLOW_TYPE = "workflow_type";
    public static final String COL_ROUTE_APPLICATION_TYPE = "route_application_type";
    public static final String COL_WORK_PLACE_CODE = "work_place_code";
    public static final String COL_EMPLOYMENT_CONTRACT_CODE = "employment_contract_code";
    public static final String COL_SECTION_CODE = "section_code";
    public static final String COL_POSITION_CODE = "position_code";
    public static final String COL_PERSONAL_IDS = "personal_ids";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "pfm_route_application_id";

    public void initDao() {
    }

    public List<RouteApplicationDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append("inactivate_flag");
            sb.append(" = ");
            sb.append(0);
            sb.append(" ");
            sb.append(PfmRouteApplicationDao.getOrderByColumn((String)"route_application_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findForApproverSection(String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode, Date activateDate, int workflowType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            if (!workPlaceCode.equals("")) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"work_place_code"));
            }
            if (!employmentContractCode.equals("")) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"employment_contract_code"));
            }
            if (!sectionCode.equals("")) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"section_code"));
            }
            if (!positionCode.equals("")) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"position_code"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, Integer.parseInt("0"));
            this.setParam(this.index++, workflowType);
            if (!workPlaceCode.equals("")) {
                this.setParam(this.index++, workPlaceCode);
            }
            if (!employmentContractCode.equals("")) {
                this.setParam(this.index++, employmentContractCode);
            }
            if (!sectionCode.equals("")) {
                this.setParam(this.index++, sectionCode);
            }
            if (!positionCode.equals("")) {
                this.setParam(this.index++, positionCode);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findForHistory(String routeApplicationCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, routeApplicationCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findForInfo(String routeApplicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.lessEqual((String)"activate_date"));
            sb.append(PfmRouteApplicationDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, routeApplicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findForKey(String routeApplicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, routeApplicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findForPersonalId(String personalId, Date activateDate, int workflowType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, Integer.parseInt("1"));
            this.setParam(this.index++, workflowType);
            this.setParam(this.index++, PfmRouteApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findForMaster(Date activateDate, int workflowType, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type", (long)Integer.parseInt("0")));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"work_place_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"employment_contract_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"section_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"position_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, workflowType);
            this.setParam(this.index++, workPlaceCode);
            this.setParam(this.index++, employmentContractCode);
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            ApprovalRouteDaoInterface routeDao = (ApprovalRouteDaoInterface)this.loadDao(ApprovalRouteDaoInterface.class);
            Date activateDate = (Date)param.get("activateDate");
            String workflowType = String.valueOf(param.get("workflowType"));
            String routeApplicationCode = String.valueOf(param.get("routeApplicationCode"));
            String routeApplicationName = String.valueOf(param.get("routeApplicationName"));
            String routeCode = String.valueOf(param.get("routeCode"));
            String routeName = String.valueOf(param.get("routeName"));
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            if (activateDate != null) {
                sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
            }
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.like((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.like((String)"route_application_name"));
            if (!workflowType.isEmpty()) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            }
            if (!routeCode.isEmpty()) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.like((String)"route_code"));
            }
            if (!routeName.isEmpty()) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append("route_code");
                sb.append(PfmRouteApplicationDao.in());
                sb.append(PfmRouteApplicationDao.leftParenthesis());
                sb.append(routeDao.getQueryForRouteName());
                sb.append(PfmRouteApplicationDao.rightParenthesis());
            }
            if (!inactivateFlag.equals("")) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.equal((String)"inactivate_flag"));
            }
            this.prepareStatement(sb.toString());
            if (activateDate != null) {
                this.setParam(this.index++, activateDate);
            }
            this.setParam(this.index++, PfmRouteApplicationDao.startWithParam((String)routeApplicationCode));
            this.setParam(this.index++, PfmRouteApplicationDao.containsParam((String)routeApplicationName));
            if (!workflowType.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(workflowType));
            }
            if (!routeCode.isEmpty()) {
                this.setParam(this.index++, PfmRouteApplicationDao.startWithParam((String)routeCode));
            }
            if (!routeName.isEmpty()) {
                Date targetDate = activateDate;
                if (targetDate == null) {
                    targetDate = DateUtility.getSystemDate();
                }
                this.setParam(this.index++, targetDate);
                this.setParam(this.index++, PfmRouteApplicationDao.containsParam((String)routeName));
            }
            if (!inactivateFlag.equals("")) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public String getQueryForRouteApplicationName() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmRouteApplicationDao.select());
        sb.append("route_application_code");
        sb.append(PfmRouteApplicationDao.from((String)"pfm_route_application"));
        sb.append(this.getQueryForMaxActivateDate("pfm_route_application", "route_application_code", "activate_date"));
        sb.append(PfmRouteApplicationDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmRouteApplicationDao.and());
        sb.append(PfmRouteApplicationDao.like((String)"route_application_name"));
        return sb.toString();
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            RouteApplicationDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmRouteApplicationId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public BaseDto mapping() throws MospException {
        PfmRouteApplicationDto dto = new PfmRouteApplicationDto();
        dto.setPfmRouteApplicationId(this.getLong("pfm_route_application_id"));
        dto.setRouteApplicationCode(this.getString("route_application_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setRouteApplicationName(this.getString("route_application_name"));
        dto.setRouteCode(this.getString("route_code"));
        dto.setWorkflowType(this.getInt("workflow_type"));
        dto.setRouteApplicationType(this.getInt("route_application_type"));
        dto.setWorkPlaceCode(this.getString("work_place_code"));
        dto.setEmploymentContractCode(this.getString("employment_contract_code"));
        dto.setSectionCode(this.getString("section_code"));
        dto.setPositionCode(this.getString("position_code"));
        dto.setPersonalIds(this.getString("personal_ids"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<RouteApplicationDtoInterface> mappingAll() throws MospException {
        ArrayList<RouteApplicationDtoInterface> all = new ArrayList<RouteApplicationDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        RouteApplicationDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmRouteApplicationId());
        this.setParam(this.index++, dto.getRouteApplicationCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getRouteApplicationName());
        this.setParam(this.index++, dto.getRouteCode());
        this.setParam(this.index++, dto.getWorkflowType());
        this.setParam(this.index++, dto.getRouteApplicationType());
        this.setParam(this.index++, dto.getWorkPlaceCode());
        this.setParam(this.index++, dto.getEmploymentContractCode());
        this.setParam(this.index++, dto.getSectionCode());
        this.setParam(this.index++, dto.getPositionCode());
        this.setParam(this.index++, dto.getPersonalIds());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            RouteApplicationDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmRouteApplicationId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findForTerm(Date fromActivateDate, Date toActivateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.greater((String)"activate_date"));
            }
            if (toActivateDate != null) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.less((String)"activate_date"));
            }
            sb.append(PfmRouteApplicationDao.getOrderByColumn((String)"route_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findFormerInfo(String applicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.less((String)"activate_date"));
            sb.append(PfmRouteApplicationDao.getOrderByColumn((String)"activate_date"));
            sb.append(PfmRouteApplicationDao.getDesc());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RouteApplicationDtoInterface findLatterInfo(String applicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.greater((String)"activate_date"));
            sb.append(PfmRouteApplicationDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            RouteApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RouteApplicationDtoInterface routeApplicationDtoInterface = dto;
            return routeApplicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findMasterDuplicated(Date startDate, Date endDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode, int workflowType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.greater((String)"activate_date"));
            sb.append(PfmRouteApplicationDao.and());
            if (endDate != null) {
                sb.append(PfmRouteApplicationDao.less((String)"activate_date"));
                sb.append(PfmRouteApplicationDao.and());
            }
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type", (long)Integer.parseInt("0")));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"work_place_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"employment_contract_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"section_code"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"position_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, startDate);
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, workflowType);
            this.setParam(this.index++, workPlaceCode);
            this.setParam(this.index++, employmentContractCode);
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findPersonDuplicated(Date startDate, Date endDate, String personalId, int workflowType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.greater((String)"activate_date"));
            if (endDate != null) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.less((String)"activate_date"));
            }
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type", (long)Integer.parseInt("1")));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"workflow_type"));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, startDate);
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, workflowType);
            this.setParam(this.index++, PfmRouteApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<RouteApplicationDtoInterface> findPersonTerm(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmRouteApplicationDao.where());
            sb.append(this.deleteFlagOff());
            if (startDate != null) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(PfmRouteApplicationDao.and());
                sb.append(PfmRouteApplicationDao.lessEqual((String)"activate_date"));
            }
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.equal((String)"route_application_type", (long)Integer.parseInt("1")));
            sb.append(PfmRouteApplicationDao.and());
            sb.append(PfmRouteApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, PfmRouteApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    protected RouteApplicationDtoInterface castDto(BaseDtoInterface baseDto) {
        return (RouteApplicationDtoInterface)baseDto;
    }
}

