/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.message.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.message.MessageDaoInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.dto.message.impl.PftMessageDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PftMessageDao
extends PlatformDao
implements MessageDaoInterface {
    public static final String TABLE = "pft_message";
    public static final String COL_PFT_MESSAGE_ID = "pft_message_id";
    public static final String COL_MESSAGE_NO = "message_no";
    public static final String COL_START_DATE = "start_date";
    public static final String COL_END_DATE = "end_date";
    public static final String COL_MESSAGE_TYPE = "message_type";
    public static final String COL_MESSAGE_IMPORTANCE = "message_importance";
    public static final String COL_MESSAGE_TITLE = "message_title";
    public static final String COL_MESSAGE_BODY = "message_body";
    public static final String COL_APPLICATION_TYPE = "application_type";
    public static final String COL_WORK_PLACE_CODE = "work_place_code";
    public static final String COL_EMPLOYMENT_CONTRACT_CODE = "employment_contract_code";
    public static final String COL_SECTION_CODE = "section_code";
    public static final String COL_POSITION_CODE = "position_code";
    public static final String COL_PERSONAL_IDS = "personal_ids";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "pft_message_id";
    public static final String SEQUENCE = "pft_message_message_no_seq";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        PftMessageDto dto = new PftMessageDto();
        dto.setApplicationType(this.getInt("application_type"));
        dto.setEmploymentContractCode(this.getString("employment_contract_code"));
        dto.setEndDate(this.getDate("end_date"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        dto.setMessageBody(this.getString("message_body"));
        dto.setMessageImportance(this.getInt("message_importance"));
        dto.setMessageNo(this.getString("message_no"));
        dto.setMessageTitle(this.getString("message_title"));
        dto.setMessageType(this.getInt("message_type"));
        dto.setPersonalId(this.getString("personal_ids"));
        dto.setPftMessageId(this.getLong("pft_message_id"));
        dto.setPositionCode(this.getString("position_code"));
        dto.setSectionCode(this.getString("section_code"));
        dto.setStartDate(this.getDate("start_date"));
        dto.setWorkPlaceCode(this.getString("work_place_code"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<MessageDtoInterface> mappingAll() throws MospException {
        ArrayList<MessageDtoInterface> all = new ArrayList<MessageDtoInterface>();
        while (this.next()) {
            all.add((MessageDtoInterface)this.mapping());
        }
        return all;
    }

    public MessageDtoInterface findForKey(String messageNo) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PftMessageDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"message_no"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, messageNo);
            this.executeQuery();
            MessageDtoInterface dto = null;
            if (this.next()) {
                dto = (MessageDtoInterface)this.mapping();
            }
            MessageDtoInterface messageDtoInterface = dto;
            return messageDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public long getMaxMessageNo() throws MospException {
        return this.nextValue("pft_message_message_no_seq");
    }

    public List<MessageDtoInterface> findForMaster(String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode, Date targetDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PftMessageDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.lessEqual((String)"start_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.greaterEqual((String)"end_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"work_place_code"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"employment_contract_code"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"section_code"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"position_code"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"application_type", (long)Integer.parseInt("0")));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, targetDate);
            this.setParam(this.index++, targetDate);
            this.setParam(this.index++, workPlaceCode);
            this.setParam(this.index++, employmentContractCode);
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<MessageDtoInterface> findForPersonalId(String personalId, Date targetDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PftMessageDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.lessEqual((String)"start_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.greaterEqual((String)"end_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.like((String)"personal_ids"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.equal((String)"application_type", (long)Integer.parseInt("1")));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, targetDate);
            this.setParam(this.index++, targetDate);
            this.setParam(this.index++, PftMessageDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, Object> getParamsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    public List<MessageDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String messageNo = this.getSearchParam(param, "messageNo");
            Date startDate = (Date)param.get("startDate");
            Date endDate = (Date)param.get("endDate");
            Integer messageType = (Integer)param.get("messageType");
            Integer messageImportance = (Integer)param.get("messageImportance");
            String messageTitle = this.getSearchParam(param, "messageTitle");
            String employeeName = this.getSearchParam(param, "employeeName");
            Integer inactivateFlag = (Integer)param.get("inactivateFlag");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PftMessageDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.lessEqual((String)"start_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.greaterEqual((String)"end_date"));
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.like((String)"message_no"));
            if (messageType != null) {
                sb.append(PftMessageDao.and());
                sb.append(PftMessageDao.equal((String)"message_type"));
            }
            if (messageImportance != null) {
                sb.append(PftMessageDao.and());
                sb.append(PftMessageDao.equal((String)"message_importance"));
            }
            if (!employeeName.isEmpty()) {
                UserMasterDaoInterface userDao = (UserMasterDaoInterface)this.loadDao(UserMasterDaoInterface.class);
                sb.append(PftMessageDao.and());
                sb.append(this.colInsertUser);
                sb.append(PftMessageDao.in());
                sb.append(PftMessageDao.leftParenthesis());
                sb.append(userDao.getQueryForEmployeeName());
                sb.append(PftMessageDao.rightParenthesis());
            }
            sb.append(PftMessageDao.and());
            sb.append(PftMessageDao.like((String)"message_title"));
            if (inactivateFlag != null) {
                sb.append(PftMessageDao.and());
                sb.append(PftMessageDao.equal((String)"inactivate_flag"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, endDate);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, PftMessageDao.startWithParam((String)messageNo));
            if (messageType != null) {
                this.setParam(this.index++, messageType.intValue());
            }
            if (messageImportance != null) {
                this.setParam(this.index++, messageImportance.intValue());
            }
            if (!employeeName.isEmpty()) {
                this.setParam(this.index++, endDate);
                this.setParam(this.index++, endDate);
                this.setParam(this.index++, PftMessageDao.containsParam((String)employeeName));
                this.setParam(this.index++, PftMessageDao.containsParam((String)employeeName));
                this.setParam(this.index++, PftMessageDao.containsParam((String)employeeName));
                this.setParam(this.index++, PftMessageDao.containsParam((String)employeeName));
            }
            this.setParam(this.index++, PftMessageDao.containsParam((String)messageTitle));
            if (inactivateFlag != null) {
                this.setParam(this.index++, inactivateFlag.intValue());
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            MessageDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPftMessageId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            MessageDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPftMessageId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        MessageDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPftMessageId());
        this.setParam(this.index++, dto.getMessageNo());
        this.setParam(this.index++, dto.getStartDate());
        this.setParam(this.index++, dto.getEndDate());
        this.setParam(this.index++, dto.getMessageType());
        this.setParam(this.index++, dto.getMessageImportance());
        this.setParam(this.index++, dto.getMessageTitle());
        this.setParam(this.index++, dto.getMessageBody());
        this.setParam(this.index++, dto.getApplicationType());
        this.setParam(this.index++, dto.getWorkPlaceCode());
        this.setParam(this.index++, dto.getEmploymentContractCode());
        this.setParam(this.index++, dto.getSectionCode());
        this.setParam(this.index++, dto.getPositionCode());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    protected MessageDtoInterface castDto(BaseDtoInterface baseDto) {
        return (MessageDtoInterface)baseDto;
    }
}

