/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.comparator.human.HumanPositionGradeComparator;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.SubApproverDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;

public class WorkflowIntegrateBean
extends PlatformBean
implements WorkflowIntegrateBeanInterface {
    protected WorkflowReferenceBeanInterface workflowReference;
    protected PlatformMasterBeanInterface platformMaster;
    protected ApprovalRouteReferenceBeanInterface routeReference;
    protected ApprovalRouteUnitReferenceBeanInterface routeUnitReference;
    protected ApprovalUnitReferenceBeanInterface unitReference;
    protected HumanSearchBeanInterface humanSearch;
    protected HumanReferenceBeanInterface humanReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected ConcurrentReferenceBeanInterface concurrentReference;
    protected UserMasterReferenceBeanInterface userMasterReference;
    protected UserExtraRoleReferenceBeanInterface userExtraRoleRefer;
    protected PositionReferenceBeanInterface positionReference;
    protected SubApproverReferenceBeanInterface subApproverReference;

    public WorkflowIntegrateBean() {
    }

    public WorkflowIntegrateBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.routeReference = (ApprovalRouteReferenceBeanInterface)this.createBean(ApprovalRouteReferenceBeanInterface.class);
        this.routeUnitReference = (ApprovalRouteUnitReferenceBeanInterface)this.createBean(ApprovalRouteUnitReferenceBeanInterface.class);
        this.unitReference = (ApprovalUnitReferenceBeanInterface)this.createBean(ApprovalUnitReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.concurrentReference = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        this.userMasterReference = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.userExtraRoleRefer = (UserExtraRoleReferenceBeanInterface)this.createBean(UserExtraRoleReferenceBeanInterface.class);
        this.positionReference = (PositionReferenceBeanInterface)this.createBean(PositionReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.subApproverReference = (SubApproverReferenceBeanInterface)this.createBean(SubApproverReferenceBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBean(PlatformMasterBeanInterface.class);
    }

    public WorkflowDtoInterface getLatestWorkflowInfo(long workflow) throws MospException {
        return this.workflowReference.getLatestWorkflowInfo(workflow);
    }

    public List<List<String[]>> getRouteApproverList(String personalId, Date targetDate, int workflowType) throws MospException {
        ArrayList<List<String[]>> routeApproverList = new ArrayList<List<String[]>>();
        RouteApplicationDtoInterface routeApplicationDto = this.platformMaster.getRouteApplication(personalId, targetDate, workflowType);
        if (routeApplicationDto == null) {
            return routeApproverList;
        }
        String routeCode = routeApplicationDto.getRouteCode();
        if (routeCode.equals("SELF_APPRO")) {
            routeApproverList.add(this.getSelfApproverList());
            return routeApproverList;
        }
        ApprovalRouteDtoInterface routeDto = this.routeReference.getApprovalRouteInfo(routeCode, targetDate);
        if (routeDto == null) {
            return routeApproverList;
        }
        List unitList = this.routeUnitReference.getApprovalRouteUnitList(routeCode, targetDate);
        HumanPositionGradeComparator comparator = this.getPositionGradeComparator(targetDate);
        for (ApprovalRouteUnitDtoInterface routeUnitDto : unitList) {
            List unitApproverList = this.getUnitApproverList(routeUnitDto.getUnitCode(), targetDate);
            Collections.sort(unitApproverList, comparator);
            routeApproverList.add(this.getApproverList(unitApproverList, personalId, targetDate, workflowType));
        }
        return routeApproverList;
    }

    public HumanPositionGradeComparator getPositionGradeComparator(Date targetDate) throws MospException {
        Map positionMap = this.positionReference.getPositionMap(targetDate, null);
        boolean hasLowGradeAdvantage = this.positionReference.hasLowGradeAdvantage();
        return new HumanPositionGradeComparator(positionMap, hasLowGradeAdvantage);
    }

    public Set<String> getApproverRouteSet(String personalId, Date targetDate) throws MospException {
        HashSet<String> set = new HashSet<String>();
        for (String unitCode : this.getApproverUnitSet(personalId, targetDate)) {
            set.addAll(this.routeUnitReference.getRouteSetForUnit(unitCode, targetDate));
        }
        return set;
    }

    public Set<String> getApproverUnitSet(String personalId, Date targetDate) throws MospException {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.unitReference.getUnitSetForPersonalId(personalId, targetDate));
        HumanDtoInterface humanDto = this.getHumanInfo(personalId, targetDate);
        if (humanDto == null) {
            return set;
        }
        String section = humanDto.getSectionCode();
        String position = humanDto.getPositionCode();
        set.addAll(this.unitReference.getUnitSetForMaster(section, position, targetDate));
        List concurrentList = this.concurrentReference.getConcurrentList(personalId, targetDate);
        for (ConcurrentDtoInterface concurrentDto : concurrentList) {
            section = concurrentDto.getSectionCode();
            position = concurrentDto.getPositionCode();
            set.addAll(this.unitReference.getUnitSetForMaster(section, position, targetDate));
        }
        return set;
    }

    public String getWorkflowStatus(String status, int stage) {
        if ("0".equals(status)) {
            return this.getNameDraft();
        }
        if ("1".equals(status)) {
            return this.getNameNotApproved();
        }
        if ("4".equals(status)) {
            return this.getNameRelease();
        }
        if ("5".equals(status)) {
            return this.getNameWithdraw();
        }
        if ("9".equals(status)) {
            return this.getNameFinish();
        }
        if ("6".equals(status) || "7".equals(status)) {
            return this.getNameCancelAppli();
        }
        if ("2".equals(status)) {
            return this.getNameStageApprove(stage - 1);
        }
        if ("3".equals(status)) {
            return this.getNameStageRemand(stage + 1);
        }
        return status;
    }

    public String getWorkflowOperation(String status) {
        if ("0".equals(status)) {
            return this.getNameDraft();
        }
        if (status.equals("1")) {
            return this.getNameApply();
        }
        if (status.equals("2")) {
            return this.getNameApprove();
        }
        if (status.equals("3")) {
            return this.getNameRemand();
        }
        if (status.equals("4")) {
            return this.getNameRelease();
        }
        if (status.equals("5")) {
            return this.getNameWithdraw();
        }
        if (status.equals("9")) {
            return this.getNameApprove();
        }
        if (status.equals("6") || status.equals("7")) {
            return this.getNameApply();
        }
        return status;
    }

    public boolean isApprover(WorkflowDtoInterface dto, String personalId) throws MospException {
        HashMap routeUnitMap = new HashMap();
        HashSet approverSet = new HashSet();
        HashSet notApproverSet = new HashSet();
        return this.isApprover(dto, personalId, routeUnitMap, approverSet, notApproverSet);
    }

    protected boolean isApprover(WorkflowDtoInterface dto, String personalId, Map<String, List<ApprovalRouteUnitDtoInterface>> routeUnitMap, Set<String> approverSet, Set<String> notApproverSet) throws MospException {
        if (dto.getWorkflowStage() == 0) {
            return false;
        }
        if (dto.getWorkflowStatus().equals("0") || dto.getWorkflowStatus().equals("5")) {
            return false;
        }
        List approverStageList = this.getApproverStageList(dto, personalId, routeUnitMap, approverSet, notApproverSet);
        return approverStageList.contains(dto.getWorkflowStage());
    }

    public boolean isOneOfApprover(WorkflowDtoInterface dto, String personalId) throws MospException {
        if ((dto.getApproverId().equals("SELF_APPRO") || dto.getRouteCode().equals("SELF_APPRO")) && dto.getPersonalId().equals(personalId)) {
            return true;
        }
        if (!dto.getApproverId().isEmpty()) {
            String[] approverArray;
            for (String element : approverArray = this.split(dto.getApproverId(), ",")) {
                if (!element.equals(personalId)) continue;
                return true;
            }
            return false;
        }
        Date systemDate = this.getSystemDate();
        List routeUnitList = this.routeUnitReference.getApprovalRouteUnitList(dto.getRouteCode(), systemDate);
        for (ApprovalRouteUnitDtoInterface routeUnitDto : routeUnitList) {
            List humanList = this.getUnitApproverList(routeUnitDto.getUnitCode(), systemDate);
            for (HumanDtoInterface humanDto : humanList) {
                if (!personalId.equals(humanDto.getPersonalId())) continue;
                return true;
            }
        }
        return false;
    }

    protected List<Integer> getApproverStageList(WorkflowDtoInterface dto, String personalId, Map<String, List<ApprovalRouteUnitDtoInterface>> routeUnitMap, Set<String> approverSet, Set<String> notApproverSet) throws MospException {
        ArrayList<Integer> stageList = new ArrayList<Integer>();
        if (!dto.getApproverId().isEmpty()) {
            String[] approverArray = this.split(dto.getApproverId(), ",");
            for (int i = 0; i < approverArray.length; ++i) {
                if (!approverArray[i].equals(personalId)) continue;
                stageList.add(++i);
            }
            return stageList;
        }
        Date systemDate = this.getSystemDate();
        String routeCode = dto.getRouteCode();
        List routeUnitList = routeUnitMap.get(routeCode);
        if (routeUnitList == null) {
            routeUnitList = this.routeUnitReference.getApprovalRouteUnitList(routeCode, systemDate);
            routeUnitMap.put(routeCode, routeUnitList);
        }
        for (ApprovalRouteUnitDtoInterface routeUnitDto : routeUnitList) {
            String unitCode = routeUnitDto.getUnitCode();
            if (approverSet.contains(unitCode)) {
                stageList.add(routeUnitDto.getApprovalStage());
                continue;
            }
            if (notApproverSet.contains(unitCode)) continue;
            Set unitApproverSet = this.getUnitApproverSet(unitCode, systemDate);
            if (unitApproverSet.contains(personalId)) {
                approverSet.add(unitCode);
                stageList.add(routeUnitDto.getApprovalStage());
                continue;
            }
            notApproverSet.add(unitCode);
        }
        return stageList;
    }

    protected Set<String> getUnitApproverSet(String unitCode, Date targetDate) throws MospException {
        HashSet<String> set = new HashSet<String>();
        ApprovalUnitDtoInterface unitDto = this.unitReference.getApprovalUnitInfo(unitCode, targetDate);
        if ("person".equals(unitDto.getUnitType())) {
            set.addAll(this.asList(unitDto.getApproverPersonalId(), ","));
        }
        if ("section".equals(unitDto.getUnitType())) {
            this.humanSearch.setTargetDate(targetDate);
            this.humanSearch.setSectionCode(unitDto.getApproverSectionCode());
            this.humanSearch.setPositionCode(unitDto.getApproverPositionCode());
            this.humanSearch.setPositionGradeRange(unitDto.getApproverPositionGrade());
            this.humanSearch.setNeedConcurrent(true);
            set.addAll(this.humanSearch.getPersonalIdSet());
        }
        return set;
    }

    public List<HumanDtoInterface> getUnitApproverList(String unitCode, Date targetDate) throws MospException {
        List<Object> searchList = new ArrayList<HumanDtoInterface>();
        ApprovalUnitDtoInterface unitDto = this.unitReference.getApprovalUnitInfo(unitCode, targetDate);
        if ("person".equals(unitDto.getUnitType())) {
            String[] approverIdArray;
            for (String approverId : approverIdArray = this.split(unitDto.getApproverPersonalId(), ",")) {
                HumanDtoInterface approverDto = this.humanReference.getHumanInfo(approverId, targetDate);
                if (approverDto == null) continue;
                searchList.add(approverDto);
            }
        }
        if ("section".equals(unitDto.getUnitType())) {
            this.humanSearch.setTargetDate(targetDate);
            this.humanSearch.setSectionCode(unitDto.getApproverSectionCode());
            this.humanSearch.setPositionCode(unitDto.getApproverPositionCode());
            this.humanSearch.setPositionGradeRange(unitDto.getApproverPositionGrade());
            this.humanSearch.setNeedConcurrent(true);
            searchList = this.humanSearch.search();
        }
        ArrayList<HumanDtoInterface> approverList = new ArrayList<HumanDtoInterface>();
        Set approverRoleSet = RoleUtility.getApproverRoles((MospParams)this.mospParams);
        for (HumanDtoInterface approver : searchList) {
            if (!this.isValidApprover(approver.getPersonalId(), targetDate, approverRoleSet)) continue;
            approverList.add(approver);
        }
        if (approverList.isEmpty()) {
            this.addUnitNotHaveApproverMessage(unitDto.getUnitCode(), targetDate);
        }
        return approverList;
    }

    protected boolean isValidApprover(String psersonalId, Date targetDate, Set<String> approverRoleSet) throws MospException {
        if (!this.isEntered(psersonalId, targetDate) || this.retirementReference.isRetired(psersonalId, targetDate) || this.suspensionReference.isSuspended(psersonalId, targetDate)) {
            return false;
        }
        List userList = this.userMasterReference.getUserListForPersonalId(psersonalId, targetDate);
        for (UserMasterDtoInterface user : userList) {
            if (!this.userExtraRoleRefer.isTheRoleCodeSet(user, approverRoleSet)) continue;
            return true;
        }
        return false;
    }

    protected List<String[]> getApproverList(List<HumanDtoInterface> list, String personalId, Date targetDate, int workflowType) throws MospException {
        ArrayList<String[]> approverList = new ArrayList<String[]>();
        for (HumanDtoInterface approver : list) {
            approverList.add(this.getApproverOption(approver));
        }
        return approverList;
    }

    protected List<String[]> getSelfApproverList() {
        ArrayList<String[]> approverList = new ArrayList<String[]>();
        approverList.add(new String[]{"SELF_APPRO", this.mospParams.getName("SelfApproval")});
        return approverList;
    }

    protected String[] getApproverOption(HumanDtoInterface dto) {
        String humanName = MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
        return new String[]{dto.getPersonalId(), this.getCodedName(dto.getEmployeeCode(), humanName, dto.getEmployeeCode().length())};
    }

    protected void addUnitNotHaveApproverMessage(String unitCode, Date targetDate) {
        String[] aryMeassage = new String[]{unitCode, this.getStringDate(targetDate)};
        this.mospParams.addErrorMessage("PFW0228", aryMeassage);
    }

    protected String getNameDraft() {
        return this.mospParams.getName("WorkPaper");
    }

    protected String getNameApply() {
        return this.mospParams.getName("Application");
    }

    protected String getNameApprove() {
        return this.mospParams.getName("Approval");
    }

    protected String getNameRemand() {
        return this.mospParams.getName("SendingBack");
    }

    protected String getNameWithdraw() {
        return this.mospParams.getName("TakeDown");
    }

    protected String getNameRelease() {
        return this.mospParams.getName("ApprovalRelease");
    }

    protected String getNameNotApproved() {
        return this.mospParams.getName("Ram") + this.mospParams.getName("Approval");
    }

    protected String getNameStageApprove(int stage) {
        return stage + this.mospParams.getName("Following") + this.mospParams.getName("Finish");
    }

    protected String getNameStageRemand(int stage) {
        return stage + this.mospParams.getName("Following") + this.mospParams.getName("Back");
    }

    protected String getNameFinish() {
        return this.mospParams.getName("Approval") + this.mospParams.getName("Finish");
    }

    protected String getNameCancelAppli() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Release"));
        sb.append(this.mospParams.getName("Register"));
        return sb.toString();
    }

    public List<WorkflowDtoInterface> getApprovableList(String personalId, Set<String> functionCodeSet) throws MospException {
        List approvableList = this.workflowReference.getApprovableList(functionCodeSet);
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return approvableList;
        }
        ArrayList<WorkflowDtoInterface> list = new ArrayList<WorkflowDtoInterface>();
        HashMap routeUnitMap = new HashMap();
        HashSet approverSet = new HashSet();
        HashSet notApproverSet = new HashSet();
        for (WorkflowDtoInterface dto : approvableList) {
            if (!this.isApprover(dto, personalId, routeUnitMap, approverSet, notApproverSet)) continue;
            list.add(dto);
        }
        return list;
    }

    public List<WorkflowDtoInterface> getCancelableList(String personalId, Set<String> functionCodeSet) throws MospException {
        List cancelableList = this.workflowReference.getCancelableList(functionCodeSet);
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return cancelableList;
        }
        ArrayList<WorkflowDtoInterface> list = new ArrayList<WorkflowDtoInterface>();
        HashMap routeUnitMap = new HashMap();
        HashSet approverSet = new HashSet();
        HashSet notApproverSet = new HashSet();
        for (WorkflowDtoInterface dto : cancelableList) {
            if (!this.isApprover(dto, personalId, routeUnitMap, approverSet, notApproverSet)) continue;
            list.add(dto);
        }
        return list;
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getApprovableMap(String personalId, Set<String> functionCodeSet) throws MospException {
        HashMap<String, Map<Long, WorkflowDtoInterface>> approvableMap = new HashMap<String, Map<Long, WorkflowDtoInterface>>();
        for (String function : functionCodeSet) {
            approvableMap.put(function, new HashMap());
        }
        List approvableList = this.getApprovableList(personalId, functionCodeSet);
        for (WorkflowDtoInterface dto : approvableList) {
            ((Map)approvableMap.get(dto.getFunctionCode())).put(dto.getWorkflow(), dto);
        }
        return approvableMap;
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getSubApprovableMap(String personalId, Set<String> functionCodeSet, int workflowType, Map<String, Map<Long, WorkflowDtoInterface>> approvableMap) throws MospException {
        HashMap<String, Map<Long, WorkflowDtoInterface>> subAapprovableMap = new HashMap<String, Map<Long, WorkflowDtoInterface>>();
        for (String function : functionCodeSet) {
            subAapprovableMap.put(function, new HashMap());
        }
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return subAapprovableMap;
        }
        List subApproverList = this.subApproverReference.findForSubApproverId(personalId, workflowType, this.getSystemDate(), this.getSystemDate());
        for (SubApproverDtoInterface subApproverDto : subApproverList) {
            List subAapprovableList = this.getApprovableList(subApproverDto.getPersonalId(), functionCodeSet);
            for (WorkflowDtoInterface dto : subAapprovableList) {
                if (approvableMap.get(dto.getFunctionCode()).containsKey(dto.getWorkflow())) continue;
                ((Map)subAapprovableMap.get(dto.getFunctionCode())).put(dto.getWorkflow(), dto);
            }
        }
        return subAapprovableMap;
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getCancelableMap(String personalId, Set<String> functionCodeSet) throws MospException {
        HashMap<String, Map<Long, WorkflowDtoInterface>> approvableMap = new HashMap<String, Map<Long, WorkflowDtoInterface>>();
        for (String function : functionCodeSet) {
            approvableMap.put(function, new HashMap());
        }
        List approvableList = this.getCancelableList(personalId, functionCodeSet);
        for (WorkflowDtoInterface dto : approvableList) {
            ((Map)approvableMap.get(dto.getFunctionCode())).put(dto.getWorkflow(), dto);
        }
        return approvableMap;
    }

    public Map<String, Map<Long, WorkflowDtoInterface>> getSubCancelableMap(String personalId, Set<String> functionCodeSet, int workflowType, Map<String, Map<Long, WorkflowDtoInterface>> approvableMap) throws MospException {
        HashMap<String, Map<Long, WorkflowDtoInterface>> subAapprovableMap = new HashMap<String, Map<Long, WorkflowDtoInterface>>();
        for (String function : functionCodeSet) {
            subAapprovableMap.put(function, new HashMap());
        }
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return subAapprovableMap;
        }
        List subApproverList = this.subApproverReference.findForSubApproverId(personalId, workflowType, this.getSystemDate(), this.getSystemDate());
        for (SubApproverDtoInterface subApproverDto : subApproverList) {
            List subAapprovableList = this.getCancelableList(subApproverDto.getPersonalId(), functionCodeSet);
            for (WorkflowDtoInterface dto : subAapprovableList) {
                if (approvableMap.get(dto.getFunctionCode()).containsKey(dto.getWorkflow())) continue;
                ((Map)subAapprovableMap.get(dto.getFunctionCode())).put(dto.getWorkflow(), dto);
            }
        }
        return subAapprovableMap;
    }

    public List<WorkflowDtoInterface> getEffectiveList(String personalId, Date fromDate, Date toDate, Set<String> functionCodeSet, String state, Set<String> personalIdSet, Set<String> subordinateIdSet) throws MospException {
        List effectiveList = state.equals("1") ? this.workflowReference.getNonApprovedList(fromDate, toDate, functionCodeSet) : (state.equals("9") ? this.workflowReference.getCompletedList(fromDate, toDate, functionCodeSet) : (state.equals("3") ? this.workflowReference.getRevertedList(fromDate, toDate, functionCodeSet) : (state.equals("6") || state.equals("7") ? this.workflowReference.getCancelAppliedList(fromDate, toDate, functionCodeSet) : this.workflowReference.getEffectiveList(fromDate, toDate, functionCodeSet))));
        ArrayList<WorkflowDtoInterface> searchList = new ArrayList<WorkflowDtoInterface>();
        for (WorkflowDtoInterface dto : effectiveList) {
            if (personalIdSet != null && !personalIdSet.contains(dto.getPersonalId())) continue;
            searchList.add(dto);
        }
        if (RoleUtility.isCalculator((MospParams)this.mospParams)) {
            return searchList;
        }
        ArrayList<WorkflowDtoInterface> list = new ArrayList<WorkflowDtoInterface>();
        for (WorkflowDtoInterface dto : searchList) {
            if (subordinateIdSet.contains(dto.getPersonalId())) {
                list.add(dto);
                continue;
            }
            if (!this.isOneOfApprover(dto, personalId)) continue;
            list.add(dto);
        }
        return list;
    }

    public List<WorkflowDtoInterface> getCompletedList(String personalId, Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.workflowReference.getCompletedList(personalId, fromDate, toDate, functionCodeSet);
    }

    public boolean isApprovable(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().equals("1")) {
            return true;
        }
        if (dto.getWorkflowStatus().equals("2")) {
            return true;
        }
        if (dto.getWorkflowStatus().equals("4")) {
            return true;
        }
        return dto.getWorkflowStatus().equals("3") && dto.getWorkflowStage() != 0;
    }

    public boolean isCancelApprovable(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("6");
    }

    public boolean isCancelWithDrawnApprovable(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("7");
    }

    public boolean isCompleted(long workflow) throws MospException {
        return this.isCompleted(this.workflowReference.getLatestWorkflowInfo(workflow));
    }

    public boolean isCompleted(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("9");
    }

    public boolean isWithDrawn(long workflow) throws MospException {
        return this.isWithDrawn(this.workflowReference.getLatestWorkflowInfo(workflow));
    }

    public boolean isWithDrawn(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("5");
    }

    public boolean isDraft(long workflow) throws MospException {
        return this.isDraft(this.workflowReference.getLatestWorkflowInfo(workflow));
    }

    public boolean isDraft(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("0");
    }

    public boolean isFirstReverted(long workflow) throws MospException {
        return this.isFirstReverted(this.workflowReference.getLatestWorkflowInfo(workflow));
    }

    public boolean isFirstReverted(WorkflowDtoInterface dto) {
        return dto.getWorkflowStatus().equals("3") && dto.getWorkflowStage() == 0;
    }

    public String[][][] getArrayForApproverSetting(String personalId, Date targetDate, int workflowType) throws MospException {
        List approvalRouteList = this.getRouteApproverList(personalId, targetDate, workflowType);
        if (this.mospParams.hasErrorMessage()) {
            return new String[0][][];
        }
        String[][][] aryApproverSetting = new String[approvalRouteList.size()][][];
        int approvalLevel = 0;
        for (List approverList : approvalRouteList) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            for (String[] approver : approverList) {
                list.add(approver);
            }
            aryApproverSetting[approvalLevel++] = (String[][])list.toArray((T[])new String[list.size()][]);
        }
        return aryApproverSetting;
    }
}

