/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowCommentDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PftWorkflowCommentDto;

public class WorkflowCommentRegistBean
extends PlatformBean
implements WorkflowCommentRegistBeanInterface {
    private WorkflowCommentDaoInterface dao;

    public WorkflowCommentRegistBean() {
    }

    public WorkflowCommentRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkflowCommentDaoInterface)this.createDao(WorkflowCommentDaoInterface.class);
    }

    public WorkflowCommentDtoInterface getInitDto() {
        return new PftWorkflowCommentDto();
    }

    public void insert(WorkflowCommentDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.validateInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPftWorkflowCommentId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void validateInsert(WorkflowCommentDtoInterface dto) {
    }

    protected void validate(WorkflowCommentDtoInterface dto) {
    }

    public void addComment(WorkflowDtoInterface dto, String personalId, String workflowComment) throws MospException {
        if (dto != null) {
            WorkflowCommentDtoInterface commentDto = this.getInitDto();
            commentDto.setPersonalId(personalId);
            commentDto.setWorkflow(dto.getWorkflow());
            commentDto.setWorkflowStage(dto.getWorkflowStage());
            commentDto.setWorkflowStatus(dto.getWorkflowStatus());
            commentDto.setWorkflowComment(workflowComment);
            commentDto.setWorkflowDate(this.getSystemTimeAndSecond());
            this.insert(commentDto);
        }
    }

    public void deleteList(List<WorkflowCommentDtoInterface> list) throws MospException {
        for (WorkflowCommentDtoInterface dto : list) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftWorkflowCommentId());
        }
    }
}

