/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverSearchBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.workflow.SubApproverDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.SubApproverDtoInterface;
import jp.mosp.platform.dto.workflow.SubApproverListDtoInterface;
import jp.mosp.platform.dto.workflow.impl.SubApproverListDto;
import jp.mosp.platform.utils.MonthUtility;

public class SubApproverSearchBean
extends PlatformHumanBean
implements SubApproverSearchBeanInterface {
    protected SubApproverDaoInterface dao;
    private String personalId;
    private int targetYear;
    private int targetMonth;
    private String sectionName;
    private String employeeName;
    private String inactivateFlag;

    public SubApproverSearchBean() {
    }

    protected SubApproverSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (SubApproverDaoInterface)this.createDao(SubApproverDaoInterface.class);
    }

    public List<SubApproverListDtoInterface> getSearchList() throws MospException {
        Map param = this.dao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("startDate", MonthUtility.getYearMonthTermFirstDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams));
        param.put("endDate", MonthUtility.getYearMonthTermLastDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams));
        param.put("sectionName", this.sectionName);
        param.put("employeeName", this.employeeName);
        param.put("inactivateFlag", this.inactivateFlag);
        List list = this.dao.findForSearch(param);
        ArrayList<SubApproverListDtoInterface> searchList = new ArrayList<SubApproverListDtoInterface>();
        HumanDaoInterface humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        SectionReferenceBeanInterface section = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        String[][] sectionArray = section.getNameSelectArray(MonthUtility.getYearMonthTargetDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams), false, null);
        for (SubApproverDtoInterface dto : list) {
            SubApproverListDtoInterface listDto = this.getListDto(dto);
            HumanDtoInterface humanDto = humanDao.findForInfo(dto.getSubApproverId(), dto.getStartDate());
            if (humanDto != null) {
                listDto.setSubApproverCode(humanDto.getEmployeeCode());
                listDto.setSubApproverName(this.getHumanName(humanDto));
                listDto.setSubApproverSectionCode(humanDto.getSectionCode());
                listDto.setSubApproverSectionName(this.getCodeName(humanDto.getSectionCode(), sectionArray));
            }
            searchList.add(listDto);
        }
        return searchList;
    }

    protected SubApproverListDtoInterface getListDto(SubApproverDtoInterface dto) {
        SubApproverListDto listDto = new SubApproverListDto();
        listDto.setSubApproverNo(dto.getSubApproverNo());
        listDto.setPersonalId(dto.getPersonalId());
        listDto.setWorkflowType(dto.getWorkflowType());
        listDto.setStartDate(dto.getStartDate());
        listDto.setEndDate(dto.getEndDate());
        listDto.setSubApproverId(dto.getSubApproverId());
        listDto.setInactivateFlag(dto.getInactivateFlag());
        listDto.setSubApproverCode("");
        listDto.setSubApproverName("");
        listDto.setSubApproverSectionCode("");
        listDto.setSubApproverSectionName("");
        return listDto;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setTargetYear(int targetYear) {
        this.targetYear = targetYear;
    }

    public void setTargetMonth(int targetMonth) {
        this.targetMonth = targetMonth;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }
}

