/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationRegistBeanInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmRouteApplicationDto;

public class RouteApplicationRegistBean
extends PlatformBean
implements RouteApplicationRegistBeanInterface {
    private RouteApplicationDaoInterface dao;
    HumanReferenceBeanInterface human;
    protected PlatformMasterCheckBeanInterface masterCheck;
    protected RouteApplicationReferenceBeanInterface routeApplicationReference;

    public RouteApplicationRegistBean() {
    }

    public RouteApplicationRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (RouteApplicationDaoInterface)this.createDao(RouteApplicationDaoInterface.class);
        this.masterCheck = (PlatformMasterCheckBeanInterface)this.createBean(PlatformMasterCheckBeanInterface.class);
        this.routeApplicationReference = (RouteApplicationReferenceBeanInterface)this.createBean(RouteApplicationReferenceBeanInterface.class);
    }

    public RouteApplicationDtoInterface getInitDto() {
        return new PfmRouteApplicationDto();
    }

    public void add(RouteApplicationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmRouteApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(RouteApplicationDtoInterface dto) throws MospException {
        dto.setPfmRouteApplicationId(this.getRecordID(dto));
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmRouteApplicationId());
    }

    public void insert(RouteApplicationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmRouteApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(RouteApplicationDtoInterface dto) throws MospException {
        dto.setPfmRouteApplicationId(this.getRecordID(dto));
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmRouteApplicationId());
        dto.setPfmRouteApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            RouteApplicationDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmRouteApplicationId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmRouteApplicationId());
            dto.setPfmRouteApplicationId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            RouteApplicationDtoInterface dto = (RouteApplicationDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getRouteApplicationCode());
        }
        return list;
    }

    private void checkAdd(RouteApplicationDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getRouteApplicationCode(), dto.getActivateDate()));
        this.checkSettingDuplicate(dto, false);
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getRouteApplicationCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    private void validate(RouteApplicationDtoInterface dto) throws MospException {
        this.revisionPersonalIds(dto);
        if (dto.getInactivateFlag() == 1) {
            return;
        }
        List list = this.routeApplicationReference.getRouteApplicationHistory(dto.getRouteApplicationCode());
        Date startDate = dto.getActivateDate();
        Date endDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.masterCheck.isCheckSection(dto.getSectionCode(), startDate, endDate);
        this.masterCheck.isCheckPosition(dto.getPositionCode(), startDate, endDate);
        this.masterCheck.isCheckEmploymentContract(dto.getEmploymentContractCode(), startDate, endDate);
        this.masterCheck.isCheckWorkPlace(dto.getWorkPlaceCode(), startDate, endDate);
    }

    protected void revisionPersonalIds(RouteApplicationDtoInterface dto) {
        if (dto.getRouteApplicationType() == Integer.parseInt("0")) {
            return;
        }
        dto.setPersonalIds(this.overlapValue(dto.getPersonalIds(), ","));
    }

    private void checkDelete(RouteApplicationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmRouteApplicationId());
        this.checkMasterDelete(dto);
        this.checkSettingDuplicate(dto, true);
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmRouteApplicationId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getRouteApplicationCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    private void checkMasterDelete(RouteApplicationDtoInterface dto) throws MospException {
        RouteApplicationDtoInterface beforeDto = this.routeApplicationReference.getRouteApplicationInfo(dto.getRouteApplicationCode(), DateUtility.addDay((Date)dto.getActivateDate(), (int)-1));
        if (beforeDto == null || beforeDto.getInactivateFlag() == 1) {
            return;
        }
        List list = this.routeApplicationReference.getRouteApplicationHistory(dto.getRouteApplicationCode());
        Date startDate = beforeDto.getActivateDate();
        Date endDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.masterCheck.isCheckSection(beforeDto.getSectionCode(), startDate, endDate);
        this.masterCheck.isCheckPosition(beforeDto.getPositionCode(), startDate, endDate);
        this.masterCheck.isCheckEmploymentContract(beforeDto.getEmploymentContractCode(), startDate, endDate);
        this.masterCheck.isCheckWorkPlace(beforeDto.getWorkPlaceCode(), startDate, endDate);
    }

    private void checkInsert(RouteApplicationDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getRouteApplicationCode()));
        this.checkSettingDuplicate(dto, false);
    }

    private void checkUpdate(RouteApplicationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmRouteApplicationId());
        this.checkSettingDuplicate(dto, false);
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmRouteApplicationId(), true))) {
            return;
        }
    }

    private long getRecordID(RouteApplicationDtoInterface dto) throws MospException {
        RouteApplicationDtoInterface subDto = this.dao.findForKey(dto.getRouteApplicationCode(), dto.getActivateDate());
        return subDto.getPfmRouteApplicationId();
    }

    protected void checkSettingDuplicate(RouteApplicationDtoInterface dto, boolean isCheckDelete) throws MospException {
        Date endDate = null;
        RouteApplicationDtoInterface latterDto = this.dao.findLatterInfo(dto.getRouteApplicationCode(), dto.getActivateDate());
        if (latterDto != null) {
            endDate = latterDto.getActivateDate();
        }
        RouteApplicationDtoInterface targetDto = dto;
        if (isCheckDelete) {
            targetDto = this.dao.findFormerInfo(dto.getRouteApplicationCode(), dto.getActivateDate());
        }
        if (targetDto == null || !this.isDtoActivate((BaseDtoInterface)targetDto)) {
            return;
        }
        if (targetDto.getRouteApplicationType() == Integer.parseInt("0")) {
            this.checkMasterDuplicate(targetDto, endDate);
        } else {
            for (String personalId : this.asList(targetDto.getPersonalIds(), ",")) {
                this.checkPersonDuplicate(targetDto.getRouteApplicationCode(), targetDto.getActivateDate(), personalId, endDate, targetDto.getWorkflowType());
            }
        }
    }

    protected void checkMasterDuplicate(RouteApplicationDtoInterface dto, Date endDate) throws MospException {
        RouteApplicationDtoInterface currentDto = this.dao.findForMaster(dto.getActivateDate(), dto.getWorkflowType(), dto.getWorkPlaceCode(), dto.getEmploymentContractCode(), dto.getSectionCode(), dto.getPositionCode());
        if (currentDto != null && !dto.getRouteApplicationCode().equals(currentDto.getRouteApplicationCode())) {
            this.addMasterDuplicateMessage(currentDto.getRouteApplicationCode());
            return;
        }
        List list = this.dao.findMasterDuplicated(dto.getActivateDate(), endDate, dto.getWorkPlaceCode(), dto.getEmploymentContractCode(), dto.getSectionCode(), dto.getPositionCode(), dto.getWorkflowType());
        for (RouteApplicationDtoInterface targetDto : list) {
            if (dto.getRouteApplicationCode().equals(targetDto.getRouteApplicationCode())) continue;
            this.addMasterDuplicateMessage(targetDto.getRouteApplicationCode());
            return;
        }
    }

    protected void checkPersonDuplicate(String applicationCode, Date activateDate, String personalId, Date endDate, int workflowType) throws MospException {
        RouteApplicationDtoInterface currentDto = this.dao.findForPersonalId(personalId, activateDate, workflowType);
        if (currentDto != null && !applicationCode.equals(currentDto.getRouteApplicationCode())) {
            this.addPersonDuplicateMessage(currentDto.getRouteApplicationCode(), currentDto.getActivateDate(), personalId);
            return;
        }
        List list = this.dao.findPersonDuplicated(activateDate, endDate, personalId, workflowType);
        for (RouteApplicationDtoInterface latterDto : list) {
            if (applicationCode.equals(latterDto.getRouteApplicationCode())) continue;
            this.addPersonDuplicateMessage(latterDto.getRouteApplicationCode(), latterDto.getActivateDate(), personalId);
            return;
        }
    }

    protected void addPersonDuplicateMessage(String applicationCode, Date activateDate, String personalId) throws MospException {
        if (this.human == null) {
            this.human = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        }
        String employeeCode = this.human.getEmployeeCode(personalId, activateDate);
        this.mospParams.addErrorMessage("PFW0224", new String[]{employeeCode, applicationCode});
    }

    protected void addMasterDuplicateMessage(String applicationCode) {
        this.mospParams.addErrorMessage("PFW0225", new String[]{applicationCode});
    }
}

