/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalRouteDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;

public class ApprovalRouteReferenceBean
extends PlatformBean
implements ApprovalRouteReferenceBeanInterface {
    private ApprovalRouteDaoInterface dao;

    public ApprovalRouteReferenceBean() {
    }

    public ApprovalRouteReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ApprovalRouteDaoInterface)this.createDao(ApprovalRouteDaoInterface.class);
    }

    public ApprovalRouteDtoInterface findForKey(String routeCode, Date activateDate) throws MospException {
        return this.dao.findForKey(routeCode, activateDate);
    }

    public List<ApprovalRouteDtoInterface> getApprovalRouteHistory(String routeCode) throws MospException {
        return this.dao.findForHistory(routeCode);
    }

    public ApprovalRouteDtoInterface getApprovalRouteInfo(String routeCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(routeCode, targetDate);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            if (needBlank) {
                return this.getDefaultRoutePulldown();
            }
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        if (needBlank) {
            array[0][0] = "SELF_APPRO";
            array[0][1] = this.getSelfApprovalName();
        }
        int idx = needBlank ? 1 : 0;
        int codeLength = 0;
        for (ApprovalRouteDtoInterface dto : list) {
            if (dto.getRouteCode().length() <= codeLength) continue;
            codeLength = dto.getRouteCode().length();
        }
        for (ApprovalRouteDtoInterface dto : list) {
            array[idx][0] = dto.getRouteCode();
            array[idx][1] = this.getCodedName(dto.getRouteCode(), dto.getRouteName(), codeLength);
            ++idx;
        }
        return array;
    }

    public String getRouteName(String routeCode, Date targetDate) throws MospException {
        if ("SELF_APPRO".equals(routeCode)) {
            return this.getSelfApprovalName();
        }
        ApprovalRouteDtoInterface dto = this.getApprovalRouteInfo(routeCode, targetDate);
        if (dto == null) {
            return routeCode;
        }
        return dto.getRouteName();
    }

    protected String[][] getDefaultRoutePulldown() {
        String[][] aryPulldown = new String[][]{{"SELF_APPRO", this.getSelfApprovalName()}};
        return aryPulldown;
    }

    protected String getSelfApprovalName() {
        return this.mospParams.getProperties().getName("SelfApproval");
    }
}

