/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleRegistBeanInterface;
import jp.mosp.platform.dao.system.UserExtraRoleDaoInterface;
import jp.mosp.platform.dto.system.UserExtraRoleDtoInterface;
import jp.mosp.platform.dto.system.impl.PfaUserExtraRoleDto;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class UserExtraRoleRegistBean
extends PlatformBean
implements UserExtraRoleRegistBeanInterface {
    protected UserExtraRoleDaoInterface dao;
    protected UserCheckBeanInterface userCheck;

    public UserExtraRoleRegistBean() {
    }

    public UserExtraRoleRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (UserExtraRoleDaoInterface)this.createDao(UserExtraRoleDaoInterface.class);
        this.userCheck = (UserCheckBeanInterface)this.createBean(UserCheckBeanInterface.class);
    }

    public UserExtraRoleDtoInterface getInitDto() {
        return new PfaUserExtraRoleDto();
    }

    public Set<UserExtraRoleDtoInterface> getInitDtos(int number) {
        LinkedHashSet<UserExtraRoleDtoInterface> set = new LinkedHashSet<UserExtraRoleDtoInterface>();
        for (int i = 0; i < number; ++i) {
            set.add((UserExtraRoleDtoInterface)new PfaUserExtraRoleDto());
        }
        return set;
    }

    public void regist(Collection<UserExtraRoleDtoInterface> dtos) throws MospException {
        if (dtos.isEmpty()) {
            return;
        }
        UserExtraRoleDtoInterface firstDto = dtos.iterator().next();
        this.delete(firstDto.getUserId(), firstDto.getActivateDate());
        for (UserExtraRoleDtoInterface dto : dtos) {
            String roleCode = dto.getRoleCode();
            if (roleCode == null || roleCode.isEmpty()) continue;
            this.regist(dto);
        }
    }

    public void delete(String userId, Date activateDate) throws MospException {
        List dtos = this.dao.findForUser(userId, activateDate);
        for (UserExtraRoleDtoInterface dto : dtos) {
            this.delete(dto);
        }
    }

    public void deleteForRoleType(String roleType) throws MospException {
        List dtos = this.dao.findForRoleType(roleType);
        for (UserExtraRoleDtoInterface dto : dtos) {
            this.delete(dto);
        }
    }

    public void copy(String userId, Date fromActivateDate, Date toActivateDate) throws MospException {
        List dtos = this.dao.findForUser(userId, fromActivateDate);
        for (UserExtraRoleDtoInterface dto : dtos) {
            dto.setActivateDate(toActivateDate);
        }
        this.regist((Collection)dtos);
    }

    protected void regist(UserExtraRoleDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaUserExtraRoleId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void delete(UserExtraRoleDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaUserExtraRoleId());
    }

    public void validate(UserExtraRoleDtoInterface dto, Integer row) throws MospException {
        String nameUserId = PlatformNamingUtility.userId((MospParams)this.mospParams);
        String nameActivateDate = PlatformNamingUtility.activateDate((MospParams)this.mospParams);
        String nameRoleType = PlatformNamingUtility.roleType((MospParams)this.mospParams);
        String nameRoleCode = PlatformNamingUtility.roleCode((MospParams)this.mospParams);
        String userId = dto.getUserId();
        Date activateDate = dto.getActivateDate();
        String roleType = dto.getRoleType();
        String roleCode = dto.getRoleCode();
        this.checkRequired((Object)userId, nameUserId, row);
        this.checkRequired((Object)activateDate, nameActivateDate, row);
        this.checkRequired((Object)dto.getRoleType(), nameRoleType, row);
        this.checkRequired((Object)dto.getRoleCode(), nameRoleCode, row);
        this.userCheck.checkUserExist(userId, activateDate, row);
        this.userCheck.checkRoleTypeExist(roleType, activateDate, row);
        this.userCheck.checkRoleExist(roleType, roleCode, activateDate, row);
    }

    public void validate(UserExtraRoleDtoInterface dto) throws MospException {
        this.validate(dto, null);
    }
}

