/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.CheckAfterRegistUserBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dto.system.UserExtraRoleDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class UserAccountRegistBean
extends PlatformBean
implements UserAccountRegistBeanInterface {
    protected static final String APP_BEANS = "BeansCheckAfterRegistUser";
    protected UserMasterRegistBeanInterface userRegist;
    protected UserExtraRoleRegistBeanInterface extraRoleRegist;
    protected UserPasswordRegistBeanInterface passwordRegist;
    protected UserMasterReferenceBeanInterface userRefer;
    protected RoleReferenceBeanInterface roleRefer;

    public UserAccountRegistBean() {
    }

    public UserAccountRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userRegist = (UserMasterRegistBeanInterface)this.createBean(UserMasterRegistBeanInterface.class);
        this.extraRoleRegist = (UserExtraRoleRegistBeanInterface)this.createBean(UserExtraRoleRegistBeanInterface.class);
        this.passwordRegist = (UserPasswordRegistBeanInterface)this.createBean(UserPasswordRegistBeanInterface.class);
        this.userRefer = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
    }

    public UserMasterDtoInterface getInitUserDto() {
        return this.userRegist.getInitDto();
    }

    public Set<UserExtraRoleDtoInterface> getInitExtraRoleDtos(int number) {
        return this.extraRoleRegist.getInitDtos(number);
    }

    public UserExtraRoleDtoInterface getInitExtraRoleDto() {
        return this.extraRoleRegist.getInitDto();
    }

    public void insert(UserMasterDtoInterface userDto, boolean needExtraRoles) throws MospException {
        this.insert(userDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String userId = userDto.getUserId();
        Date activateDate = userDto.getActivateDate();
        if (needExtraRoles) {
            this.extraRoleRegist.regist((Collection)this.getDefaultExtraRoleDtos(userId, activateDate));
        }
        this.checkAfterRegist();
    }

    public void insert(UserMasterDtoInterface userDto, Set<UserExtraRoleDtoInterface> extraRoleDtos) throws MospException {
        this.insert(userDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.extraRoleRegist.regist(extraRoleDtos);
        this.checkAfterRegist();
    }

    public void insert(UserMasterDtoInterface userDto, Set<UserExtraRoleDtoInterface> extraRoleDtos, String password) throws MospException {
        this.userRegist.insert(userDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String userId = userDto.getUserId();
        Date activateDate = userDto.getActivateDate();
        this.passwordRegist.regist(userId, this.getChangeDate(activateDate), password);
        this.extraRoleRegist.regist(extraRoleDtos);
        this.checkAfterRegist();
    }

    public void add(UserMasterDtoInterface userDto, Set<UserExtraRoleDtoInterface> extraRoleDtos) throws MospException {
        this.userRegist.add(userDto);
        this.extraRoleRegist.regist(extraRoleDtos);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAfterRegist();
    }

    public void update(UserMasterDtoInterface userDto, Set<UserExtraRoleDtoInterface> extraRoleDtos) throws MospException {
        this.userRegist.update(userDto);
        this.extraRoleRegist.regist(extraRoleDtos);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAfterRegist();
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String userId : this.getUserIds(idArray)) {
            this.update(userId, activateDate, (Object)inactivateFlag);
        }
        this.checkAfterRegist();
    }

    public void update(long[] idArray, Date activateDate, String roleCode) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String userId : this.getUserIds(idArray)) {
            this.update(userId, activateDate, (Object)roleCode);
        }
        this.checkAfterRegist();
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.delete((Collection)this.getUserDtos(idArray));
    }

    public void delete(String personalId) throws MospException {
        this.delete((Collection)this.userRefer.getUserHistoryForPersonalId(personalId));
    }

    public void regist(Collection<UserMasterDtoInterface> userDtos) throws MospException {
        for (UserMasterDtoInterface userDto : userDtos) {
            if (userDto == null) continue;
            this.regist(userDto);
        }
        this.checkAfterRegist();
    }

    public void initPassword(long[] idArray) throws MospException {
        this.passwordRegist.initPassword(this.getUserIds(idArray));
    }

    public void updatePassword(String userId, String password) throws MospException {
        UserPasswordDtoInterface dto = this.passwordRegist.getInitDto();
        dto.setUserId(userId);
        dto.setPassword(password);
        dto.setChangeDate(this.getSystemDate());
        this.passwordRegist.regist(dto);
    }

    public void validate(UserMasterDtoInterface userDto, Integer row) throws MospException {
        this.userRegist.validate(userDto, row);
    }

    public void checkAfterRegist() throws MospException {
        String[] classNames;
        for (String className : classNames = this.mospParams.getApplicationProperties(APP_BEANS)) {
            CheckAfterRegistUserBeanInterface bean = (CheckAfterRegistUserBeanInterface)this.createBean(className);
            bean.check();
        }
    }

    protected void insert(UserMasterDtoInterface userDto) throws MospException {
        this.userRegist.insert(userDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String userId = userDto.getUserId();
        Date activateDate = userDto.getActivateDate();
        this.passwordRegist.initPassword(userId, this.getChangeDate(activateDate));
    }

    protected void regist(UserMasterDtoInterface userDto) throws MospException {
        String userId = userDto.getUserId();
        Date activateDate = userDto.getActivateDate();
        List list = this.userRefer.getUserHistory(userId);
        if (list.isEmpty()) {
            this.insert(userDto);
            return;
        }
        Date latestActivateDate = PlatformUtility.getLatestActivateDate((List)list, (Date)activateDate);
        if (DateUtility.isSame((Date)activateDate, (Date)latestActivateDate)) {
            this.userRegist.update(userDto);
            return;
        }
        this.userRegist.add(userDto);
        if (latestActivateDate != null) {
            this.extraRoleRegist.copy(userId, latestActivateDate, activateDate);
        }
    }

    protected void update(String userId, Date activateDate, Object object) throws MospException {
        UserMasterDtoInterface userDto = this.userRefer.getUserInfo(userId, activateDate);
        if (userDto == null) {
            PlatformMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)userId);
            return;
        }
        this.setUpdateParam(userDto, object);
        if (DateUtility.isSame((Date)activateDate, (Date)userDto.getActivateDate())) {
            this.userRegist.update(userDto);
            return;
        }
        Date fromActivateDate = userDto.getActivateDate();
        userDto.setActivateDate(activateDate);
        this.userRegist.add(userDto);
        this.extraRoleRegist.copy(userId, fromActivateDate, activateDate);
    }

    protected void setUpdateParam(UserMasterDtoInterface userDto, Object object) {
        String param = String.valueOf(object);
        if (object instanceof String) {
            userDto.setRoleCode(param);
        }
        if (object instanceof Integer) {
            userDto.setInactivateFlag(MospUtility.getInt((Object)param));
        }
    }

    protected void delete(Collection<UserMasterDtoInterface> userDtos) throws MospException {
        for (UserMasterDtoInterface dto : userDtos) {
            this.delete(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAfterRegist();
    }

    protected void delete(UserMasterDtoInterface userDto) throws MospException {
        String userId = userDto.getUserId();
        Date activateDate = userDto.getActivateDate();
        this.userRegist.delete(userDto);
        this.extraRoleRegist.delete(userId, activateDate);
        if (this.userRefer.getUserHistory(userId).isEmpty()) {
            this.passwordRegist.delete(userId);
        }
    }

    protected Date getChangeDate(Date activateDate) {
        Date changeDate = this.getSystemDate();
        if (activateDate.after(changeDate)) {
            changeDate = activateDate;
        }
        return changeDate;
    }

    protected Set<UserExtraRoleDtoInterface> getDefaultExtraRoleDtos(String userId, Date activateDate) throws MospException {
        LinkedHashSet<UserExtraRoleDtoInterface> dtos = new LinkedHashSet<UserExtraRoleDtoInterface>();
        List roleTypes = this.roleRefer.getAvailableRoleTypes(activateDate);
        for (String roleType : roleTypes) {
            String roleCode = RoleUtility.getDefaultRole((MospParams)this.mospParams, (String)roleType);
            if (MospUtility.isEmpty((String[])new String[]{roleCode})) continue;
            UserExtraRoleDtoInterface dto = this.getInitExtraRoleDto();
            dto.setUserId(userId);
            dto.setActivateDate(activateDate);
            dto.setRoleType(roleType);
            dto.setRoleCode(roleCode);
            dtos.add(dto);
        }
        return dtos;
    }

    protected Set<UserMasterDtoInterface> getUserDtos(long[] recordIdArray) throws MospException {
        LinkedHashSet<UserMasterDtoInterface> set = new LinkedHashSet<UserMasterDtoInterface>();
        for (long recordId : recordIdArray) {
            set.add(this.userRefer.findForkey(recordId));
        }
        set.remove(null);
        return set;
    }

    protected Set<String> getUserIds(long[] recordIdArray) throws MospException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Set dtos = this.getUserDtos(recordIdArray);
        for (UserMasterDtoInterface dto : dtos) {
            set.add(dto.getUserId());
        }
        return set;
    }
}

