/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionRegistBeanInterface;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmPositionDto;

public class PositionRegistBean
extends PlatformFileBean
implements PositionRegistBeanInterface {
    protected static final int LEN_POSITION_CODE = 10;
    protected static final int LEN_POSITION_NAME = 30;
    protected static final int LEN_POSITION_ABBR = 6;
    protected static final int LEN_POSITION_GRADE = 2;
    protected PositionDaoInterface dao;

    public PositionRegistBean() {
    }

    public PositionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (PositionDaoInterface)this.createDao(PositionDaoInterface.class);
    }

    public PositionDtoInterface getInitDto() {
        return new PfmPositionDto();
    }

    public void insert(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            PositionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmPositionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmPositionId());
            dto.setPfmPositionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((PositionDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(PositionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPositionCode()));
    }

    protected void checkAdd(PositionDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPositionCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected void checkUpdate(PositionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmPositionId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected void checkDelete(PositionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            PositionDtoInterface dto = (PositionDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getPositionCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(PositionDtoInterface positionDto, List<HumanDtoInterface> list) throws MospException {
        RetirementReferenceBeanInterface refer = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        for (HumanDtoInterface humanDto : list) {
            if (!humanDto.getPositionCode().equals(positionDto.getPositionCode()) || refer.isRetired(humanDto.getPersonalId(), positionDto.getActivateDate())) continue;
            this.addCodeIsUsedMessage(positionDto.getPositionCode(), humanDto);
        }
    }

    protected void checkConcurrentCodeIsUsed(String code, List<ConcurrentDtoInterface> list) throws MospException {
        for (ConcurrentDtoInterface concurrentDto : list) {
            if (!code.equals(concurrentDto.getPositionCode())) continue;
            HumanDtoInterface humanDto = this.getHumanInfo(concurrentDto.getPersonalId(), concurrentDto.getStartDate());
            this.addCodeIsUsedMessage(code, humanDto);
        }
    }

    protected void validate(PositionDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getPositionCode(), this.getNamePositionCode(), row);
        this.checkRequired((Object)dto.getActivateDate(), this.getNameActivateDate(), row);
        this.checkRequired((Object)dto.getPositionName(), this.getNamePositionName(), row);
        this.checkRequired((Object)dto.getPositionGrade(), this.getNamePositionGrade(), row);
        this.checkRequired((Object)dto.getPositionAbbr(), this.getNamePositionAbbr(), row);
        this.checkLength(dto.getPositionCode(), 10, this.getNamePositionCode(), row);
        this.checkLength(dto.getPositionName(), 30, this.getNamePositionName(), row);
        this.checkLength(String.valueOf(dto.getPositionGrade()), 2, this.getNamePositionGrade(), row);
        this.checkByteLength(dto.getPositionAbbr(), 6, this.getNamePositionAbbr(), row);
        this.checkTypeCode(dto.getPositionCode(), this.getNamePositionCode(), row);
        this.checkTypeNumber(String.valueOf(dto.getPositionGrade()), this.getNamePositionGrade(), row);
        this.checkInactivateFlag(dto.getInactivateFlag(), row);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected String getNamePositionCode() {
        return this.mospParams.getName("Position", new String[]{"Code"});
    }

    protected String getNamePositionName() {
        return this.mospParams.getName("Position", new String[]{"Name"});
    }

    protected String getNamePositionAbbr() {
        return this.mospParams.getName("Position", new String[]{"Abbreviation"});
    }

    protected String getNamePositionGrade() {
        return this.mospParams.getName("Position", new String[]{"Grade"});
    }
}

