/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.IcCardRegistBeanInterface;
import jp.mosp.platform.dao.system.IcCardDaoInterface;
import jp.mosp.platform.dto.system.IcCardDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmIcCardDto;

public class IcCardRegistBean
extends PlatformBean
implements IcCardRegistBeanInterface {
    protected IcCardDaoInterface dao;
    UserCheckBeanInterface userCheck;

    public IcCardRegistBean() {
    }

    public IcCardRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (IcCardDaoInterface)this.createDao(IcCardDaoInterface.class);
        this.userCheck = (UserCheckBeanInterface)this.createBean(UserCheckBeanInterface.class);
    }

    public IcCardDtoInterface getInitDto() {
        return new PfmIcCardDto();
    }

    public void insert(IcCardDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmIcCardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    private void checkInsert(IcCardDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getIcCardId()));
    }

    public void add(IcCardDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmIcCardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    private void checkAdd(IcCardDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getIcCardId(), dto.getActivateDate()));
    }

    public void update(IcCardDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmIcCardId());
        dto.setPfmIcCardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    private void checkUpdate(IcCardDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmIcCardId());
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((IcCardDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    private void checkDelete(IcCardDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmIcCardId());
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            IcCardDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForCardIdInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmIcCardId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmIcCardId());
            dto.setPfmIcCardId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            IcCardDtoInterface dto = (IcCardDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getIcCardId());
        }
        return list;
    }

    public void validate(IcCardDtoInterface dto, Integer row) throws MospException {
        this.userCheck.checkUserEmployee(dto.getPersonalId(), dto.getActivateDate());
    }
}

