/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.CheckAfterRegistUserBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserCountDaoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;

public abstract class CheckActiveUsersBean
extends PlatformBean
implements CheckAfterRegistUserBeanInterface {
    protected UserCountDaoInterface userCountDao;
    protected RoleReferenceBeanInterface roleRefer;

    public CheckActiveUsersBean() {
    }

    public CheckActiveUsersBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userCountDao = (UserCountDaoInterface)this.createDao(UserCountDaoInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
    }

    public void check() throws MospException {
        for (Date targetDate : this.userCountDao.getActivateDates()) {
            this.check(targetDate);
        }
    }

    protected void check(Date targetDate) throws MospException {
        for (Map.Entry entry : this.getLimits().entrySet()) {
            String roleType = (String)entry.getKey();
            Map limits = (Map)entry.getValue();
            this.check(roleType, limits, targetDate);
        }
    }

    protected void check(String roleType, Map<String, Integer> limits, Date targetDate) throws MospException {
        for (Map.Entry<String, Integer> entry : limits.entrySet()) {
            String roleCode = entry.getKey();
            int limit = entry.getValue();
            this.check(roleType, roleCode, limit, targetDate);
        }
    }

    protected void check(String roleType, String roleCode, int limit, Date targetDate) throws MospException {
        int count = this.userCountDao.count(roleType, roleCode, targetDate);
        if (limit < count) {
            this.addErrorMessage(this.mospParams, roleType, roleCode, limit, targetDate);
        }
    }

    protected void addErrorMessage(MospParams mospParams, String roleType, String roleCode, int limit, Date targetDate) throws MospException {
        String[][] roleTypes = this.roleRefer.getRoleTypeSelectArray(targetDate);
        String roleName = MospUtility.getCodeName((String)roleType, (String[][])roleTypes);
        PlatformMessageUtility.addErrorExceedUsers((MospParams)mospParams, (String)roleName, (int)limit);
    }

    protected Map<String, Map<String, Integer>> getLimits() {
        return Collections.emptyMap();
    }
}

