/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.AppPropertyRegistBeanInterface;
import jp.mosp.platform.dao.system.AppPropertyDaoInterface;
import jp.mosp.platform.dto.system.AppPropertyDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmAppPropertyDto;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class AppPropertyRegistBean
extends PlatformBean
implements AppPropertyRegistBeanInterface {
    protected AppPropertyDaoInterface dao;

    public AppPropertyRegistBean() {
    }

    public AppPropertyRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (AppPropertyDaoInterface)this.createDao(AppPropertyDaoInterface.class);
    }

    public void regist(String appKey, String appValue) throws MospException {
        PfmAppPropertyDto dto = new PfmAppPropertyDto();
        dto.setAppKey(appKey);
        dto.setAppValue(appValue);
        this.validate((AppPropertyDtoInterface)dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AppPropertyDtoInterface current = this.dao.findForKey(appKey);
        if (current != null) {
            if (MospUtility.isEqual((Object)appValue, (Object)current.getAppValue())) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, current.getRecordId());
        }
        dto.setPfmAppPropertyId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(String appKey) throws MospException {
        AppPropertyDtoInterface current = this.dao.findForKey(appKey);
        if (current != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, current.getRecordId());
        }
    }

    protected void validate(AppPropertyDtoInterface dto, Integer row) {
        String appKey = dto.getAppKey();
        int deleteFlag = dto.getDeleteFlag();
        String nameAppKey = PlatformNamingUtility.appKey((MospParams)this.mospParams);
        this.checkRequired((Object)appKey, nameAppKey, row);
        this.checkDeleteFlag(deleteFlag, row);
    }
}

