/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;

public class UserCheckBean
extends PlatformBean
implements UserCheckBeanInterface {
    protected static final String APP_CHECK_USER = "CheckUser";
    protected static final String USER_CHECK_ENTRANCE = "Entrance";
    protected static final String USER_CHECK_RETIREMENT = "Retirement";
    protected static final String USER_CHECK_SUSPENSION = "Suspension";
    private UserMasterDaoInterface userMasterDao;
    protected RoleReferenceBeanInterface roleRefer;

    public UserCheckBean() {
    }

    protected UserCheckBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userMasterDao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
    }

    public void checkUserExist(String userId, Integer row) throws MospException {
        if (this.userMasterDao.findForHistory(userId).isEmpty()) {
            PlatformMessageUtility.addErrorSelectedUserIdNotExist((MospParams)this.mospParams, (String)userId, (Integer)row);
        }
    }

    public void checkUserExist(String userId, Date activateDate, Integer row) throws MospException {
        if (this.userMasterDao.findForKey(userId, activateDate) == null) {
            PlatformMessageUtility.addErrorUserHistoryNotExist((MospParams)this.mospParams, (Date)activateDate, (Integer)row);
        }
    }

    public UserMasterDtoInterface checkUserExist(String userId, Date targetDate) throws MospException {
        UserMasterDtoInterface dto = this.userMasterDao.findForInfo(userId, targetDate);
        if (dto == null || dto.getInactivateFlag() == 1) {
            PlatformMessageUtility.addErrorNoUser((MospParams)this.mospParams);
        }
        return dto;
    }

    public void checkUserEmployeeForUserId(String userId, Date targetDate) throws MospException {
        UserMasterDtoInterface dto = this.checkUserExist(userId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUserEmployee(dto.getPersonalId(), targetDate);
    }

    public void checkUserEmployee(String personalId, Date targetDate) throws MospException {
        for (String userCheck : this.mospParams.getApplicationProperties(APP_CHECK_USER)) {
            if (userCheck.equals(USER_CHECK_ENTRANCE)) {
                this.checkEntrance(personalId, targetDate);
                continue;
            }
            if (userCheck.equals(USER_CHECK_RETIREMENT)) {
                this.checkRetire(personalId, targetDate);
                continue;
            }
            if (!userCheck.equals(USER_CHECK_SUSPENSION)) continue;
            this.checkSuspension(personalId, targetDate);
        }
    }

    public void checkUserRole(String userId, Date targetDate) throws MospException {
        UserMasterDtoInterface dto = this.checkUserExist(userId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRoleExist(dto.getRoleCode(), targetDate);
    }

    public void checkRoleExist(String roleCode, Date targetDate, Integer row) throws MospException {
        Set availableRoleCodes = this.roleRefer.getAvailabeRoleCodes(targetDate);
        if (!availableRoleCodes.contains(roleCode)) {
            PlatformMessageUtility.addErrorNoRole((MospParams)this.mospParams, (Integer)row);
        }
    }

    public void checkRoleExist(String roleCode, Date targetDate) throws MospException {
        this.checkRoleExist(roleCode, targetDate, null);
    }

    public void checkRoleExist(String roleType, String roleCode, Date targetDate, Integer row) throws MospException {
        Set availableRoleCodes = this.roleRefer.getAvailabeRoleCodes(targetDate, roleType);
        if (!availableRoleCodes.contains(roleCode)) {
            PlatformMessageUtility.addErrorNoRole((MospParams)this.mospParams, (Integer)row);
        }
    }

    public void checkRoleTypeExist(String roleType, Date targetDate, Integer row) throws MospException {
        List list = this.roleRefer.getAvailableRoleTypes(targetDate);
        if (!list.contains(roleType)) {
            PlatformMessageUtility.addErrorNoRoleType((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkEntrance(String personalId, Date targetDate) throws MospException {
        if (!this.isEntered(personalId, targetDate)) {
            HumanReferenceBeanInterface humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
            String employeeCode = humanRefer.getEmployeeCode(personalId, targetDate);
            PlatformMessageUtility.addErrorEmployeeNotJoinForAccount((MospParams)this.mospParams, (String)employeeCode);
        }
    }

    protected void checkRetire(String personalId, Date targetDate) throws MospException {
        RetirementReferenceBeanInterface reference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        if (reference.isRetired(personalId, targetDate)) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspension(String personalId, Date targetDate) throws MospException {
        SuspensionReferenceBeanInterface reference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        if (reference.isSuspended(personalId, targetDate)) {
            this.addEmployeeSuspendedMessage();
        }
    }
}

