/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospUser;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.portal.MospUserBeanInterface;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class MospUserBean
extends PlatformBean
implements MospUserBeanInterface {
    protected UserCheckBeanInterface userCheck;
    protected UserMasterReferenceBeanInterface userRefer;
    protected HumanReferenceBeanInterface humanRefer;
    protected RoleReferenceBeanInterface roleRefer;
    protected UserExtraRoleReferenceBeanInterface userExtraRoleRefer;

    public MospUserBean() {
    }

    public MospUserBean(MospParams actionInfo, Connection connection) {
        super(actionInfo, connection);
    }

    public void initBean() throws MospException {
        this.userCheck = (UserCheckBeanInterface)this.createBean(UserCheckBeanInterface.class);
        this.userRefer = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
        this.userExtraRoleRefer = (UserExtraRoleReferenceBeanInterface)this.createBean(UserExtraRoleReferenceBeanInterface.class);
    }

    public void setMospUser(String userId) throws MospException {
        Date systemDate = DateUtility.getSystemDate();
        this.userCheck.checkUserEmployeeForUserId(userId, systemDate);
        this.userCheck.checkUserRole(userId, systemDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        UserMasterDtoInterface userDto = this.userRefer.getUserInfo(userId, systemDate);
        String personalId = userDto.getPersonalId();
        HumanDtoInterface humanDto = this.humanRefer.getHumanInfo(personalId, systemDate);
        MospUser user = this.mospParams.getUser();
        if (user == null) {
            user = new MospUser();
        }
        user.setUserId(userId);
        user.setPersonalId(personalId);
        user.setRole(userDto.getRoleCode());
        user.setUserName(MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName()));
        if (this.roleRefer.isExtraRolesAvailable(systemDate)) {
            user.setExtraRoles(this.userExtraRoleRefer.getUserExtraRoles(userId, userDto.getActivateDate()));
        }
        this.mospParams.setUser(user);
    }
}

