/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.mail.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.mail.MailStartTlsBeanInterface;
import jp.mosp.platform.dto.mail.impl.MailTemplateDto;
import jp.mosp.platform.utils.MailTemplateUtility;

public class MailStartTlsBean
extends PlatformBean
implements MailStartTlsBeanInterface {
    protected static final String SMTP_AUTH = "true";
    protected static final String SMTP_PORT = "587";
    protected static final String SMTP_ATT_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    protected static final String SMTP_STARTTLS_ENABLE = "true";
    protected static final String SMTP_ATT_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    protected static final String SMTP_STARTTLS_REQUIRED = "true";
    protected static final String APP_LOG_LEVEL_MAIL = "LogLevelMail";
    protected static final String SEPARATOR_ADDRESS = "@";

    public MailStartTlsBean() {
    }

    public MailStartTlsBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() {
    }

    public void send(String recipient, String subject, String appTemplate, MailTemplateDto dto) {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        this.send(recipients, subject, appTemplate, dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(List<String> recipients, String subject, String appTemplate, MailTemplateDto dto) {
        Properties props = this.makeProperties();
        Session session = Session.getInstance((Properties)props);
        MimeMessage mimeMessage = new MimeMessage(session);
        Transport transport = null;
        try {
            mimeMessage.setFrom(this.makeAddress(this.getTransmitter(), this.getTransmitterName()));
            mimeMessage.setRecipients(Message.RecipientType.TO, this.makeAddresses(recipients));
            mimeMessage.setSubject(subject, "UTF-8");
            mimeMessage.setText(this.makeText(appTemplate, dto), "UTF-8");
            mimeMessage.setSentDate(this.getSystemTime());
            transport = session.getTransport("smtp");
            transport.connect(this.getSmtpHost(), this.getSmtpUser(), this.getSmtpPass());
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            this.outputSendLog(recipients);
        }
        catch (Throwable t) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            this.addErrorSendMail(recipients);
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (Throwable t) {
                LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            }
        }
    }

    protected Properties makeProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.port", SMTP_PORT);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.connectiontimeout", "60000");
        props.put("mail.smtp.timeout", "60000");
        props.put(SMTP_ATT_STARTTLS_ENABLE, "true");
        props.put(SMTP_ATT_STARTTLS_REQUIRED, "true");
        String[] address = MospUtility.split((String)this.getTransmitter(), (String)SEPARATOR_ADDRESS);
        if (address.length > 1) {
            props.put("mail.user", address[0]);
            props.put("mail.host", address[1]);
        }
        return props;
    }

    protected Address[] makeAddresses(List<String> recipients) throws MospException {
        ArrayList<Address> list = new ArrayList<Address>();
        for (String recipient : recipients) {
            list.add(this.makeAddress(recipient));
        }
        return list.toArray(new Address[list.size()]);
    }

    protected Address makeAddress(String address) throws MospException {
        try {
            return new InternetAddress(address);
        }
        catch (AddressException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected Address makeAddress(String address, String personal) throws MospException {
        try {
            return new InternetAddress(address, personal);
        }
        catch (Exception e) {
            throw new MospException((Throwable)e);
        }
    }

    protected String makeText(String appTemplate, MailTemplateDto dto) throws MospException {
        MailTemplateUtility mailTemplate = new MailTemplateUtility();
        mailTemplate.init(this.mospParams, "", this.mospParams.getApplicationProperty(appTemplate));
        mailTemplate.setMailItem(dto);
        return mailTemplate.getText();
    }

    protected String getSmtpHost() {
        return this.mospParams.getApplicationProperty("MailHost");
    }

    protected String getSmtpUser() {
        return this.mospParams.getApplicationProperty("MailUserName");
    }

    protected String getSmtpPass() {
        return this.mospParams.getApplicationProperty("MailPassword");
    }

    protected String getTransmitter() {
        return this.mospParams.getApplicationProperty("MailAddress");
    }

    protected String getTransmitterName() {
        return this.mospParams.getApplicationProperty("MailPersonal");
    }

    protected void outputSendLog(List<String> recipients) {
        int level = this.mospParams.getApplicationProperty(APP_LOG_LEVEL_MAIL, 0);
        if (level == 0) {
            return;
        }
        LogUtility.log((MospParams)this.mospParams, (int)level, (String)this.makeMessage(recipients, "\u3078\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002"));
    }

    protected void addErrorSendMail(List<String> recipients) {
        this.mospParams.getErrorMessageList().add(this.makeMessage(recipients, "\u3078\u306e\u9001\u4fe1\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
    }

    protected String makeMessage(List<String> recipients, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(MospUtility.toSeparatedString(recipients, (String)","));
        sb.append(message);
        return sb.toString();
    }
}

