/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.mail.impl;

import java.io.File;
import java.sql.Connection;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocketFactory;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.mail.MailSenderBeanInterface;
import jp.mosp.platform.bean.mail.impl.MailSenderBean;

public class MailSenderBean
extends PlatformBean
implements MailSenderBeanInterface {
    private String mailServer = "";
    private String transmitter = "";
    private String userName = "";
    private String[][] receiver = new String[0][0];
    private Address[] addresses = new Address[0];
    private String title = "";
    private String text = "";
    private String userid = "";
    private String password = "";
    private boolean useMailAuth = false;
    private boolean useSSL = false;
    private boolean useDebug = false;
    private Session session;
    private MimeMessage mimeMessage;
    private Transport transport;

    public MailSenderBean() {
    }

    public MailSenderBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() {
    }

    public void init() {
        this.setMailServer(this.mospParams.getApplicationProperty("MailHost"));
        this.setUserid(this.mospParams.getApplicationProperty("MailUserName"));
        this.setPassword(this.mospParams.getApplicationProperty("MailPassword"));
        this.setUseMailAuth(this.mospParams.getApplicationPropertyBool("MailSmtpAuth"));
        this.setUseSSL(this.mospParams.getApplicationPropertyBool("MailSsl"));
        this.setTransmitter(this.mospParams.getApplicationProperty("MailAddress"));
        this.setUserName(this.mospParams.getApplicationProperty("MailPersonal"));
        this.setSession();
        this.setMimeMessage();
    }

    public void setMessage(String[][] receiver, String title, String text, File file) throws MospException {
        this.setReceiver(receiver);
        this.setAddresses();
        this.setTitle(title);
        StringBuffer sb = new StringBuffer();
        sb.append(text);
        sb.append("\n");
        this.setText(sb.toString());
        this.setMessageSetting();
    }

    protected void send() throws MospException {
        this.createConnection();
        try {
            this.transport.sendMessage((Message)this.mimeMessage, this.addresses);
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        this.closeConnection();
    }

    public boolean isSend() {
        boolean isSend = true;
        try {
            this.send();
        }
        catch (Throwable e) {
            isSend = false;
            e.printStackTrace();
        }
        return isSend;
    }

    protected void setSession() {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.mailServer);
        props.put("mail.host", this.mailServer);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", String.valueOf(this.useMailAuth));
        props.put("mail.smtp.port", this.changeSMTPPort());
        props.put("mail.smtp.connectiontimeout", "60000");
        props.put("mail.smtp.timeout", "60000");
        if (this.useSSL) {
            props.setProperty("mail.smtp.socketFactory.class", SSLSocketFactory.class.getCanonicalName());
            props.setProperty("mail.smtp.socketFactory.fallback", String.valueOf(false));
            props.setProperty("mail.smtp.socketFactory.port", "465");
        }
        this.session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuth(this, null));
    }

    protected void setMimeMessage() {
        if (this.checkSession()) {
            this.session.setDebug(this.useDebug);
            this.mimeMessage = new MimeMessage(this.session);
        }
    }

    protected void setMessageSetting() throws MospException {
        if (this.mimeMessage == null) {
            return;
        }
        try {
            this.mimeMessage.setFrom((Address)new InternetAddress(this.transmitter, this.userName, "iso-2022-jp"));
            this.mimeMessage.setRecipients(Message.RecipientType.TO, this.addresses);
            this.mimeMessage.setSubject(this.title, "UTF-8");
            this.mimeMessage.setText(this.text, "UTF-8");
            this.mimeMessage.setSentDate(this.getSystemTime());
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
    }

    protected String changeSMTPPort() {
        String port = "25";
        if (this.useSSL) {
            port = "465";
        }
        return port;
    }

    public boolean checkConnection() {
        boolean canUseServrer = false;
        if (this.checkSession()) {
            canUseServrer = this.createConnection();
            this.closeConnection();
        }
        return canUseServrer;
    }

    protected void setTransport() {
        if (this.checkSession()) {
            try {
                this.transport = this.session.getTransport("smtp");
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean createConnection() {
        this.setTransport();
        try {
            if (this.checkTransport()) {
                if (this.useMailAuth) {
                    this.transport.connect(this.mailServer, this.userid, this.password);
                    return true;
                }
                this.transport.connect();
                return true;
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void closeConnection() {
        try {
            if (this.checkTransport()) {
                this.transport.close();
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    protected boolean checkSession() {
        return this.session != null;
    }

    private boolean checkTransport() {
        return this.transport != null;
    }

    protected void setAddresses() throws MospException {
        Address[] addresses = new Address[this.receiver.length];
        for (int i = 0; i < addresses.length; ++i) {
            try {
                addresses[i] = new InternetAddress(this.receiver[i][1], this.receiver[i][0], "iso-2022-jp");
                continue;
            }
            catch (Throwable e) {
                throw new MospException(e);
            }
        }
        this.setAddresses(addresses);
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    public void setTransmitter(String transmitter) {
        this.transmitter = transmitter;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setReceiver(String[][] receiver) {
        this.receiver = this.getStringArrayClone(receiver);
    }

    public void setAddresses(Address[] addresses) {
        this.addresses = this.getAddressArrayClone(addresses);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUseMailAuth(boolean useMailAuth) {
        this.useMailAuth = useMailAuth;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setUseDebug(boolean useDebug) {
        this.useDebug = useDebug;
    }

    protected Address[] getAddressArrayClone(Address[] addresses) {
        if (addresses == null) {
            return new Address[0];
        }
        return (Address[])addresses.clone();
    }

    static /* synthetic */ String access$100(MailSenderBean x0) {
        return x0.userid;
    }

    static /* synthetic */ String access$200(MailSenderBean x0) {
        return x0.password;
    }
}

