/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.mail.impl;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.mail.MailBeanInterface;
import jp.mosp.platform.bean.mail.MailSenderBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.mail.impl.MailTemplateDto;
import jp.mosp.platform.utils.MailTemplateUtility;

public class MailBean
extends PlatformBean
implements MailBeanInterface {
    protected MailSenderBeanInterface mailSender;
    protected HumanReferenceBeanInterface humanReference;
    protected HumanNormalReferenceBeanInterface humanNormalReference;
    public static final String PATH_TEMPLATE = "/template/";
    protected String itemName = "mailAddress";

    public MailBean() {
    }

    public MailBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.mailSender = (MailSenderBeanInterface)this.createBean(MailSenderBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.humanNormalReference = (HumanNormalReferenceBeanInterface)this.createBean(HumanNormalReferenceBeanInterface.class);
    }

    public boolean canUseMailServer() {
        boolean useMail = false;
        if (this.mospParams.getApplicationProperty("UseMail") == null) {
            this.mailSender.init();
            useMail = this.mailSender.checkConnection();
        } else {
            useMail = this.mospParams.getApplicationPropertyBool("UseMail");
        }
        return useMail;
    }

    public boolean sendMail(String personalId, String subject, String templateFileName, MailTemplateDto dto, File file) throws MospException {
        String address = this.getMailAddress(personalId);
        return this.sendMail(personalId, address, this.getPersonal(personalId, address), subject, this.getText(PATH_TEMPLATE, templateFileName, dto), file);
    }

    protected boolean sendMail(String personalId, String personal, String subject, String path, String fileName, MailTemplateDto dto, File file) throws MospException {
        return this.sendMail(personalId, this.getMailAddress(personalId), personal, subject, this.getText(path, fileName, dto), file);
    }

    public boolean sendMail(String[][] aryPersonalId, String title, String text, File file) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aryPersonalId.length; ++i) {
            if (!this.checkMailAddress(aryPersonalId[i][1])) continue;
            sb.append(aryPersonalId[i][0]);
            if (i != aryPersonalId.length - 1) {
                sb.append(",");
            }
            String[] receiver = new String[2];
            receiver[0] = aryPersonalId[i][0];
            HumanDtoInterface dto = this.humanReference.getHumanInfo(aryPersonalId[i][0], this.getSystemDate());
            if (dto != null) {
                receiver[0] = MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
            }
            receiver[1] = aryPersonalId[i][1];
            list.add(receiver);
        }
        this.mailSender.init();
        this.mailSender.setMessage((String[][])this.toArray(list, (Object[])new String[0][]), title, text, file);
        boolean isSend = this.mailSender.isSend();
        if (isSend) {
            sb.append("\u3078\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
        } else {
            sb.append("\u3078\u306e\u9001\u4fe1\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        LogUtility.log((MospParams)this.mospParams, (int)800, (String)sb.toString());
        return isSend;
    }

    protected boolean sendMail(String personalId, String subject, String text, File file) throws MospException {
        String address = this.getMailAddress(personalId);
        return this.sendMail(personalId, address, this.getPersonal(personalId, address), subject, text, file);
    }

    protected boolean sendMail(String personalId, String address, String personal, String subject, String text, File file) throws MospException {
        if (!this.checkMailAddress(address)) {
            return false;
        }
        this.mailSender.init();
        this.mailSender.setMessage((String[][])new String[][]{{personal == null || personal.isEmpty() ? address : personal, address}}, subject, text, file);
        boolean isSend = this.mailSender.isSend();
        StringBuffer sb = new StringBuffer();
        sb.append(personalId);
        if (isSend) {
            sb.append("\u3078\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
        } else {
            sb.append("\u3078\u306e\u9001\u4fe1\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        LogUtility.log((MospParams)this.mospParams, (int)800, (String)sb.toString());
        return isSend;
    }

    protected String getMailAddress(String personalId) throws MospException {
        HumanNormalDtoInterface dto = this.humanNormalReference.getHumanNormalInfo(this.itemName, personalId);
        if (dto == null) {
            return "";
        }
        return dto.getHumanItemValue();
    }

    protected String getPersonal(String personalId, String address) throws MospException {
        String humansName = this.getHumansName(personalId);
        if (humansName == null || humansName.isEmpty()) {
            return address;
        }
        return humansName;
    }

    protected String getHumansName(String personalId) throws MospException {
        HumanDtoInterface dto = this.humanReference.getHumanInfo(personalId, this.getSystemDate());
        if (dto == null) {
            return "";
        }
        return MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
    }

    protected String getText(String path, String fileName, MailTemplateDto dto) throws MospException {
        MailTemplateUtility mailTemplate = new MailTemplateUtility();
        mailTemplate.init(this.mospParams, path, fileName);
        mailTemplate.setMailItem(dto);
        return mailTemplate.getText();
    }

    protected boolean checkMailAddress(String mailAddress) {
        return mailAddress != null && !mailAddress.isEmpty();
    }

    protected <T> T[] toArray(List<T> list, T ... a) {
        return list.toArray(a);
    }
}

