/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.EmployeeNumberingBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.utils.PlatformUtility;

public class EmployeeNumberingBean
extends PlatformBean
implements EmployeeNumberingBeanInterface {
    private HumanDaoInterface dao;

    public EmployeeNumberingBean() {
    }

    public EmployeeNumberingBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
    }

    public boolean isEmployeeNumberingAvailable() {
        String[] format = this.getEmployeeNumberingFormat();
        return format.length != 0;
    }

    public String getNewEmployeeCode() throws MospException {
        if (!this.isEmployeeNumberingAvailable()) {
            return "";
        }
        Set set = this.dao.findForEmployeeNumbering();
        long seq = PlatformUtility.next((String)this.getFormat(), (long)this.getMin(), (long)this.getMax(), (Set)set);
        return this.issueSequenceNo(seq, this.getFormat());
    }

    protected String[] getEmployeeNumberingFormat() {
        return this.mospParams.getApplicationProperties("EmployeeNumeringFormat");
    }

    protected String getFormat() {
        return this.getEmployeeNumberingFormat()[0];
    }

    protected long getMin() {
        return Long.parseLong(this.getEmployeeNumberingFormat()[1]);
    }

    protected long getMax() {
        return Long.parseLong(this.getEmployeeNumberingFormat()[2]);
    }
}

