/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.AddressRegistBeanInterface;
import jp.mosp.platform.dao.human.AddressDaoInterface;
import jp.mosp.platform.dto.human.AddressDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaAddressDto;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class AddressRegistBean
extends PlatformBean
implements AddressRegistBeanInterface {
    protected static final int LEN_HOLDER_ID = 20;
    protected static final int LEN_ADDRESS_TYPE = 10;
    protected AddressDaoInterface dao;

    public AddressRegistBean() {
    }

    public AddressRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (AddressDaoInterface)this.createDao(AddressDaoInterface.class);
    }

    public AddressDtoInterface getInitDto() {
        return new PfaAddressDto();
    }

    public void registPersonalAddress(AddressDtoInterface dto) throws MospException {
        dto.setAddressType("1");
        this.regist(dto);
    }

    public void registLegalAddress(AddressDtoInterface dto) throws MospException {
        dto.setAddressType("2");
        this.regist(dto);
    }

    protected void regist(AddressDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AddressDtoInterface duplicateDto = this.dao.findForKey(dto.getHolderId(), dto.getAddressType(), dto.getActivateDate());
        if (duplicateDto != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, duplicateDto.getPfaAddressId());
        }
        dto.setPfaAddressId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void deleteAddress(String holderId, Date activateDate, String requestType) throws MospException {
        Set set = this.dao.findForRequestType(holderId, activateDate, requestType);
        for (AddressDtoInterface dto : set) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaAddressId());
        }
    }

    public void validate(AddressDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getHolderId(), this.mospParams.getName("Id"), row);
        this.checkRequired((Object)dto.getAddressType(), this.mospParams.getName("Address", new String[]{"Type"}), row);
        this.checkRequired((Object)dto.getActivateDate(), PlatformNamingUtility.activateDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getHolderId(), 20, this.mospParams.getName("Id"), row);
        this.checkLength(dto.getAddressType(), 10, this.mospParams.getName("Address", new String[]{"Type"}), row);
        this.checkDeleteFlag(dto.getDeleteFlag(), row);
        this.checkOtherAddressExist(dto, row);
    }

    protected void checkOtherAddressExist(AddressDtoInterface dto, Integer row) throws MospException {
        Date activateDate = dto.getActivateDate();
        AddressDtoInterface duplicateDto = this.dao.findForKey(dto.getHolderId(), dto.getAddressType(), activateDate);
        if (duplicateDto == null) {
            return;
        }
        if (duplicateDto.getRequestType().equals(dto.getRequestType())) {
            return;
        }
        PlatformMessageUtility.addErrorOtherAddressExist((MospParams)this.mospParams, (Date)activateDate, (Integer)row);
    }
}

