/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.AccountRegistBeanInterface;
import jp.mosp.platform.dao.human.AccountDaoInterface;
import jp.mosp.platform.dto.human.AccountDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaAccountDto;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class AccountRegistBean
extends PlatformBean
implements AccountRegistBeanInterface {
    protected static final int LEN_HOLDER_ID = 20;
    protected static final int LEN_ACCOUNT_TYPE = 10;
    protected static final int LEN_BANK_CODE = 4;
    protected static final int LEN_BRANCH_CODE = 3;
    protected static final int LEN_ACCOUNT_CLASS = 1;
    protected static final int LEN_ACCOUNT_NUMBER = 7;
    protected static final int LEN_ACCOUNT_HOLDER = 30;
    protected AccountDaoInterface dao;

    public AccountRegistBean() {
    }

    public AccountRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (AccountDaoInterface)this.createDao(AccountDaoInterface.class);
    }

    public AccountDtoInterface getInitDto() {
        return new PfaAccountDto();
    }

    public void regist(AccountDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AccountDtoInterface duplicateDto = this.dao.findForKey(dto.getHolderId(), dto.getAccountType(), dto.getActivateDate());
        if (duplicateDto != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, duplicateDto.getPfaAccountId());
        }
        dto.setPfaAccountId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void deletePayMainAccount(String holderId, Date activateDate) throws MospException {
        this.deleteAccount(holderId, "2", activateDate);
    }

    public void deletePaySubAccount(String holderId, Date activateDate) throws MospException {
        this.deleteAccount(holderId, "1", activateDate);
    }

    protected void deleteAccount(String holderId, String accountType, Date activateDate) throws MospException {
        AccountDtoInterface dto = this.dao.findForKey(holderId, accountType, activateDate);
        if (dto != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaAccountId());
        }
    }

    public void validate(AccountDtoInterface dto, Integer row) {
        this.checkRequired((Object)dto.getHolderId(), this.mospParams.getName("Id"), row);
        this.checkRequired((Object)dto.getAccountType(), this.mospParams.getName("Type"), row);
        this.checkRequired((Object)dto.getActivateDate(), PlatformNamingUtility.activateDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getHolderId(), 20, this.mospParams.getName("Id"), row);
        this.checkLength(dto.getBankCode(), 4, this.mospParams.getName("Code"), row);
        this.checkLength(dto.getBranchCode(), 3, this.mospParams.getName("Code"), row);
        this.checkLength(dto.getAccountClass(), 1, this.mospParams.getName("Type"), row);
        this.checkLength(dto.getAccountNumber(), 7, this.mospParams.getName("Number"), row);
        this.checkLength(dto.getAccountHolder(), 30, this.mospParams.getName("Name"), row);
        this.checkTypeKana(dto.getAccountHolder(), this.mospParams.getName("Name"), row);
        this.checkDeleteFlag(dto.getDeleteFlag(), row);
    }
}

