/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.file.UserImportBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class UserImportBean
extends PlatformFileBean
implements UserImportBeanInterface {
    protected UserMasterReferenceBeanInterface userMasterRefer;
    protected UserAccountRegistBeanInterface userAccountRegist;
    protected HumanReferenceBeanInterface humanRefer;

    public UserImportBean() {
    }

    public UserImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userMasterRefer = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.userAccountRegist = (UserAccountRegistBeanInterface)this.createBean(UserAccountRegistBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        List userDtos = this.getTargetLists(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.userAccountRegist.regist((Collection)userDtos);
        return userDtos.size();
    }

    protected List<UserMasterDtoInterface> getTargetLists(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        ArrayList<UserMasterDtoInterface> userList = new ArrayList<UserMasterDtoInterface>();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return userList;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            UserMasterDtoInterface userMasterDto = this.getUserMasterDto(fieldList, data, i);
            if (userMasterDto == null) continue;
            userList.add(userMasterDto);
        }
        return userList;
    }

    protected UserMasterDtoInterface getUserMasterDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String userId = this.getFieldValue("user_id", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String employeeCode = this.getFieldValue("employee_code", fieldList, data);
        String roleCode = this.getFieldValue("role_code", fieldList, data);
        if (userId == null || userId.isEmpty()) {
            this.addRequiredErrorMessage(PlatformNamingUtility.userId((MospParams)this.mospParams), Integer.valueOf(row));
            return null;
        }
        if (activateDate == null) {
            this.addRequiredErrorMessage(this.getNameActivateDate(), Integer.valueOf(row));
            return null;
        }
        UserMasterDtoInterface userMaster = this.userMasterRefer.getUserInfo(userId, activateDate);
        if (userMaster == null) {
            userMaster = this.userAccountRegist.getInitUserDto();
        }
        userMaster.setUserId(userId);
        userMaster.setActivateDate(activateDate);
        if (roleCode != null) {
            userMaster.setRoleCode(roleCode);
        } else if (userMaster.getRoleCode() == null) {
            userMaster.setRoleCode("");
        }
        if (employeeCode != null) {
            String personalId = this.humanRefer.getPersonalId(employeeCode, activateDate);
            if (userMaster.getPersonalId() != null && !userMaster.getPersonalId().equals(personalId)) {
                this.addUserIdDuplicateMessage(userId);
                return null;
            }
            userMaster.setPersonalId(personalId);
        }
        this.userAccountRegist.validate(userMaster, Integer.valueOf(row));
        return userMaster;
    }

    protected void addUserIdDuplicateMessage(String userId) {
        String[] rep = new String[]{PlatformNamingUtility.userId((MospParams)this.mospParams), userId};
        this.mospParams.addErrorMessage("PFW0215", rep);
    }
}

