/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PlatformExportBean;
import jp.mosp.platform.bean.file.UserExtraRoleExportBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserExtraRoleExportBean
extends PlatformExportBean
implements UserExtraRoleExportBeanInterface {
    protected UserMasterDaoInterface userMasterDao;
    protected UserExtraRoleReferenceBeanInterface userExtraRoleRefer;

    public UserExtraRoleExportBean() {
    }

    protected UserExtraRoleExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.userMasterDao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
        this.userExtraRoleRefer = (UserExtraRoleReferenceBeanInterface)this.createBean(UserExtraRoleReferenceBeanInterface.class);
    }

    protected List<String[]> getCsvDataList(Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.searchHumanData(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        for (HumanDtoInterface human : humanList) {
            List userList = this.userMasterDao.findForPersonalId(human.getPersonalId(), targetDate);
            for (UserMasterDtoInterface user : userList) {
                csvDataList.addAll(this.getCsvDataList(user));
            }
        }
        return csvDataList;
    }

    protected List<String[]> getCsvDataList(UserMasterDtoInterface user) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        String userId = user.getUserId();
        Date activateDate = user.getActivateDate();
        Map extraRoles = this.userExtraRoleRefer.getUserExtraRoleMap(userId, activateDate);
        for (Map.Entry extraRole : extraRoles.entrySet()) {
            csvDataList.add(this.getCsvData(userId, activateDate, (String)extraRole.getKey(), (String)extraRole.getValue()));
        }
        return csvDataList;
    }

    protected String[] getCsvData(String userId, Date activateDate, String roleType, String roleCode) {
        ArrayList<String> csvData = new ArrayList<String>();
        for (String fieldName : this.indexes.values()) {
            if (fieldName.equals("user_id")) {
                csvData.add(userId);
                continue;
            }
            if (fieldName.equals("activate_date")) {
                csvData.add(this.getStringDate(activateDate));
                continue;
            }
            if (fieldName.equals("role_type")) {
                csvData.add(roleType);
                continue;
            }
            if (!fieldName.equals("role_code")) continue;
            csvData.add(roleCode);
        }
        return MospUtility.toArray(csvData);
    }
}

