/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.SectionExportBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionSearchBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;

public class SectionExportBean
extends PlatformBean
implements SectionExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected SectionReferenceBeanInterface sectionReference;
    protected SectionSearchBeanInterface sectionSearch;
    protected List<SectionDtoInterface> sectionList;

    public SectionExportBean() {
    }

    public SectionExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.sectionSearch = (SectionSearchBeanInterface)this.createBean(SectionSearchBeanInterface.class);
    }

    public void export(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        List csvDataList = this.getCsvDataList(exportCode, targetDate, sectionCode);
        if (csvDataList.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName(exportCode, targetDate);
    }

    protected List<String[]> getCsvDataList(String exportCode, Date targetDate, String sectionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        ExportDtoInterface exportDto = this.exportDao.findForKey(exportCode);
        List fieldList = this.exportFieldDao.findForList(exportCode);
        this.searchSectionMasterData(csvDataList, fieldList, targetDate, sectionCode);
        this.addSectionMasterData(csvDataList, fieldList, targetDate);
        if (exportDto.getHeader() != 0) {
            this.addHeader(csvDataList, fieldList);
        }
        return csvDataList;
    }

    protected void addHeader(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList) {
        String[] header = new String[fieldList.size()];
        int i = 0;
        for (ExportFieldDtoInterface field : fieldList) {
            header[i++] = this.getCodeName(field.getFieldName(), "pfm_section");
        }
        csvDataList.add(0, header);
    }

    protected void searchSectionMasterData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate, String sectionCode) throws MospException {
        this.sectionSearch.setActivateDate(targetDate);
        this.sectionSearch.setSectionCode(sectionCode);
        this.sectionSearch.setSectionName("");
        this.sectionSearch.setSectionAbbr("");
        this.sectionSearch.setSectionType("route");
        this.sectionSearch.setCloseFlag(Integer.toString(0));
        this.sectionList = this.sectionSearch.getExportList();
    }

    protected void addSectionMasterData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate) {
        Integer sectionCodeIndex = null;
        Integer activateDateIndex = null;
        Integer sectionNameIndex = null;
        Integer sectionAbbrIndex = null;
        Integer sectionDisplayIndex = null;
        Integer upperSectionCodeIndex = null;
        Integer closeFlagIndex = null;
        for (ExportFieldDtoInterface field : fieldList) {
            Integer index = field.getFieldOrder() - 1;
            if (field.getFieldName().equals("section_code")) {
                sectionCodeIndex = index;
            }
            if (field.getFieldName().equals("activate_date")) {
                activateDateIndex = index;
            }
            if (field.getFieldName().equals("section_name")) {
                sectionNameIndex = index;
            }
            if (field.getFieldName().equals("section_abbr")) {
                sectionAbbrIndex = index;
            }
            if (field.getFieldName().equals("section_display")) {
                sectionDisplayIndex = index;
            }
            if (field.getFieldName().equals("upper_section_code")) {
                upperSectionCodeIndex = index;
            }
            if (!field.getFieldName().equals("close_flag")) continue;
            closeFlagIndex = index;
        }
        for (SectionDtoInterface dto : this.sectionList) {
            String[] csvData = new String[fieldList.size()];
            if (sectionCodeIndex != null) {
                csvData[sectionCodeIndex.intValue()] = dto.getSectionCode();
            }
            if (activateDateIndex != null) {
                csvData[activateDateIndex.intValue()] = this.getStringDate(dto.getActivateDate());
            }
            if (sectionNameIndex != null) {
                csvData[sectionNameIndex.intValue()] = dto.getSectionName();
            }
            if (sectionAbbrIndex != null) {
                csvData[sectionAbbrIndex.intValue()] = dto.getSectionAbbr();
            }
            if (sectionDisplayIndex != null) {
                csvData[sectionDisplayIndex.intValue()] = dto.getSectionDisplay();
            }
            if (upperSectionCodeIndex != null) {
                csvData[upperSectionCodeIndex.intValue()] = this.getUpperSectionCode(dto);
            }
            if (closeFlagIndex != null) {
                csvData[closeFlagIndex.intValue()] = Integer.toString(dto.getCloseFlag());
            }
            csvDataList.add(csvData);
        }
    }

    protected String getUpperSectionCode(SectionDtoInterface dto) {
        String[] sectionArray = this.sectionReference.getClassRouteArray(dto);
        int length = sectionArray.length;
        if (length == 0) {
            return "";
        }
        return sectionArray[--length];
    }

    protected void setFileName(String exportCode, Date targetDate) {
        String fileName = exportCode + this.mospParams.getName("Hyphen") + DateUtility.getStringYear((Date)targetDate) + DateUtility.getStringMonth((Date)targetDate) + DateUtility.getStringDay((Date)targetDate) + ".csv";
        this.mospParams.setFileName(fileName);
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

