/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.file.HumanImportBeanInterface;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanArrayRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralCheckBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementRegistBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanRegistBean;
import jp.mosp.platform.dao.file.ImportFieldDaoInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;

public class HumanImportBean
extends HumanRegistBean
implements HumanImportBeanInterface {
    protected HumanReferenceBeanInterface humanRefer;
    protected EntranceReferenceBeanInterface entranceRefer;
    protected RetirementReferenceBeanInterface retirementRefer;
    protected EntranceRegistBeanInterface entranceRegist;
    protected RetirementRegistBeanInterface retirementRegist;
    protected HumanNormalRegistBeanInterface humanNoraml;
    protected HumanHistoryRegistBeanInterface humanHistory;
    protected HumanArrayRegistBeanInterface humanArray;
    protected HumanGeneralBeanInterface humanGeneral;
    protected HumanGeneralCheckBeanInterface humanGeneralCheckBean;
    protected List<HumanDtoInterface> humanList;
    protected List<EntranceDtoInterface> entranceList;
    protected List<RetirementDtoInterface> retirementList;
    protected Map<String, List<HumanNormalDtoInterface>> normalMap;
    protected Map<String, List<HumanHistoryDtoInterface>> historyMap;
    protected Map<String, List<HumanArrayDtoInterface>> arrayMap;
    protected HashSet<String> divisionKeySet;
    protected HumanDtoInterface human;
    protected ImportFieldDaoInterface importFieldDao;

    public HumanImportBean() {
    }

    public HumanImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
        this.retirementRefer = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.entranceRegist = (EntranceRegistBeanInterface)this.createBean(EntranceRegistBeanInterface.class);
        this.retirementRegist = (RetirementRegistBeanInterface)this.createBean(RetirementRegistBeanInterface.class);
        this.humanNoraml = (HumanNormalRegistBeanInterface)this.createBean(HumanNormalRegistBeanInterface.class);
        this.humanHistory = (HumanHistoryRegistBeanInterface)this.createBean(HumanHistoryRegistBeanInterface.class);
        this.humanArray = (HumanArrayRegistBeanInterface)this.createBean(HumanArrayRegistBeanInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
        this.humanGeneralCheckBean = (HumanGeneralCheckBeanInterface)this.createBean(HumanGeneralCheckBeanInterface.class);
        this.importFieldDao = (ImportFieldDaoInterface)this.createDao(ImportFieldDaoInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        this.getTargetLists(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface humanDto = (HumanDtoInterface)this.humanList.get(i);
            this.registHumanDto(humanDto);
            this.registEntranceDto((EntranceDtoInterface)this.entranceList.get(i));
            this.registRetirementDto((RetirementDtoInterface)this.retirementList.get(i));
            this.registHumanNormalDto(humanDto.getEmployeeCode(), humanDto.getActivateDate());
            this.registHumanHistoryDto(humanDto.getEmployeeCode());
            this.registHumanArrayDto(humanDto.getEmployeeCode());
        }
        return this.humanList.size();
    }

    protected void getTargetLists(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        this.humanList = new ArrayList();
        this.entranceList = new ArrayList();
        this.retirementList = new ArrayList();
        this.normalMap = new HashMap();
        this.historyMap = new HashMap();
        this.arrayMap = new HashMap();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.divisionKeySet = new HashSet();
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            HumanDtoInterface humanDto = this.getHumanDto(fieldList, data, i);
            if (humanDto == null) continue;
            this.humanList.add(humanDto);
            this.entranceList.add(this.getEntranceDto(fieldList, data, i));
            this.retirementList.add(this.getRetirementDto(fieldList, data, i));
            this.getHumanGeneralList(fieldList, data, humanDto);
        }
        for (String divisionKey : this.divisionKeySet) {
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(divisionKey);
            String type = viewConfig.getType();
            if (type.equals("Normal")) {
                for (Map.Entry entry : this.normalMap.entrySet()) {
                    this.humanGeneralCheckBean.validate(divisionKey, (List)entry.getValue());
                }
            }
            if (type.equals("History")) {
                for (Map.Entry entry : this.historyMap.entrySet()) {
                    this.humanGeneralCheckBean.validate(divisionKey, (List)entry.getValue());
                }
            }
            if (!type.equals("Array")) continue;
            for (Map.Entry entry : this.arrayMap.entrySet()) {
                this.humanGeneralCheckBean.validate(divisionKey, (List)entry.getValue());
            }
        }
    }

    protected String getHumanGeneralActivateDate(List<ImportFieldDtoInterface> fieldList, String[] data, String division) throws MospException {
        for (ImportFieldDtoInterface field : fieldList) {
            String[] fieldName = MospUtility.split((String)field.getFieldName(), (String)",");
            if (fieldName.length == 1 || !fieldName[0].equals(division) || !fieldName[1].equals("ActivateDate")) continue;
            String date = data[field.getFieldOrder() - 1];
            if (date == null || date.isEmpty()) {
                this.mospParams.addErrorMessage("HG0001", new String[]{this.mospParams.getName(division)});
                return null;
            }
            if (this.getDate(date) == null) {
                String[] rep = new String[]{this.mospParams.getName(division), this.getNameActivateDate()};
                this.mospParams.addErrorMessage("HG0003", rep);
                return null;
            }
            return date;
        }
        return null;
    }

    protected HumanDtoInterface getHumanDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String employeeCode = this.getFieldValue("employee_code", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        if (employeeCode == null || employeeCode.isEmpty()) {
            this.addRequiredErrorMessage(this.getNameEmployeeCode(), Integer.valueOf(row));
            return null;
        }
        if (activateDate == null) {
            this.addRequiredErrorMessage(this.getNameActivateDate(), Integer.valueOf(row));
            return null;
        }
        this.human = this.dao.findForEmployeeCode(employeeCode, activateDate);
        if (this.human == null && this.isEmployeeCodeUsed(employeeCode)) {
            this.human = this.getInitDto();
            this.human.setPersonalId(this.getOldestHumanDto(employeeCode).getPersonalId());
        }
        if (this.human == null) {
            this.human = this.getInitDto();
        }
        this.setHumanDtoFields(fieldList, data, this.human);
        this.validate(this.human, Integer.valueOf(row));
        return this.human;
    }

    protected EntranceDtoInterface getEntranceDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        Date entranceDate = this.getDateFieldValue("entrance_date", fieldList, data);
        if (entranceDate == null) {
            return null;
        }
        EntranceDtoInterface entrance = null;
        if (this.human.getPersonalId() != null) {
            entrance = this.entranceRefer.getEntranceInfo(this.human.getPersonalId());
        }
        if (entrance == null) {
            entrance = this.entranceRegist.getInitDto();
        }
        entrance.setEntranceDate(entranceDate);
        this.entranceRegist.validate(entrance, Integer.valueOf(row));
        return entrance;
    }

    protected RetirementDtoInterface getRetirementDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        Date retirementDate = this.getDateFieldValue("retirement_date", fieldList, data);
        String retirementReason = this.getFieldValue("retirement_reason", fieldList, data);
        String retirementDetail = this.getFieldValue("retirement_detail", fieldList, data);
        if (retirementDate == null && (retirementReason == null || retirementReason.isEmpty()) && (retirementDetail == null || retirementDetail.isEmpty())) {
            return null;
        }
        RetirementDtoInterface retirement = null;
        if (this.human.getPersonalId() != null) {
            retirement = this.retirementRefer.getRetireInfo(this.human.getPersonalId());
        }
        if (retirement == null) {
            retirement = this.retirementRegist.getInitDto();
        }
        if (retirementDate != null) {
            retirement.setRetirementDate(retirementDate);
        }
        if (retirementReason != null) {
            retirement.setRetirementReason(retirementReason);
        } else if (retirement.getRetirementReason() == null) {
            retirement.setRetirementReason("");
        }
        if (retirementDetail != null) {
            retirement.setRetirementDetail(retirementDetail);
        } else if (retirement.getRetirementDetail() == null) {
            retirement.setRetirementDetail("");
        }
        this.retirementRegist.validate(retirement, Integer.valueOf(row));
        return retirement;
    }

    protected void getHumanGeneralList(List<ImportFieldDtoInterface> fieldList, String[] data, HumanDtoInterface humanDto) throws MospException {
        String employeeCode = humanDto.getEmployeeCode();
        HashMap<String, ArrayList<String>> normalRegistedMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> historyRegistedMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> arrayRegistedMap = new HashMap<String, ArrayList<String>>();
        for (ImportFieldDtoInterface field : fieldList) {
            String activeDate = "";
            String[] fieldName = MospUtility.split((String)field.getFieldName(), (String)",");
            if (fieldName.length == 1) continue;
            String division = fieldName[0];
            this.divisionKeySet.add(division);
            String itemName = fieldName[1];
            String itemValue = data[field.getFieldOrder() - 1];
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(division);
            String type = viewConfig.getType();
            if (type.equals("Normal")) {
                this.getNormalDto(itemName, itemValue, division, employeeCode);
                ArrayList<String> itemNormalList = (ArrayList<String>)normalRegistedMap.get(division);
                if (itemNormalList == null || itemNormalList.isEmpty()) {
                    itemNormalList = new ArrayList<String>();
                    itemNormalList.add(itemName);
                    normalRegistedMap.put(division, itemNormalList);
                    continue;
                }
                itemNormalList.add(itemName);
                continue;
            }
            activeDate = this.getHumanGeneralActivateDate(fieldList, data, division);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            if (itemName.equals("ActivateDate")) continue;
            if (type.equals("History")) {
                this.getHistoryDto(itemName, itemValue, division, this.getDate(activeDate), employeeCode);
                ArrayList<String> itemHistorylList = (ArrayList<String>)historyRegistedMap.get(division);
                if (itemHistorylList == null || itemHistorylList.isEmpty()) {
                    itemHistorylList = new ArrayList<String>();
                    itemHistorylList.add(itemName + "," + activeDate);
                    historyRegistedMap.put(division, itemHistorylList);
                    continue;
                }
                itemHistorylList.add(itemName + "," + activeDate);
                continue;
            }
            if (!type.equals("Array")) continue;
            this.getArrayDto(itemName, itemValue, division, this.getDate(activeDate), employeeCode);
            ArrayList<String> itemArrayList = (ArrayList<String>)arrayRegistedMap.get(division);
            if (itemArrayList == null || itemArrayList.isEmpty()) {
                itemArrayList = new ArrayList<String>();
                itemArrayList.add(itemName + "," + activeDate);
                arrayRegistedMap.put(division, itemArrayList);
                continue;
            }
            itemArrayList.add(itemName + "," + activeDate);
        }
        for (String importDivisionName : this.divisionKeySet) {
            List arrayList;
            List historyList;
            List normalList;
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(importDivisionName);
            String type = viewConfig.getType();
            if (type.equals("Normal") && (normalList = (List)normalRegistedMap.get(importDivisionName)) != null) {
                this.getNormalSpereDtoList(normalList, employeeCode, importDivisionName);
                continue;
            }
            if (type.equals("History") && (historyList = (List)historyRegistedMap.get(importDivisionName)) != null) {
                this.getHistorySpereDtoList(historyList, employeeCode, importDivisionName);
                continue;
            }
            if (!type.equals("Array") || (arrayList = (List)arrayRegistedMap.get(importDivisionName)) == null) continue;
            this.getArraySpereDtoList(arrayList, employeeCode, importDivisionName);
        }
    }

    protected boolean isMacthItemName(List<String> registeredList, String itemName) {
        if (itemName.equals("ActivateDate")) {
            return true;
        }
        for (String registeredItemName : registeredList) {
            String[] arry = MospUtility.split((String)registeredItemName, (String)",");
            if (!itemName.equals(arry[0])) continue;
            return true;
        }
        return false;
    }

    protected void getNormalSpereDtoList(List<String> registeredList, String employeeCode, String division) throws MospException {
        if (registeredList.isEmpty()) {
            return;
        }
        List tableItemList = this.humanGeneral.getTableItemList(division, "NormalCard");
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                if (itemName.isEmpty() || this.isMacthItemName(registeredList, itemName)) continue;
                this.getNormalDto(itemName, "", division, employeeCode);
            }
        }
    }

    protected void getHistorySpereDtoList(List<String> registeredList, String employeeCode, String division) throws MospException {
        if (registeredList.isEmpty()) {
            return;
        }
        String[] array = MospUtility.split((String)registeredList.get(0), (String)",");
        Date activeDate = DateUtility.getDate((String)array[1]);
        List tableItemList = this.humanGeneral.getTableItemList(division, "HistoryCard");
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                if (itemName.isEmpty() || this.isMacthItemName(registeredList, itemName)) continue;
                this.getHistoryDto(itemName, "", division, activeDate, employeeCode);
            }
        }
    }

    protected void getArraySpereDtoList(List<String> registeredList, String employeeCode, String division) throws MospException {
        if (registeredList.isEmpty()) {
            return;
        }
        String[] array = MospUtility.split((String)registeredList.get(0), (String)",");
        Date activeDate = DateUtility.getDate((String)array[1]);
        List tableItemList = this.humanGeneral.getTableItemList(division, "ArrayCard");
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                if (itemName.isEmpty() || this.isMacthItemName(registeredList, itemName)) continue;
                this.getArrayDto(itemName, "", division, activeDate, employeeCode);
            }
        }
    }

    protected void getNormalDto(String itemName, String itemValue, String division, String employeeCode) throws MospException {
        HumanNormalDtoInterface dto = this.humanNoraml.getInitDto();
        dto.setPersonalId("");
        dto.setHumanItemType(itemName);
        dto.setHumanItemValue(itemValue);
        ArrayList<HumanNormalDtoInterface> list = (ArrayList<HumanNormalDtoInterface>)this.normalMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<HumanNormalDtoInterface>();
            list.add(dto);
            this.normalMap.put(employeeCode, list);
            return;
        }
        list.add(dto);
    }

    protected void getHistoryDto(String itemName, String itemValue, String division, Date activeDate, String employeeCode) throws MospException {
        HumanHistoryDtoInterface dto = this.humanHistory.getInitDto();
        dto.setPersonalId("");
        dto.setActivateDate(activeDate);
        dto.setHumanItemType(itemName);
        dto.setHumanItemValue(itemValue);
        ArrayList<HumanHistoryDtoInterface> list = (ArrayList<HumanHistoryDtoInterface>)this.historyMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<HumanHistoryDtoInterface>();
            list.add(dto);
            this.historyMap.put(employeeCode, list);
            return;
        }
        list.add(dto);
    }

    protected void getArrayDto(String itemName, String itemValue, String division, Date activeDate, String employeeCode) throws MospException {
        HumanArrayDtoInterface dto = this.humanArray.getInitDto();
        dto.setActivateDate(activeDate);
        dto.setPersonalId("");
        dto.setHumanItemType(itemName);
        dto.setHumanItemValue(itemValue);
        ArrayList<HumanArrayDtoInterface> list = (ArrayList<HumanArrayDtoInterface>)this.arrayMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<HumanArrayDtoInterface>();
            int newRowId = this.humanArray.getRowId();
            dto.setHumanRowId(newRowId);
            list.add(dto);
            this.arrayMap.put(employeeCode, list);
            return;
        }
        dto.setHumanRowId(((HumanArrayDtoInterface)list.get(0)).getHumanRowId());
        list.add(dto);
    }

    protected boolean isEmployeeCodeUsed(String employeeCode) throws MospException {
        List list = this.dao.findForEmployeeCode(employeeCode);
        return !list.isEmpty();
    }

    protected HumanDtoInterface getOldestHumanDto(String employeeCode) throws MospException {
        HumanDtoInterface dto = null;
        List list = this.dao.findForEmployeeCode(employeeCode);
        for (HumanDtoInterface humanDto : list) {
            if (dto != null && !humanDto.getActivateDate().before(dto.getActivateDate())) continue;
            dto = humanDto;
        }
        return dto;
    }

    protected void setHumanDtoFields(List<ImportFieldDtoInterface> fieldList, String[] data, HumanDtoInterface human) throws MospException {
        String employeeCode = this.getFieldValue("employee_code", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String lastName = this.getFieldValue("last_name", fieldList, data);
        String firstName = this.getFieldValue("first_name", fieldList, data);
        String lastKana = this.getFieldValue("last_kana", fieldList, data);
        String firstKana = this.getFieldValue("first_kana", fieldList, data);
        String workPlaceCode = this.getFieldValue("work_place_code", fieldList, data);
        String employmentContractCode = this.getFieldValue("employment_contract_code", fieldList, data);
        String sectionCode = this.getFieldValue("section_code", fieldList, data);
        String positionCode = this.getFieldValue("position_code", fieldList, data);
        if (employeeCode != null) {
            human.setEmployeeCode(employeeCode);
        }
        if (activateDate != null) {
            human.setActivateDate(activateDate);
        }
        if (lastName != null) {
            human.setLastName(lastName);
        } else if (human.getLastName() == null) {
            human.setLastName("");
        }
        if (firstName != null) {
            human.setFirstName(firstName);
        } else if (human.getFirstName() == null) {
            human.setFirstName("");
        }
        if (lastKana != null) {
            human.setLastKana(lastKana);
        } else if (human.getLastKana() == null) {
            human.setLastKana("");
        }
        if (firstKana != null) {
            human.setFirstKana(firstKana);
        } else if (human.getFirstKana() == null) {
            human.setFirstKana("");
        }
        if (workPlaceCode != null) {
            human.setWorkPlaceCode(workPlaceCode);
        } else if (human.getWorkPlaceCode() == null) {
            human.setWorkPlaceCode("");
        }
        if (employmentContractCode != null) {
            human.setEmploymentContractCode(employmentContractCode);
        } else if (human.getEmploymentContractCode() == null) {
            human.setEmploymentContractCode("");
        }
        if (sectionCode != null) {
            human.setSectionCode(sectionCode);
        } else if (human.getSectionCode() == null) {
            human.setSectionCode("");
        }
        if (positionCode != null) {
            human.setPositionCode(positionCode);
        } else if (human.getPositionCode() == null) {
            human.setPositionCode("");
        }
        if (human.getMail() == null) {
            human.setMail("");
        }
    }

    protected void registHumanDto(HumanDtoInterface humanDto) throws MospException {
        this.human = humanDto;
        if (this.human.getPersonalId() == null || this.human.getPersonalId().isEmpty()) {
            this.insert(this.human);
            return;
        }
        if (this.dao.findForKey(this.human.getPersonalId(), this.human.getActivateDate()) == null) {
            this.add(this.human);
            return;
        }
        this.update(this.human);
    }

    protected void registEntranceDto(EntranceDtoInterface entrance) throws MospException {
        if (entrance == null) {
            return;
        }
        if (entrance.getPersonalId() == null || entrance.getPersonalId().isEmpty()) {
            entrance.setPersonalId(this.human.getPersonalId());
        }
        this.entranceRegist.regist(entrance);
    }

    protected void registRetirementDto(RetirementDtoInterface retirement) throws MospException {
        if (retirement == null) {
            return;
        }
        if (retirement.getPersonalId() == null || retirement.getPersonalId().isEmpty()) {
            retirement.setPersonalId(this.human.getPersonalId());
        }
        this.retirementRegist.regist(retirement);
    }

    protected void registHumanNormalDto(String employeeCode, Date humanActiveDate) throws MospException {
        List list = (List)this.normalMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (HumanNormalDtoInterface dto : list) {
            if (dto == null) continue;
            String personalId = this.humanRefer.getPersonalId(employeeCode, humanActiveDate);
            if (personalId.isEmpty()) {
                this.addEmployeeHistoryNotExistMessage(employeeCode, humanActiveDate);
                return;
            }
            dto.setPersonalId(personalId);
            this.humanNoraml.regist(dto);
        }
    }

    protected void registHumanHistoryDto(String employeeCode) throws MospException {
        List list = (List)this.historyMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (HumanHistoryDtoInterface dto : list) {
            if (dto == null) continue;
            String personalId = this.humanRefer.getPersonalId(employeeCode, dto.getActivateDate());
            if (personalId.isEmpty()) {
                this.addEmployeeHistoryNotExistMessage(employeeCode, dto.getActivateDate());
                return;
            }
            dto.setPersonalId(personalId);
            this.humanHistory.regist(dto);
        }
    }

    protected void registHumanArrayDto(String employeeCode) throws MospException {
        List list = (List)this.arrayMap.get(employeeCode);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (HumanArrayDtoInterface dto : list) {
            if (dto == null) continue;
            String personalId = this.humanRefer.getPersonalId(employeeCode, dto.getActivateDate());
            if (personalId.isEmpty()) {
                this.addEmployeeHistoryNotExistMessage(employeeCode, dto.getActivateDate());
                return;
            }
            dto.setPersonalId(this.human.getPersonalId());
            this.humanArray.insert(dto);
        }
    }

    public boolean isExistLikeFieldName(String importCode, String[] aryFieldName) throws MospException {
        List list = this.importFieldDao.findLikeStartNameList(importCode, aryFieldName);
        list = list == null ? new ArrayList() : list;
        return !list.isEmpty();
    }
}

