/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.HumanExportBeanInterface;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;

public class HumanExportBean
extends PlatformBean
implements HumanExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected EntranceDaoInterface entranceDao;
    protected RetirementDaoInterface retirementDao;
    protected HumanNormalReferenceBeanInterface humanNoraml;
    protected HumanHistoryReferenceBeanInterface humanHistory;
    protected HumanArrayReferenceBeanInterface humanArray;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface sectionReference;
    protected List<HumanDtoInterface> humanList;

    public HumanExportBean() {
    }

    protected HumanExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.entranceDao = (EntranceDaoInterface)this.createDao(EntranceDaoInterface.class);
        this.retirementDao = (RetirementDaoInterface)this.createDao(RetirementDaoInterface.class);
        this.humanNoraml = (HumanNormalReferenceBeanInterface)this.createBean(HumanNormalReferenceBeanInterface.class);
        this.humanHistory = (HumanHistoryReferenceBeanInterface)this.createBean(HumanHistoryReferenceBeanInterface.class);
        this.humanArray = (HumanArrayReferenceBeanInterface)this.createBean(HumanArrayReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
    }

    public void export(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        List csvDataList = this.getCsvDataList(exportCode, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (csvDataList.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName(exportCode, targetDate);
    }

    protected List<String[]> getCsvDataList(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        ExportDtoInterface exportDto = this.exportDao.findForKey(exportCode);
        List fieldList = this.exportFieldDao.findForList(exportCode);
        this.addHumanData(csvDataList, fieldList, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addEntranceData(csvDataList, fieldList);
        this.addRetirementData(csvDataList, fieldList);
        this.addHumanGeneralData(csvDataList, fieldList, targetDate);
        if (exportDto.getHeader() != 0) {
            this.addHeader(csvDataList, fieldList);
        }
        return csvDataList;
    }

    protected void addHeader(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList) {
        String[] header = new String[fieldList.size()];
        int i = 0;
        for (ExportFieldDtoInterface field : fieldList) {
            String headerName = this.mospParams.getName(field.getFieldName());
            if (headerName != null && !headerName.isEmpty()) {
                header[i++] = headerName;
                continue;
            }
            String[] fieldNames = MospUtility.split((String)field.getFieldName(), (String)",");
            if (fieldNames.length > 1) {
                header[i++] = this.mospParams.getName(fieldNames[1]) + this.mospParams.getName("FrontParentheses") + this.mospParams.getName(fieldNames[0]) + this.mospParams.getName("BackParentheses");
                continue;
            }
            header[i++] = this.getCodeName(field.getFieldName(), "pfm_human");
        }
        csvDataList.add(0, header);
    }

    protected void addHumanData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        this.humanList = this.humanSearch.search();
        for (HumanDtoInterface human : this.humanList) {
            String[] csvData = new String[fieldList.size()];
            int i = 0;
            for (ExportFieldDtoInterface field : fieldList) {
                csvData[i++] = this.getHumanData(human, field.getFieldName(), targetDate);
            }
            csvDataList.add(csvData);
        }
    }

    protected void addEntranceData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList) throws MospException {
        Integer entranceDateIndex = null;
        for (ExportFieldDtoInterface field : fieldList) {
            if (!field.getFieldName().equals("entrance_date")) continue;
            entranceDateIndex = field.getFieldOrder() - 1;
            break;
        }
        if (entranceDateIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
            EntranceDtoInterface entrance = this.entranceDao.findForInfo(human.getPersonalId());
            if (entrance == null) continue;
            String[] csvData = csvDataList.get(i);
            csvData[entranceDateIndex.intValue()] = this.getStringDate(entrance.getEntranceDate());
        }
    }

    protected void addRetirementData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList) throws MospException {
        Integer retirementDateIndex = null;
        Integer retirementReasonIndex = null;
        Integer retirementDetailIndex = null;
        for (ExportFieldDtoInterface field : fieldList) {
            if (field.getFieldName().equals("retirement_date")) {
                retirementDateIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("retirement_reason")) {
                retirementReasonIndex = field.getFieldOrder() - 1;
            }
            if (!field.getFieldName().equals("retirement_detail")) continue;
            retirementDetailIndex = field.getFieldOrder() - 1;
        }
        if (retirementDateIndex == null && retirementReasonIndex == null && retirementDetailIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
            RetirementDtoInterface retirement = this.retirementDao.findForInfo(human.getPersonalId());
            if (retirement == null) continue;
            String[] csvData = csvDataList.get(i);
            if (retirementDateIndex != null) {
                csvData[retirementDateIndex.intValue()] = this.getStringDate(retirement.getRetirementDate());
            }
            if (retirementReasonIndex != null) {
                csvData[retirementReasonIndex.intValue()] = retirement.getRetirementReason();
            }
            if (retirementDetailIndex == null) continue;
            csvData[retirementDetailIndex.intValue()] = retirement.getRetirementDetail();
        }
    }

    protected void addHumanGeneralData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate) throws MospException {
        for (ExportFieldDtoInterface field : fieldList) {
            String[] fieldName = MospUtility.split((String)field.getFieldName(), (String)",");
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(fieldName[0]);
            if (viewConfig == null) continue;
            Integer index = field.getFieldOrder() - 1;
            if (index == null) {
                return;
            }
            for (int i = 0; i < this.humanList.size(); ++i) {
                HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
                String value = "";
                if (viewConfig.getType().equals("Normal")) {
                    value = this.humanNoraml.getNormalItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, targetDate, fieldName[1], true);
                }
                if (viewConfig.getType().equals("History")) {
                    value = this.humanHistory.getHistoryItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, fieldName[1], true);
                }
                if (viewConfig.getType().equals("Array")) {
                    value = this.humanArray.getArrayItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, fieldName[1], true);
                }
                String[] csvData = csvDataList.get(i);
                csvData[index.intValue()] = value;
            }
        }
    }

    protected String getHumanData(HumanDtoInterface human, String fieldName, Date targetDate) throws MospException {
        String data = "";
        if (fieldName.equals("employee_code")) {
            data = human.getEmployeeCode();
        } else if (fieldName.equals("activate_date")) {
            data = this.getStringDate(human.getActivateDate());
        } else if (fieldName.equals("last_name")) {
            data = human.getLastName();
        } else if (fieldName.equals("first_name")) {
            data = human.getFirstName();
        } else if (fieldName.equals("last_kana")) {
            data = human.getLastKana();
        } else if (fieldName.equals("first_kana")) {
            data = human.getFirstKana();
        } else if (fieldName.equals("work_place_code")) {
            data = human.getWorkPlaceCode();
        } else if (fieldName.equals("employment_contract_code")) {
            data = human.getEmploymentContractCode();
        } else if (fieldName.equals("section_code")) {
            data = human.getSectionCode();
        } else if (fieldName.equals("position_code")) {
            data = human.getPositionCode();
        } else if (fieldName.equals("section_name")) {
            data = this.sectionReference.getSectionName(human.getSectionCode(), targetDate);
        } else if (fieldName.equals("section_display")) {
            data = this.sectionReference.getSectionDisplay(human.getSectionCode(), targetDate);
        }
        return data;
    }

    public boolean isExistLikeFieldName(String exportCode, String[] aryFieldName) throws MospException {
        List list = this.exportFieldDao.findLikeStartNameList(exportCode, aryFieldName);
        list = list == null ? new ArrayList() : list;
        return !list.isEmpty();
    }

    protected void setFileName(String exportCode, Date targetDate) {
        String fileName = exportCode + this.mospParams.getName("Hyphen") + DateUtility.getStringYear((Date)targetDate) + DateUtility.getStringMonth((Date)targetDate) + DateUtility.getStringDay((Date)targetDate) + ".csv";
        this.mospParams.setFileName(fileName);
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

