/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ExportFieldRegistBeanInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.file.impl.PfaExportFieldDto;

public class ExportFieldRegistBean
extends PlatformBean
implements ExportFieldRegistBeanInterface {
    ExportFieldDaoInterface dao;

    public ExportFieldRegistBean() {
    }

    public ExportFieldRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
    }

    public ExportFieldDtoInterface getInitDto() {
        return new PfaExportFieldDto();
    }

    public void insert(String exportCode, String inactivateFlag, String[] fieldArray) throws MospException {
        this.validateAryField(fieldArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ExportFieldDtoInterface dto = this.getInitDto();
        int i = 0;
        for (String fieldName : fieldArray) {
            this.setDtoFields(dto, exportCode, inactivateFlag, fieldName, ++i);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setPfaExportFieldId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(String exportCode, String inactivateFlag, String[] fieldArray) throws MospException {
        this.validateAryField(fieldArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = this.dao.findForList(exportCode);
        for (ExportFieldDtoInterface dto : list) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaExportFieldId());
        }
        ExportFieldDtoInterface dto = this.getInitDto();
        int i = 0;
        for (String fieldName : fieldArray) {
            this.setDtoFields(dto, exportCode, inactivateFlag, fieldName, ++i);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setPfaExportFieldId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(String exportCode) throws MospException {
        List list = this.dao.findForList(exportCode);
        for (ExportFieldDtoInterface dto : list) {
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaExportFieldId());
        }
    }

    protected void checkInsert(ExportFieldDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getExportCode(), dto.getFieldName()));
    }

    protected void checkUpdate(ExportFieldDtoInterface dto) {
    }

    protected void checkDelete(ExportFieldDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaExportFieldId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void validate(ExportFieldDtoInterface dto) {
    }

    protected void validateAryField(String[] aryField) {
        if (aryField == null || aryField.length == 0) {
            this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Select", new String[]{"Item"})});
        }
    }

    protected void setDtoFields(ExportFieldDtoInterface dto, String exportCode, String inactivateFlag, String fieldName, int i) {
        dto.setExportCode(exportCode);
        dto.setFieldName(fieldName);
        dto.setFieldOrder(i);
        dto.setInactivateFlag(Integer.parseInt(inactivateFlag));
    }
}

