/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ExportBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;

public abstract class PlatformExportBean
extends PlatformBean
implements ExportBeanInterface {
    protected static final String FILENAME_EXTENSION_CSV = ".csv";
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected HumanSearchBeanInterface humanSearch;
    protected ExportDtoInterface exportDto;
    protected List<ExportFieldDtoInterface> fieldList;
    protected Map<Integer, String> indexes;

    public PlatformExportBean() {
    }

    protected PlatformExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
    }

    public void export(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.setExportInfo(exportCode);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List csvDataList = this.getCsvDataList(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (csvDataList.isEmpty()) {
            PlatformMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            return;
        }
        this.addHeader(csvDataList);
        this.setFile(csvDataList);
        this.setFileName(exportCode, targetDate);
    }

    protected abstract List<String[]> getCsvDataList(Date var1, String var2, String var3, String var4, String var5) throws MospException;

    protected void setExportInfo(String exportCode) throws MospException {
        this.exportDto = this.exportDao.findForKey(exportCode);
        this.fieldList = this.exportFieldDao.findForList(exportCode);
        if (this.exportDto == null || this.fieldList.isEmpty()) {
            PlatformMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
        }
        this.indexes = new TreeMap();
        for (ExportFieldDtoInterface field : this.fieldList) {
            this.indexes.put(field.getFieldOrder(), field.getFieldName());
        }
    }

    protected void addHeader(List<String[]> csvDataList) {
        if (this.exportDto.getHeader() == 0) {
            return;
        }
        String exportTable = this.exportDto.getExportTable();
        ArrayList<String> header = new ArrayList<String>();
        for (ExportFieldDtoInterface field : this.fieldList) {
            header.add(this.getCodeName(field.getFieldName(), exportTable));
        }
        csvDataList.add(0, MospUtility.toArray(header));
    }

    protected void setFile(List<String[]> csvDataList) {
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams(csvDataList));
    }

    protected void setFileName(String exportCode, Date targetDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(exportCode);
        sb.append(PlatformNamingUtility.hyphen((MospParams)this.mospParams));
        sb.append(DateUtility.getStringDateNoSeparator((Date)targetDate));
        sb.append(FILENAME_EXTENSION_CSV);
        this.mospParams.setFileName(sb.toString());
    }

    protected List<HumanDtoInterface> searchHumanData(Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        return this.humanSearch.search();
    }
}

