/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.base;

import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.base.AdditionalLogicBeanInterface;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.dao.human.ConcurrentDaoInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.platform.utils.PlatformUtility;

public abstract class PlatformBean
extends BaseBean {
    protected static final String SEPARATOR_DATA = ",";
    private boolean isAdditionalLogicExecution = false;

    public PlatformBean() {
    }

    protected PlatformBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    protected void checkExclusive(BaseDaoInterface dao, long id) throws MospException {
        this.checkExclusive((BaseDtoInterface)this.findForKey(dao, id, false));
    }

    protected void checkExclusive(BaseDtoInterface dto) throws MospException {
        if (dto == null || dto.getDeleteFlag() == 1) {
            this.addExclusiveErrorMessage();
        }
    }

    protected void checkDuplicateInsert(List<?> list) {
        if (!list.isEmpty()) {
            PlatformMessageUtility.addErrorDuplicate((MospParams)this.mospParams);
        }
    }

    protected void checkDuplicateInsert(BaseDtoInterface dto) {
        if (dto != null) {
            PlatformMessageUtility.addErrorDuplicate((MospParams)this.mospParams);
        }
    }

    protected void checkDuplicateAdd(BaseDtoInterface dto) {
        if (dto != null) {
            this.mospParams.addErrorMessage("PFW0205", new String[0]);
        }
    }

    protected String[][] getNoObjectDataPulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getProperties().getName("NoObjectData")}};
        return aryPulldown;
    }

    protected Date getDateClone(Date date) {
        return CapsuleUtility.getDateClone((Date)date);
    }

    protected String[] getStringArrayClone(String[] array) {
        return CapsuleUtility.getStringArrayClone((String[])array);
    }

    protected String[][] getStringArrayClone(String[][] array) {
        return CapsuleUtility.getStringArrayClone((String[][])array);
    }

    protected void validateAryId(long[] aryId) {
        if (aryId == null || aryId.length == 0) {
            PlatformMessageUtility.addErrorRequireCheck((MospParams)this.mospParams);
        }
    }

    protected List<HumanDtoInterface> getHumanListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        HumanDaoInterface humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        List humanList = humanDao.findForActivateDate(dto.getActivateDate());
        humanList.addAll(humanDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return humanList;
    }

    protected List<ConcurrentDtoInterface> getConcurrentListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ConcurrentDaoInterface concurrentDao = (ConcurrentDaoInterface)this.createDao(ConcurrentDaoInterface.class);
        List concurrentList = concurrentDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list));
        return concurrentList;
    }

    protected boolean needCheckTermForAdd(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        int idx;
        for (idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) <= 0) break;
        }
        if (idx == 0) {
            return true;
        }
        return this.isDtoActivate((BaseDtoInterface)list.get(idx - 1));
    }

    protected boolean needCheckTermForDelete(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        for (int idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) != 0) continue;
            if (idx == 0 || !this.isDtoActivate((BaseDtoInterface)list.get(idx - 1))) break;
            return false;
        }
        return true;
    }

    protected Date getEffectiveLastDate(Date targetDate, List<? extends PlatformDtoInterface> list) throws MospException {
        Date effectiveLastDate = this.getNextActivateDate(targetDate, list);
        if (effectiveLastDate != null) {
            effectiveLastDate = DateUtility.addDay((Date)effectiveLastDate, (int)-1);
        }
        return effectiveLastDate;
    }

    protected Date getNextActivateDate(Date targetDate, List<? extends PlatformDtoInterface> list) {
        Date lastDate = null;
        for (PlatformDtoInterface platformDtoInterface : list) {
            if (targetDate.compareTo(platformDtoInterface.getActivateDate()) >= 0) continue;
            lastDate = platformDtoInterface.getActivateDate();
            break;
        }
        return lastDate;
    }

    protected boolean isEntered(String personalId, Date targetDate) throws MospException {
        EntranceDaoInterface entranceDao = (EntranceDaoInterface)this.createDao(EntranceDaoInterface.class);
        EntranceDtoInterface dto = entranceDao.findForInfo(personalId);
        if (dto == null || dto.getEntranceDate() == null) {
            return false;
        }
        return targetDate.compareTo(dto.getEntranceDate()) >= 0;
    }

    protected HumanDtoInterface getHumanInfo(String personalId, Date targetDate) throws MospException {
        HumanDaoInterface dao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        return dao.findForInfo(personalId, targetDate);
    }

    protected HumanDtoInterface getUserHumanInfo(Date targetDate) throws MospException {
        if (targetDate == null) {
            targetDate = this.getSystemDate();
        }
        if (this.mospParams.getUser() == null) {
            return null;
        }
        String personalId = this.mospParams.getUser().getPersonalId();
        return this.getHumanInfo(personalId, targetDate);
    }

    protected String[] getRangeWorkPlace(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeWorkPlace = range.getWorkPlace();
        if (rangeWorkPlace == null || rangeWorkPlace.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeWorkPlace, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getWorkPlaceCode().isEmpty()) continue;
            array[i] = dto.getWorkPlaceCode();
        }
        return array;
    }

    protected String[] getRangeEmploymentContract(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployment = range.getEmploymentContract();
        if (rangeEmployment == null || rangeEmployment.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployment, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getEmploymentContractCode().isEmpty()) continue;
            array[i] = dto.getEmploymentContractCode();
        }
        return array;
    }

    protected String[] getRangeSection(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeSection = range.getSection();
        if (rangeSection == null || rangeSection.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeSection, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getSectionCode().isEmpty()) continue;
            array[i] = dto.getSectionCode();
        }
        return array;
    }

    protected String[] getRangePosition(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangePosition = range.getPosition();
        if (rangePosition == null || rangePosition.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangePosition, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPositionCode().isEmpty()) continue;
            array[i] = dto.getPositionCode();
        }
        return array;
    }

    protected String[] getRangeEmployee(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployee = range.getEmployee();
        if (rangeEmployee == null || rangeEmployee.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployee, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPersonalId().isEmpty()) continue;
            array[i] = dto.getPersonalId();
        }
        return array;
    }

    protected boolean isDtoActivate(BaseDtoInterface dto) {
        return PlatformUtility.isDtoActivate((PlatformDtoInterface)((PlatformDtoInterface)dto));
    }

    protected boolean isDtoDeleted(BaseDtoInterface dto) {
        return dto.getDeleteFlag() == 1;
    }

    protected String getCodeName(String code, String[][] array) {
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(String code, String codeKey) {
        String[][] array = this.mospParams.getProperties().getCodeArray(codeKey, false);
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(int code, String codeKey) {
        return this.getCodeName(String.valueOf(code), codeKey);
    }

    protected boolean isSameDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return date1.equals(date2);
    }

    protected Date getSystemDate() {
        return DateUtility.getSystemDate();
    }

    protected Date getSystemTime() {
        return DateUtility.getSystemTime();
    }

    protected Date getSystemTimeAndSecond() {
        return DateUtility.getSystemTimeAndSecond();
    }

    protected Date addDay(Date date, int amount) {
        return DateUtility.addDay((Date)date, (int)amount);
    }

    protected String getStringDate(Date date) {
        return DateUtility.getStringDate((Date)date);
    }

    protected boolean checkDateOrder(Date before, Date after, boolean acceptSameDate) {
        if (before == null || after == null) {
            return true;
        }
        if (acceptSameDate && before.equals(after)) {
            return true;
        }
        return before.before(after);
    }

    protected boolean checkTermDuplicate(Date start1, Date end1, Date start2, Date end2) {
        if (end1 == null && end2 == null) {
            return !start1.equals(start2);
        }
        if (end1 == null) {
            return start1.before(start2) || start1.after(end2);
        }
        if (end2 == null) {
            return start2.before(start1) || start2.after(end1);
        }
        return start1.before(end2) || end1.after(start2);
    }

    protected void addNoCodeBeforeActivateDateMessage(String code) {
        this.mospParams.addErrorMessage("PFW0210", new String[]{code});
    }

    protected void addCodeIsUsedMessage(String code, HumanDtoInterface dto) {
        this.mospParams.addErrorMessage("PFW0207", new String[]{code, dto.getEmployeeCode()});
    }

    protected void addInvalidOrderMessage(String before, String after) {
        this.mospParams.addErrorMessage("PFW0217", new String[]{after, before});
    }

    protected boolean isForwardMatch(String condition, String value) {
        return PlatformUtility.isForwardMatch((String)condition, (String)value);
    }

    protected boolean isBroadMatch(String condition, String value) {
        return PlatformUtility.isBroadMatch((String)condition, (String)value);
    }

    protected boolean isExactMatch(String condition, String value) {
        return PlatformUtility.isExactMatch((String)condition, (String)value);
    }

    protected boolean isHumanNameMatch(String condition, String firstName, String lastName) throws MospException {
        if (this.isBroadMatch(condition, firstName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName + firstName)) {
            return true;
        }
        return this.isBroadMatch(condition, MospUtility.getHumansName((String)firstName, (String)lastName));
    }

    public void sortList(List<?> list, Class<?> cls, boolean isReverse) throws MospException {
        this.sortList(list, cls.getName(), isReverse);
    }

    public void sortList(List<?> list, String className, boolean isReverse) throws MospException {
        Comparator comp = InstanceFactory.loadComparator((String)className);
        if (isReverse) {
            comp = Collections.reverseOrder(comp);
        }
        Collections.sort(list, comp);
    }

    protected String[][] prepareSelectArray(int length, boolean needBlank) {
        if (!needBlank) {
            return new String[length][2];
        }
        String[][] array = new String[length + 1][2];
        array[0][0] = "";
        array[0][1] = "";
        return array;
    }

    protected String getCodedName(String code, String name, int length) {
        int i;
        StringBuffer sb = new StringBuffer();
        int doubleBytes = (length - code.length() + 1) / 2;
        int singleBytes = (length - code.length() + 1) % 2;
        sb.append(code);
        for (i = 0; i < doubleBytes; ++i) {
            sb.append("\u3000");
        }
        for (i = 0; i < singleBytes; ++i) {
            sb.append(" ");
        }
        sb.append(name);
        return sb.toString();
    }

    protected List<String> asList(String target, String regex) {
        return MospUtility.asList((String[])this.split(target, regex));
    }

    protected String[] split(String target, String regex) {
        return MospUtility.split((String)target, (String)regex);
    }

    protected String toSeparatedString(List<String> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    protected String toSeparatedString(String[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    protected String overlapValue(String values, String separator) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String value : this.asList(values, separator)) {
            if (idList.contains(value)) continue;
            idList.add(value);
        }
        return this.toSeparatedString(idList, separator);
    }

    protected String issueSequenceNo(long sequenceNo, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(sequenceNo);
    }

    protected Integer getInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Double getDouble(String value) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void checkRequired(Object value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRequired((Object)value)) {
            this.addRequiredErrorMessage(fieldName, row);
        }
    }

    protected void checkInputLength(String value, int length, String fieldName, Integer row) {
        if (!ValidateUtility.chkInputLength((String)value, (int)length)) {
            String[] rep = new String[]{fieldName, String.valueOf(length)};
            this.mospParams.addErrorMessage("PFW0106", rep);
        }
    }

    protected void checkLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            this.addMaxLengthErrorMessage(fieldName, maxLength, row);
        }
    }

    protected void checkByteLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkByteLength((String)value, (int)maxLength)) {
            this.addByteMaxLengthErrorMessage(fieldName, maxLength, row);
        }
    }

    protected void checkMailAddress(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[!#-9A-~]+@+[A-Za-z0-9]+.+[^.]$", (String)value)) {
            this.addUserIdErrorMessage(fieldName, row);
        }
    }

    protected void checkUserId(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[._@A-Za-z0-9-]*", (String)value)) {
            this.addUserIdErrorMessage(fieldName, row);
        }
    }

    protected void checkTypeCode(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[A-Za-z0-9]*", (String)value)) {
            this.addTypeCodeErrorMessage(fieldName, row);
        }
    }

    protected void checkTypeNumber(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[0-9]*", (String)value)) {
            this.addTypeNumberErrorMessage(fieldName, row);
        }
    }

    protected void checkTypeKana(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[\uff61-\uff9f -~]*", (String)value)) {
            this.addTypeKanaErrorMessage(fieldName, row);
        }
    }

    protected void checkAvailableChars(String value, List<String> availables, String fieldName, Integer row) {
        if (!availables.contains(value)) {
            PlatformMessageUtility.addErrorAvailableChars((MospParams)this.mospParams, (String)fieldName, availables, (Integer)row);
        }
    }

    protected void checDecimal(String value, int integerDigit, int decimalDigit, String fieldName, Integer row) {
        if (!ValidateUtility.chkDecimal((String)value, (int)integerDigit, (int)decimalDigit)) {
            PlatformMessageUtility.addErrorCheckDecimal((MospParams)this.mospParams, (String)fieldName, (int)integerDigit, (int)decimalDigit, (Integer)row);
        }
    }

    protected void checkInactivateFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            MessageUtility.addErrorMessageActivateOrInactivateInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkDeleteFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            MessageUtility.addErrorMessageDeleteFlagInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkFlag(int value, String fieldName, Integer row) {
        if (!PlatformUtility.isFlagOff((int)value) && !PlatformUtility.isFlagOn((int)value)) {
            MessageUtility.addErrorMessageFlagInvalid((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkUnderLimit(double value, String fieldName, int limit, Integer row) {
        if (value < (double)limit) {
            MessageUtility.addErrorMessageUnderLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected void checkOverLimit(double value, String fieldName, int limit, Integer row) {
        if (value > (double)limit) {
            MessageUtility.addErrorMessageOverLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected void addInputDataInvalidErrorMessage() {
        this.mospParams.addErrorMessage("PFW0101", new String[0]);
    }

    protected void addRequiredErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addMaxLengthErrorMessage(String fieldName, int maxLength, Integer row) {
        String[] rep = new String[]{this.getRowedFieldName(fieldName, row), String.valueOf(maxLength)};
        this.mospParams.addErrorMessage("PFW0123", rep);
    }

    protected void addByteMaxLengthErrorMessage(String fieldName, int maxLength, Integer row) {
        int halfLength = maxLength / 2;
        String[] rep = new String[]{this.getRowedFieldName(fieldName, row), String.valueOf(halfLength), String.valueOf(maxLength)};
        this.mospParams.addErrorMessage("PFW0126", rep);
    }

    protected void addUserIdErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0125", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addTypeCodeErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0111", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addTypeNumberErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0113", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addTypeKanaErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0115", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addExclusiveErrorMessage() {
        this.mospParams.addErrorMessage("PFW0206", new String[0]);
    }

    protected void addEmployeeRetiredMessage() {
        PlatformMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams, null);
    }

    protected void addEmployeeSuspendedMessage() {
        PlatformMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams, null);
    }

    protected String getRowedFieldName(String fieldName, Integer row) {
        if (row == null) {
            return fieldName;
        }
        return this.getRowColonName(row.intValue()) + fieldName;
    }

    protected String getRowColonName(int row) {
        return this.mospParams.getName("Row") + String.valueOf(row + 1) + this.mospParams.getName("Colon");
    }

    protected String getNameEmployeeCode() {
        return PlatformNamingUtility.employeeCode((MospParams)this.mospParams);
    }

    protected String getNameActivateDate() {
        return PlatformNamingUtility.activateDate((MospParams)this.mospParams);
    }

    protected String getNameSection() {
        return this.mospParams.getName("Section");
    }

    protected String getNamePosition() {
        return this.mospParams.getName("Position");
    }

    protected int getPersonalIdsMaxIndex() {
        return this.mospParams.getApplicationProperty("PersonalIdsMaxIndex", 5000);
    }

    protected String[] getPersonalIds(String[] srcArray, int fromIndex, int length) {
        int toIndex = fromIndex + length;
        if (toIndex > srcArray.length) {
            toIndex = srcArray.length;
        }
        String[] personalIds = new String[toIndex - fromIndex];
        for (int cnt = 0; cnt < personalIds.length; ++cnt) {
            personalIds[cnt] = srcArray[fromIndex + cnt];
        }
        return personalIds;
    }

    protected String[] getPersonalIdsSubList(List<String> personalIdList, int fromIndex, int length) {
        return this.getPersonalIds(personalIdList.toArray(new String[personalIdList.size()]), fromIndex, length);
    }

    protected String[] getPersonalIds(List<? extends PersonalIdDtoInterface> list) {
        ArrayList<String> personalIds = new ArrayList<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list) {
            personalIds.add(personalIdDtoInterface.getPersonalId());
        }
        return MospUtility.toArray(personalIds);
    }

    protected String[] getPersonalIds(List<? extends PersonalIdDtoInterface> list, int fromIndex, int length) {
        int toIndex = fromIndex + length;
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        ArrayList<String> personalIds = new ArrayList<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list.subList(fromIndex, toIndex)) {
            personalIds.add(personalIdDtoInterface.getPersonalId());
        }
        return MospUtility.toArray(personalIds);
    }

    protected List<?> getSubList(List<?> list, int fromIndex, int length) {
        int toIndex = fromIndex + length;
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        return list.subList(fromIndex, toIndex);
    }

    public void doAdditionalLogic(String codeKey) throws MospException {
        for (AdditionalLogicBeanInterface addonBean : this.getBeans(AdditionalLogicBeanInterface.class, codeKey)) {
            addonBean.doAdditionalLogic(new Object[0]);
        }
    }

    public boolean doAdditionalLogic(Object ... objects) throws MospException {
        String codeKey = (String)objects[0];
        for (AdditionalLogicBeanInterface addonBean : this.getBeans(AdditionalLogicBeanInterface.class, codeKey)) {
            this.isAdditionalLogicExecution = addonBean.doAdditionalLogic(objects);
        }
        return this.isAdditionalLogicExecution;
    }

    protected <T extends BaseBeanInterface> List<T> getBeans(Class<T> cls, String codeKey) throws MospException {
        ArrayList<BaseBeanInterface> addonBeans = new ArrayList<BaseBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(codeKey, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            BaseBeanInterface bean = this.createBean(cls, addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }
}

