/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.xml.ConvertManager;
import jp.mosp.framework.xml.ConvertManagerInterface;
import jp.mosp.framework.xml.ConvertResultInterface;
import jp.mosp.framework.xml.DocumentWrapper;
import jp.mosp.framework.xml.FileFinder;
import jp.mosp.framework.xml.FileFinderInterface;
import jp.mosp.framework.xml.MospPropertiesBuilderInterface;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MospPropertiesBuilder
implements MospPropertiesBuilderInterface {
    private FileFinderInterface finder;
    private ConvertManagerInterface manager;

    public MospProperties build(String docBase) throws MospException {
        this.init();
        List pathList = this.finder.getPathList(docBase);
        System.out.println("MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u89e3\u6790\u3002");
        List docList = this.parse(pathList);
        System.out.println("MosP\u8a2d\u5b9a\u60c5\u5831\u4f5c\u6210\u3002");
        ConvertResultInterface result = this.convert(docList);
        MospProperties properties = new MospProperties();
        properties.setApplicationProperties(result.getApplication());
        properties.setCommandProperties(result.getController());
        properties.setModelProperties(result.getModel());
        properties.setMessageProperties(result.getMessage());
        properties.setNamingProperties(result.getNaming());
        properties.setCodeProperties(result.getCode());
        properties.setAddonProperties(result.getAddon());
        properties.setMainMenuProperties(result.getMainMenu());
        properties.setRoleProperties(result.getRole());
        properties.setConventionProperties(result.getConvention());
        properties.setViewConfigProperties(result.getViewConfig());
        return properties;
    }

    void init() {
        this.setFinder((FileFinderInterface)new FileFinder());
        this.setManager((ConvertManagerInterface)new ConvertManager());
    }

    List<DocumentWrapper> parse(List<String> pathList) throws MospException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            throw new MospException((Throwable)e);
        }
        ArrayList<DocumentWrapper> documentList = new ArrayList<DocumentWrapper>();
        for (String path : pathList) {
            System.out.println(path);
            File file = new File(path);
            try {
                documentList.add(new DocumentWrapper(path, builder.parse(file)));
            }
            catch (SAXException e) {
                System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                throw new MospException((Throwable)e);
            }
            catch (IOException e) {
                System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                throw new MospException((Throwable)e);
            }
        }
        return documentList;
    }

    ConvertResultInterface convert(List<DocumentWrapper> list) throws MospException {
        ConvertResultInterface result = this.manager.init();
        for (DocumentWrapper document : list) {
            System.out.println(document.path);
            if (!document.isMosPDocument()) {
                System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u8981\u7d20\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                continue;
            }
            if (!document.isAddon()) {
                this.convert(result, document);
                continue;
            }
            if (!document.isAddonValid()) {
                System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c9\u30aa\u30f3\u8a2d\u5b9a\u304c\u7121\u52b9\u3067\u3059\u3002");
                continue;
            }
            this.convert(result, document);
            this.addAddonDir(result, document);
        }
        return result;
    }

    protected void convert(ConvertResultInterface result, DocumentWrapper document) {
        String path = document.path;
        NodeList nodeList = TagUtility.getElements((String)"MosP/*", (Object)document.getDocument());
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = nodeList.item(index);
            String tag = node.getNodeName();
            if (this.manager.isUnknown(tag)) {
                TagUtility.invalidTagMassage((String)path, (Node)node, (int)index);
                break;
            }
            this.manager.convert(result.get(tag), new NodeWrapper(path, node, index));
        }
    }

    protected void addAddonDir(ConvertResultInterface result, DocumentWrapper document) throws MospException {
        File file = new File(document.path);
        String addonId = file.getName().replace(".xml", "");
        String dirPath = file.getParent() + "/" + addonId;
        List pathList = this.finder.getFilePathList(dirPath, false);
        List docList = this.parse(pathList);
        for (DocumentWrapper addonDocument : docList) {
            if (!addonDocument.isMosPDocument()) {
                System.out.println("  MosP\u8a2d\u5b9a\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u8981\u7d20\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                continue;
            }
            this.convert(result, addonDocument);
        }
    }

    public void setFinder(FileFinderInterface finder) {
        this.finder = finder;
    }

    public void setManager(ConvertManagerInterface manager) {
        this.manager = manager;
    }
}

