/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.CodeItemProperty;
import jp.mosp.framework.property.CodeProperty;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeTagConverter
implements TagConverterInterface {
    private static final String TAG_CODE_ITEM = "CodeItem";
    private static final String TAG_ITEM_NAME = "ItemName";
    private static final String TAG_VIEW_INDEX = "ViewIndex";
    private static final String TAG_VIEW_FLAG = "ViewFlag";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        NodeList codeItemList = TagUtility.getElements((String)TAG_CODE_ITEM, (Object)node);
        if (codeItemList.getLength() == 0) {
            TagUtility.invalidMassage((String)path, (Node)node);
            return;
        }
        BaseProperty baseProperty = properties.get(key);
        if (baseProperty == null) {
            baseProperty = new CodeProperty(key);
        }
        CodeProperty property = (CodeProperty)baseProperty;
        Map codeItemMap = property.getCodeItemMap();
        int length = codeItemList.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = codeItemList.item(itemIndex);
            CodeItemProperty codeItem = this.toCodeItemProperty(item);
            if (codeItem == null) {
                TagUtility.invalidItemMassage((String)path, (Node)node, (String)TAG_CODE_ITEM, (int)itemIndex);
                continue;
            }
            codeItemMap.put(codeItem.getKey(), codeItem);
        }
        properties.put(key, (BaseProperty)property);
    }

    protected CodeItemProperty toCodeItemProperty(Node item) {
        String key = TagUtility.getKey((Node)item);
        if (key.isEmpty()) {
            return null;
        }
        NodeList list = item.getChildNodes();
        int length = list.getLength();
        String itemName = "";
        int viewIndex = 0;
        int viewFlag = 0;
        for (int index = 0; index < length; ++index) {
            Node codeItem = list.item(index);
            if (TagUtility.isTag((Node)codeItem, (String)TAG_ITEM_NAME)) {
                itemName = TagUtility.trimText((Node)codeItem);
            }
            if (TagUtility.isTag((Node)codeItem, (String)TAG_VIEW_INDEX)) {
                try {
                    viewIndex = Integer.parseInt(TagUtility.trimText((Node)codeItem));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (!TagUtility.isTag((Node)codeItem, (String)TAG_VIEW_FLAG)) continue;
            try {
                viewFlag = Integer.parseInt(TagUtility.trimText((Node)codeItem));
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new CodeItemProperty(key, itemName, viewIndex, viewFlag);
    }
}

