/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import jp.mosp.framework.utils.MospUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidateUtility {
    protected static final String REG_DECIMAL = "[0-9]{0,%1%}(\\.([0-9]{1,%2%}))?";

    private ValidateUtility() {
    }

    public static boolean chkRequired(Object value) {
        if (value instanceof String) {
            return !value.equals("");
        }
        return value != null;
    }

    public static boolean chkRegex(String regex, String value) {
        return value.matches(regex);
    }

    public static boolean chkNumeric(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkDecimal(String value, int integerDigit, int decimalDigit) {
        String regex = ValidateUtility.getReplacedString((String)"[0-9]{0,%1%}(\\.([0-9]{1,%2%}))?", (String[])new String[]{String.valueOf(integerDigit), String.valueOf(decimalDigit)});
        return ValidateUtility.chkRegex((String)regex, (String)value);
    }

    public static String getReplacedString(String value, String ... rep) {
        String replaced = value;
        if (rep == null) {
            return value;
        }
        for (int i = 0; i < rep.length; ++i) {
            replaced = replaced.replaceAll("%" + String.valueOf(i + 1) + "%", rep[i]);
        }
        return replaced;
    }

    public static boolean chkDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(year, month, day);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTime(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(1970, 0, 1, hour, minute, second);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTerm(Date date, Date startDate, Date endDate) {
        return startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0;
    }

    public static boolean chkInputLength(String value, int length) {
        int valueLength = value.length();
        return valueLength == length;
    }

    public static boolean chkLength(String value, int maxLength) {
        String regex = "(?s).{0," + String.valueOf(maxLength) + "}";
        return ValidateUtility.chkRegex((String)regex, (String)value);
    }

    public static boolean chkByteLength(String value, int maxLength) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        try {
            return value.getBytes("Shift-JIS").length <= maxLength;
        }
        catch (UnsupportedEncodingException e) {
            return MospUtility.getBytes((String)value).length <= maxLength;
        }
    }

    public static boolean chkDuplTime(Date bStart, Date bEnd, Date aStart, Date aEnd) {
        if (bStart == null || bEnd == null) {
            return false;
        }
        if (aStart != null && aEnd != null) {
            return bEnd.after(aStart) && bStart.before(aEnd);
        }
        return false;
    }

    public static boolean chkRestTime(Date startTime, Date endTime, Date restStartTime, Date restEndTime) {
        if (restStartTime != null && restEndTime != null) {
            if (startTime != null && startTime.after(restStartTime)) {
                return true;
            }
            if (endTime != null && endTime.before(restEndTime)) {
                return true;
            }
        }
        return false;
    }
}

