/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospUser;
import jp.mosp.framework.comparator.IndexComparator;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.framework.utils.MospUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class RoleUtility {
    public static final String ROLE_TYPE_MAIN = "";
    protected static final String ROLE_EXTRA_DEFAULT = "default";
    protected static final String ROLE_EXTRA_NEEDED = "needed";
    protected static final String ROLE_EXTRA_SUPER = "super";
    protected static final String ROLE_EXTRA_APPROVER = "approver";
    protected static final String ROLE_EXTRA_CALCULATOR = "calculator";

    private RoleUtility() {
    }

    public static Map<String, String> getRoles(MospParams mospParams, String roleType) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List list = RoleUtility.getRoleProperties((MospParams)mospParams, (String)roleType);
        for (RoleProperty role : list) {
            map.put(role.getKey(), role.getRoleName());
        }
        return map;
    }

    public static boolean isTheRoleCodeSet(MospParams mospParams, String roleCode) {
        Set set = RoleUtility.getUserRoleCodes((MospParams)mospParams);
        return set.contains(roleCode);
    }

    public static boolean isTheRoleExtraSet(MospParams mospParams, String roleExtra) {
        Set set = RoleUtility.getUserRoleExtras((MospParams)mospParams);
        return set.contains(roleExtra);
    }

    public static boolean isTheRoleExtraSet(MospParams mospParams, String roleCode, String roleExtra) {
        RoleProperty role = RoleUtility.getRoleProperty((MospParams)mospParams, (String)roleCode);
        if (role == null) {
            return false;
        }
        return MospUtility.asList((String)role.getRoleExtra(), (String)",").contains(roleExtra);
    }

    public static boolean isSuper(MospParams mospParams) {
        return RoleUtility.isTheRoleExtraSet((MospParams)mospParams, (String)"super");
    }

    public static boolean isApprover(MospParams mospParams) {
        return RoleUtility.isTheRoleExtraSet((MospParams)mospParams, (String)"approver");
    }

    public static boolean isCalculator(MospParams mospParams) {
        return RoleUtility.isTheRoleExtraSet((MospParams)mospParams, (String)"calculator");
    }

    public static Set<String> getUserMenuKeys(MospParams mospParams) {
        ArrayList list = new ArrayList();
        for (RoleProperty roleProperty : RoleUtility.getUserRoles((MospParams)mospParams)) {
            list.addAll(roleProperty.getRoleMenuMap().values());
        }
        Collections.sort(list, new IndexComparator());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RoleMenuProperty roleMenu : list) {
            set.add(roleMenu.getKey());
        }
        return set;
    }

    public static Map<String, RangeProperty> getUserRanges(MospParams mospParams, String menuKey) {
        Map rangeMap = null;
        for (RoleProperty roleProperty : RoleUtility.getUserRoles((MospParams)mospParams)) {
            RoleMenuProperty menu = (RoleMenuProperty)roleProperty.getRoleMenuMap().get(menuKey);
            if (menu == null) continue;
            if (rangeMap == null) {
                rangeMap = RoleUtility.copyRangeMap((Map)menu.getRangeMap());
                continue;
            }
            RoleUtility.addRangeMap((Map)rangeMap, (Map)menu.getRangeMap());
        }
        return rangeMap;
    }

    public static boolean hasAuthority(MospParams mospParams, String command) {
        if (command == null || command.isEmpty()) {
            return false;
        }
        Set rolePropertys = RoleUtility.getUserRoles((MospParams)mospParams);
        for (RoleProperty roleProperty : rolePropertys) {
            if (!roleProperty.getRejectCmdList().contains(command)) continue;
            return false;
        }
        for (RoleProperty roleProperty : rolePropertys) {
            List acceptCmdList = roleProperty.getAcceptCmdList();
            if (acceptCmdList.contains(command)) {
                return true;
            }
            String wildCardCommand = MospUtility.getWildCardCommand((String)command);
            while (!wildCardCommand.isEmpty()) {
                if (acceptCmdList.contains(wildCardCommand)) {
                    return true;
                }
                wildCardCommand = MospUtility.getWildCardCommand((String)wildCardCommand);
            }
        }
        return false;
    }

    public static List<String> getHiddenDivisionsList(MospParams mospParams) {
        ArrayList<String> list = new ArrayList<String>();
        for (RoleProperty roleProperty : RoleUtility.getUserRoles((MospParams)mospParams)) {
            list.addAll(roleProperty.getHiddenDivisionsList());
        }
        return list;
    }

    public static List<String> getReferenceDivisionsList(MospParams mospParams) {
        ArrayList<String> list = new ArrayList<String>();
        for (RoleProperty roleProperty : RoleUtility.getUserRoles((MospParams)mospParams)) {
            list.addAll(roleProperty.getReferenceDivisionsList());
        }
        return list;
    }

    public static Set<String> getApproverRoles(MospParams mospParams) {
        HashSet<String> set = new HashSet<String>();
        Map approverRolesMap = RoleUtility.getRoleExtraCodes((MospParams)mospParams, (String)"approver");
        for (Set approverRoles : approverRolesMap.values()) {
            set.addAll(approverRoles);
        }
        return set;
    }

    public static String getNeededRole(MospParams mospParams) {
        Set set = (Set)RoleUtility.getRoleExtraCodes((MospParams)mospParams, (String)"needed").get("");
        if (set == null || set.isEmpty()) {
            return "";
        }
        return (String)set.iterator().next();
    }

    public static String getDefaultRole(MospParams mospParams, String roleType) {
        Set set = (Set)RoleUtility.getRoleExtraCodes((MospParams)mospParams, (String)"default").get(roleType);
        return MospUtility.getFirstString((Collection)set);
    }

    public static String getDefaultRole(MospParams mospParams) {
        return RoleUtility.getDefaultRole((MospParams)mospParams, (String)"");
    }

    public static String getSuperRole(MospParams mospParams) {
        Set set = (Set)RoleUtility.getRoleExtraCodes((MospParams)mospParams, (String)"super").get("");
        return MospUtility.getFirstString((Collection)set);
    }

    protected static Set<RoleProperty> getUserRoles(MospParams mospParams) {
        LinkedHashSet<RoleProperty> set = new LinkedHashSet<RoleProperty>();
        for (String roleCode : RoleUtility.getUserRoleCodes((MospParams)mospParams)) {
            RoleProperty roleProperty = RoleUtility.getRoleProperty((MospParams)mospParams, (String)roleCode);
            if (roleProperty == null) continue;
            set.add(roleProperty);
        }
        return set;
    }

    protected static Set<String> getUserRoleCodes(MospParams mospParams) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        MospUser user = mospParams.getUser();
        if (user == null) {
            return set;
        }
        set.add(user.getRole());
        set.addAll(user.getExtraRoles());
        return set;
    }

    protected static Set<String> getUserRoleExtras(MospParams mospParams) {
        HashSet<String> set = new HashSet<String>();
        Set roles = RoleUtility.getUserRoles((MospParams)mospParams);
        for (RoleProperty role : roles) {
            set.addAll(MospUtility.asList((String)role.getRoleExtra(), (String)","));
        }
        return set;
    }

    protected static RoleProperty getRoleProperty(MospParams mospParams, String roleCode) {
        return (RoleProperty)mospParams.getProperties().getRoleProperties().get(roleCode);
    }

    protected static List<RoleProperty> getRoleProperties(MospParams mospParams, String roleType) {
        ArrayList<RoleProperty> list = new ArrayList<RoleProperty>();
        Map all = mospParams.getProperties().getRoleProperties();
        for (RoleProperty roleProperty : all.values()) {
            if (roleType != null && !roleType.equals(roleProperty.getRoleType())) continue;
            list.add(roleProperty);
        }
        Collections.sort(list, new IndexComparator());
        return list;
    }

    protected static Map<String, RangeProperty> copyRangeMap(Map<String, RangeProperty> rangeMap) {
        HashMap<String, RangeProperty> map = new HashMap<String, RangeProperty>();
        for (Map.Entry<String, RangeProperty> entry : rangeMap.entrySet()) {
            String operationType = entry.getKey();
            RangeProperty value = entry.getValue();
            String workPlace = value.getWorkPlace();
            String employmentContract = value.getEmploymentContract();
            String section = value.getSection();
            String position = value.getPosition();
            String employee = value.getEmployee();
            RangeProperty range = new RangeProperty(operationType, workPlace, employmentContract, section, position, employee);
            map.put(operationType, range);
        }
        return map;
    }

    protected static void addRangeMap(Map<String, RangeProperty> rangeMap, Map<String, RangeProperty> extraMap) {
        for (String operationType : RoleUtility.getOperationTypes()) {
            RangeProperty range = rangeMap.get(operationType);
            if (range == null) continue;
            RangeProperty value = extraMap.get(operationType);
            if (value == null) {
                rangeMap.remove(operationType);
                continue;
            }
            String workPlace = RoleUtility.margeRange((String[])new String[]{range.getWorkPlace(), value.getWorkPlace()});
            String employmentContract = RoleUtility.margeRange((String[])new String[]{range.getEmploymentContract(), value.getEmploymentContract()});
            String section = RoleUtility.margeRange((String[])new String[]{range.getSection(), value.getSection()});
            String position = RoleUtility.margeRange((String[])new String[]{range.getPosition(), value.getPosition()});
            String employee = RoleUtility.margeRange((String[])new String[]{range.getEmployee(), value.getEmployee()});
            range = new RangeProperty(operationType, workPlace, employmentContract, section, position, employee);
            rangeMap.put(operationType, range);
        }
    }

    protected static String margeRange(String ... values) {
        LinkedHashSet set = new LinkedHashSet();
        for (String value : values) {
            set.addAll(MospUtility.asList((String)value, (String)","));
        }
        return MospUtility.toSeparatedString(set, (String)",");
    }

    protected static Set<String> getOperationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        return set;
    }

    protected static Map<String, Set<String>> getRoleExtraCodes(MospParams mospParams, String roleExtra) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        List all = RoleUtility.getRoleProperties((MospParams)mospParams, null);
        for (RoleProperty roleProperty : all) {
            String roleCode = roleProperty.getKey();
            String roleType = roleProperty.getRoleType();
            if (!RoleUtility.isTheRoleExtraSet((MospParams)mospParams, (String)roleCode, (String)roleExtra)) continue;
            TreeSet<String> set = (TreeSet<String>)map.get(roleType);
            if (set == null) {
                set = new TreeSet<String>();
                map.put(roleType, set);
            }
            set.add(roleCode);
        }
        return map;
    }
}

