/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.framework.property.AddonProperty;
import jp.mosp.framework.property.MessageProperty;
import jp.mosp.framework.property.ModelProperty;
import jp.mosp.framework.property.MospProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MospUtility {
    private static final String[] SUFFIX_ARRAY = new String[]{"BeanInterface", "Bean", "Interface"};
    public static final char CHR_SEPARATOR_SPACE = ' ';
    public static final String WILD_CARD_COMMAND = "*";
    public static final String CHARACTER_ENCODING = "UTF-8";

    private MospUtility() {
    }

    public static String getModelClass(String modelKey, MospProperties mospProperties, Date targetDate) throws MospException {
        Map modelProperties = mospProperties.getModelProperties();
        ModelProperty modelProperty = (ModelProperty)modelProperties.get(modelKey);
        if (modelProperty == null) {
            throw new MospException((Throwable)new Exception(), "FWE9104", modelKey);
        }
        if (targetDate == null) {
            return modelProperty.getModelClass();
        }
        Map modelClassMap = modelProperty.getModelClassMap();
        ArrayList keyList = new ArrayList(modelClassMap.keySet());
        Collections.sort(keyList);
        Collections.reverse(keyList);
        for (Date key : keyList) {
            if (key.after(targetDate)) continue;
            return (String)modelClassMap.get(key);
        }
        return modelProperty.getModelClass();
    }

    public static String getModelClass(Class<?> cls, MospProperties mospProperties, Date targetDate) throws MospException {
        String modelKey = MospUtility.getModelKey(cls);
        return MospUtility.getModelClass((String)modelKey, (MospProperties)mospProperties, (Date)targetDate);
    }

    protected static String getModelKey(Class<?> cls) {
        String key = cls.getSimpleName();
        for (String suffix : SUFFIX_ARRAY) {
            if (key.indexOf(suffix) != key.length() - suffix.length()) continue;
            key = key.replace(suffix, "");
            break;
        }
        return key;
    }

    public static void outputMessageJs(MospProperties mospProperties) throws MospException {
        String path = mospProperties.getApplicationProperty("Docbase") + "/pub/common/js/message.js";
        String name = "messages";
        Map messageProperties = mospProperties.getMessageProperties();
        StringBuffer sb = new StringBuffer();
        sb.append("var ");
        sb.append("messages");
        sb.append(" = new Object();");
        sb.append(MospConst.LINE_SEPARATOR);
        for (Map.Entry entry : messageProperties.entrySet()) {
            MessageProperty messageProperty = (MessageProperty)entry.getValue();
            if (!messageProperty.getClientAvailable()) continue;
            sb.append("messages");
            sb.append("[\"");
            sb.append(messageProperty.getKey());
            sb.append("\"] = \"");
            sb.append(messageProperty.getMessageBody());
            sb.append("\";");
            sb.append(MospConst.LINE_SEPARATOR);
        }
        MospUtility.outputFile((MospProperties)mospProperties, (String)path, (String)sb.toString());
    }

    public static String getCodeItemCode(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[0];
        }
        return code;
    }

    public static String getCodeName(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[1];
        }
        return code;
    }

    public static String[][] getCodeArray(MospParams mospParams, String codeKey, boolean needBlank) {
        return mospParams.getProperties().getCodeArray(codeKey, needBlank);
    }

    public static String getCodeName(MospParams mospParams, String code, String codeKey) {
        return MospUtility.getCodeName((String)code, (String[][])MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)false));
    }

    public static String getCodeName(MospParams mospParams, int code, String codeKey) {
        return MospUtility.getCodeName((MospParams)mospParams, (String)String.valueOf(code), (String)codeKey);
    }

    public static boolean isCodeExist(String code, String[][] array) {
        if (code == null) {
            return false;
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getCodeList(MospParams mospParams, String codeKey, boolean needBlank) {
        String[][] codeArray;
        ArrayList<String> list = new ArrayList<String>();
        for (String[] array : codeArray = MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)needBlank)) {
            list.add(array[0]);
        }
        return list;
    }

    public static Map<String, String> getCodeMap(MospParams mospParams, String codeKey) {
        return MospUtility.asMap((String[][])MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outputFile(MospProperties mospProperties, String path, String body) throws MospException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(path, false);
            osw = new OutputStreamWriter((OutputStream)fos, mospProperties.getApplicationProperty("CharacterEncoding"));
            osw.write(body);
            return;
        }
        catch (FileNotFoundException e) {
            throw new MospException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MospException((Throwable)e);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                throw new MospException((Throwable)e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    throw new MospException((Throwable)e);
                }
            }
        }
    }

    public static String getLoginPersonalId(MospParams mospParams) {
        if (mospParams.getUser() == null) {
            return "";
        }
        String personalId = mospParams.getUser().getPersonalId();
        if (MospUtility.isEmpty((String[])new String[]{personalId})) {
            return "";
        }
        return personalId;
    }

    public static String getTopicPathName(MospParams mospParams) {
        TopicPath topicPath = (TopicPath)MospUtility.getLastValue((Collection)mospParams.getTopicPathList());
        if (topicPath == null) {
            return "";
        }
        String name = topicPath.getName();
        if (MospUtility.isEmpty((String[])new String[]{name})) {
            return "";
        }
        return name;
    }

    public static String getHumansName(String firstName, String lastName) {
        return MospUtility.concat((String[])new String[]{lastName, firstName});
    }

    public static String getWildCardCommand(String command) {
        String wildCardCommand = command.replaceAll("\\*", "");
        if (wildCardCommand.isEmpty()) {
            return wildCardCommand;
        }
        return wildCardCommand.substring(0, wildCardCommand.length() - 1) + "*";
    }

    public static boolean isAddonValid(MospParams mospParams, String addonKey) {
        AddonProperty addon = (AddonProperty)mospParams.getProperties().getAddonProperties().get(addonKey);
        if (addon == null) {
            return false;
        }
        return addon.isAddonValid();
    }

    public static String concat(String ... strs) {
        return MospUtility.concat((Object)Character.valueOf(' '), (String[])strs);
    }

    public static String concat(Object separator, String ... strs) {
        StringBuffer sb = new StringBuffer();
        if (strs == null) {
            return sb.toString();
        }
        for (String str : strs) {
            if (str == null || str.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String[] split(String target, String regex) {
        if (target == null || target.trim().isEmpty()) {
            return new String[0];
        }
        String[] array = target.split(regex);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    public static List<String> asList(String target, String regex) {
        return MospUtility.asList((String[])MospUtility.split((String)target, (String)regex));
    }

    public static List<String> asList(String[] array) {
        return Arrays.asList(array);
    }

    public static List<Long> asList(long[] array) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static String[] toArray(String ... strs) {
        return strs;
    }

    public static Integer[] toArrayInt(List<Integer> list) {
        return list.toArray(new Integer[list.size()]);
    }

    public static long[] toArrayLong(List<Long> list) {
        long[] array = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static Map<String, String> asMap(String[][] arrays) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String[] array : arrays) {
            map.put(array[0], array[1]);
        }
        return map;
    }

    public static String toSeparatedString(String[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    public static String toSeparatedString(Collection<String> collection, String separator) {
        String[] array = MospUtility.toArray(new ArrayList<String>(collection));
        return MospUtility.toSeparatedString((String[])array, (String)separator);
    }

    public static String partDelete(String value, int index) {
        if (value == null || value.isEmpty() || index < 0) {
            return "";
        }
        if (value.length() - 1 < index) {
            return value;
        }
        StringBuilder sb1 = new StringBuilder(value);
        sb1.deleteCharAt(index);
        return sb1.toString();
    }

    public static String substring(String value, int length) {
        if (value == null || value.isEmpty() || length < 0) {
            return "";
        }
        if (value.length() < length) {
            return value;
        }
        return value.substring(0, length);
    }

    public static boolean isEmpty(String ... strs) {
        for (String str : strs) {
            if (str != null && !str.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static <T> T getFirstValue(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T getLastValue(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        T value2 = null;
        for (T value2 : collection) {
        }
        return value2;
    }

    public static String getFirstString(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        return collection.iterator().next();
    }

    public static String getListValue(List<String> list, int idx) {
        if (list == null || list.size() <= idx) {
            return "";
        }
        return list.get(idx);
    }

    public static int getInt(Object value) {
        try {
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String msg = sw.toString();
        msg = msg.replaceAll(MospConst.LINE_SEPARATOR, "");
        return msg;
    }

    public static byte[] getBytes(String value) {
        if (value == null || value.isEmpty()) {
            return new byte[0];
        }
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static String newString(byte[] value) {
        if (value == null || value.length == 0) {
            return "";
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

