/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.log;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.log.LogFormatClass;
import jp.mosp.framework.log.LoggerInterface;

public class MospLogger
implements LoggerInterface {
    protected static final String APP_LOG_ENCODING = "LogEncoding";
    protected static final String APP_LOG_PATTERN = "LogPattern";
    protected static final String APP_LOG_LIMIT = "LogLimit";
    protected static final String APP_LOG_COUNT = "LogCount";
    protected static final String APP_LOG_LEVEL = "LogLevel";
    protected static final int LOG_LEVEL_FINEST = 300;
    protected static final int LOG_LEVEL_FINER = 400;
    protected static final int LOG_LEVEL_FINE = 500;
    protected static final int LOG_LEVEL_CONFIG = 700;
    protected static final int LOG_LEVEL_INFO = 800;
    protected static final int LOG_LEVEL_WARNING = 900;
    protected static final int LOG_LEVEL_ALL = 0;
    protected Logger logger;

    protected Level getLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 300: {
                return Level.FINEST;
            }
            case 400: {
                return Level.FINER;
            }
            case 500: {
                return Level.FINE;
            }
            case 700: {
                return Level.CONFIG;
            }
            case 800: {
                return Level.INFO;
            }
            case 900: {
                return Level.WARNING;
            }
        }
        return Level.SEVERE;
    }

    public void log(int level, String message) {
        try {
            this.logger.log(this.getLevel(level), message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLogger(MospParams mospParams) {
        try {
            if (this.logger != null) {
                return;
            }
            String loggerName = mospParams.getApplicationProperty("Docbase") + this.getClass().getName();
            this.logger = Logger.getLogger(loggerName);
            if (this.logger.getHandlers().length > 0) {
                return;
            }
            String pattern = mospParams.getApplicationProperty("Docbase") + mospParams.getApplicationProperty(APP_LOG_PATTERN);
            int limit = mospParams.getApplicationProperty(APP_LOG_LIMIT, 0);
            int count = mospParams.getApplicationProperty(APP_LOG_COUNT, 0);
            FileHandler fh = new FileHandler(pattern, limit, count, true);
            fh.setFormatter((Formatter)new LogFormatClass(mospParams.getApplicationProperty("LogSeparator")));
            fh.setEncoding(mospParams.getApplicationProperty(APP_LOG_ENCODING));
            this.logger.addHandler(fh);
            this.logger.setLevel(this.getLevel(mospParams.getApplicationProperty(APP_LOG_LEVEL, 0)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

