/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.instance;

import java.sql.Connection;
import java.util.Comparator;
import java.util.Date;
import jp.mosp.framework.base.BaseBeanHandlerInterface;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.framework.utils.MospUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstanceFactory {
    private InstanceFactory() {
    }

    public static Object loadInstance(String className) throws MospException {
        Object obj = null;
        try {
            obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e, "FWE9101", null);
        }
        catch (ClassNotFoundException e) {
            throw new MospException((Throwable)e, "FWE9102", className);
        }
        catch (InstantiationException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        return obj;
    }

    public static <T> T loadInstance(Class<T> cls, String className) throws MospException {
        T obj = null;
        try {
            obj = (T)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e, "FWE9101", null);
        }
        catch (ClassNotFoundException e) {
            throw new MospException((Throwable)e, "FWE9102", className);
        }
        catch (InstantiationException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        return obj;
    }

    public static <T> T simplifiedInstance(String className) throws MospException {
        T obj = null;
        try {
            obj = (T)Class.forName(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e, "FWE9101", null);
        }
        catch (ClassNotFoundException e) {
            throw new MospException((Throwable)e, "FWE9102", className);
        }
        catch (InstantiationException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        return obj;
    }

    public static BaseBeanHandlerInterface loadBeanHandler(Class<?> cls, MospParams mospParams) throws MospException {
        String modelClass = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), null);
        return InstanceFactory.loadBeanHandler((String)modelClass, (MospParams)mospParams);
    }

    protected static BaseBeanHandlerInterface loadBeanHandler(String modelClass, MospParams mospParams) throws MospException {
        BaseBeanHandlerInterface beanHandler = (BaseBeanHandlerInterface)InstanceFactory.loadInstance((String)modelClass);
        beanHandler.setMospParams(mospParams);
        LogUtility.debug((MospParams)mospParams, (String)beanHandler.toString());
        return beanHandler;
    }

    public static BaseBeanInterface loadBean(Class<?> cls, MospParams mospParams, Connection connection) throws MospException {
        String modelClass = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), null);
        return InstanceFactory.loadBean((String)modelClass, (MospParams)mospParams, (Connection)connection);
    }

    public static <T extends BaseBeanInterface> T loadBeanInstance(Class<T> cls, MospParams mospParams, Connection connection) throws MospException {
        String modelClass = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), null);
        return (T)InstanceFactory.loadBean(cls, (String)modelClass, (MospParams)mospParams, (Connection)connection);
    }

    public static BaseBeanInterface loadBean(Class<?> cls, Date targetDate, MospParams mospParams, Connection connection) throws MospException {
        String modelClass = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), (Date)targetDate);
        return InstanceFactory.loadBean((String)modelClass, (MospParams)mospParams, (Connection)connection);
    }

    public static BaseBeanInterface loadBean(String modelClass, MospParams mospParams, Connection connection) throws MospException {
        BaseBeanInterface bean = (BaseBeanInterface)InstanceFactory.loadInstance((String)modelClass);
        bean.setParams(mospParams, connection);
        bean.initBean();
        LogUtility.debug((MospParams)mospParams, (String)bean.toString());
        return bean;
    }

    public static <T extends BaseBeanInterface> T loadBean(Class<T> cls, String modelClass, MospParams mospParams, Connection connection) throws MospException {
        BaseBeanInterface bean = (BaseBeanInterface)InstanceFactory.loadInstance(cls, (String)modelClass);
        bean.setParams(mospParams, connection);
        bean.initBean();
        LogUtility.debug((MospParams)mospParams, (String)bean.toString());
        return (T)bean;
    }

    public static BaseDaoInterface loadDao(Class<?> cls, MospParams mospParams, Connection connection) throws MospException {
        String modelClass = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), null);
        return InstanceFactory.loadDao((String)modelClass, (MospParams)mospParams, (Connection)connection);
    }

    public static BaseDaoInterface loadDao(String modelClass, MospParams mospParams, Connection connection) throws MospException {
        BaseDaoInterface dao = (BaseDaoInterface)InstanceFactory.loadInstance((String)modelClass);
        dao.setInitParams(mospParams, connection);
        dao.initDao();
        LogUtility.debug((MospParams)mospParams, (String)dao.toString());
        return dao;
    }

    public static <T> T loadGeneralInstance(Class<T> cls, MospParams mospParams) throws MospException {
        String className = MospUtility.getModelClass(cls, (MospProperties)mospParams.getProperties(), null);
        try {
            return (T)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e, "FWE9101", null);
        }
        catch (ClassNotFoundException e) {
            throw new MospException((Throwable)e, "FWE9102", className);
        }
        catch (InstantiationException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e, "FWE9103", className);
        }
    }

    public static Comparator<Object> loadComparator(String className) throws MospException {
        return (Comparator)InstanceFactory.loadInstance((String)className);
    }
}

