/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.exporter;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jp.mosp.framework.base.BaseExporter;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospExporterInterface;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.exporter.ImageContents;

public class HumanBinaryExporter
extends BaseExporter
implements MospExporterInterface {
    public void export(MospParams mospParams, HttpServletResponse response) throws MospException {
        Object file = mospParams.getFile();
        ImageContents image = (ImageContents)file;
        if (image.getFileType().equals("0")) {
            response.setContentType("image/gif");
        } else if (image.getFileType().equals("1")) {
            response.setContentType("image/jpeg");
        } else if (image.getFileType().equals("2")) {
            response.setContentType("image/png");
        } else {
            this.setFileContentType(mospParams, response);
        }
        this.setFileName(mospParams, response);
        byte[] binaryData = image.getBinaryData();
        try {
            ServletOutputStream out = response.getOutputStream();
            for (int offset = 0; offset < binaryData.length; offset += 1024) {
                int length = 1024;
                if (offset + length > binaryData.length) {
                    length = binaryData.length - offset;
                }
                out.write(binaryData, offset, length);
            }
        }
        catch (IOException e) {
            throw new MospException((Throwable)e, "FWE9121", null);
        }
    }
}

