/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospUser;
import jp.mosp.framework.utils.LogUtility;

public class DBConnBean {
    public static final String APP_JDNI_DATA_SOURCE = "JndiDataSource";
    public static final String APP_DB_DRIVER = "DbDriver";
    public static final String APP_DB_URL = "DbUrl";
    public static final String APP_DB_USER = "DbUser";
    public static final String APP_DB_PASS = "DbPass";
    private Connection connection = null;

    public DBConnBean(MospParams mospParams) throws MospException {
        MospUser user = mospParams.getUser();
        if (user != null && user.getAspUserId() != null && !user.getAspUserId().isEmpty()) {
            this.createConnection(user.getDbDriver(), user.getDbUrl(), user.getDbUser(), user.getDbPass());
            LogUtility.dbConnect((MospParams)mospParams, (String)(user.getAspUserId() + this.connection.toString()));
            return;
        }
        String jndiName = mospParams.getApplicationProperty(APP_JDNI_DATA_SOURCE);
        if (jndiName != null && !jndiName.isEmpty()) {
            DataSource dataSource = null;
            try {
                dataSource = this.getDataSource(jndiName);
            }
            catch (MospException e) {
                LogUtility.dbConnect((MospParams)mospParams, (String)mospParams.getMessage("FWE9213", new String[]{jndiName}));
            }
            if (dataSource != null) {
                this.createConnection(dataSource);
                LogUtility.dbConnect((MospParams)mospParams, (String)(dataSource.toString() + this.connection.toString()));
                return;
            }
        }
        String rdbdriver = "";
        String rdbname = "";
        String userid = "";
        String password = "";
        if (user != null) {
            rdbdriver = user.getDbDriver() == null ? "" : user.getDbDriver();
            rdbname = user.getDbUrl() == null ? "" : user.getDbUrl();
            userid = user.getDbUser() == null ? "" : user.getDbUser();
            String string = password = user.getDbPass() == null ? "" : user.getDbPass();
        }
        if (rdbdriver.isEmpty() || rdbname.isEmpty() || userid.isEmpty() || password.isEmpty()) {
            rdbdriver = mospParams.getApplicationProperty(APP_DB_DRIVER);
            rdbname = mospParams.getApplicationProperty(APP_DB_URL);
            userid = mospParams.getApplicationProperty(APP_DB_USER);
            password = mospParams.getApplicationProperty(APP_DB_PASS);
        }
        this.createConnection(rdbdriver, rdbname, userid, password);
        LogUtility.dbConnect((MospParams)mospParams, (String)this.connection.toString());
    }

    public DBConnBean(MospParams mospParams, String dataSourceKey) throws MospException {
        String jndiName = mospParams.getApplicationProperty(dataSourceKey);
        DataSource dataSource = null;
        if (jndiName != null && !jndiName.isEmpty()) {
            dataSource = this.getDataSource(jndiName);
            this.createConnection(dataSource);
        }
        if (this.connection != null) {
            LogUtility.dbConnect((MospParams)mospParams, (String)(dataSource.toString() + this.connection.toString()));
        }
    }

    public DBConnBean(MospParams mospParams, String rdbDriver, String rdbName, String userId, String password) throws MospException {
        this.createConnection(rdbDriver, rdbName, userId, password);
        LogUtility.dbConnect((MospParams)mospParams, (String)this.connection.toString());
    }

    protected DataSource getDataSource(String jndiName) throws MospException {
        try {
            InitialContext ctx = new InitialContext();
            return (DataSource)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new MospException((Throwable)e, "FWE9212", null);
        }
    }

    protected void createConnection(String rdbdriver, String rdbname, String userid, String password) throws MospException {
        try {
            Class.forName(rdbdriver);
            this.connection = DriverManager.getConnection(rdbname, userid, password);
            this.connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException e) {
            throw new MospException((Throwable)e, "FWE9212", null);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e, "FWE9212", null);
        }
    }

    protected void createConnection(DataSource dataSource) throws MospException {
        try {
            this.connection = dataSource.getConnection();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e, "FWE9212", null);
        }
    }

    public void commit() throws MospException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    public void rollback() throws MospException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    public void releaseConnection() throws MospException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
                this.connection.close();
            }
            if (this.connection != null) {
                this.connection = null;
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

