/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import javax.servlet.http.HttpServletResponse;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.UserAgentUtility;

public class BaseExporter {
    protected static final String APP_CONTENT_TYPE_FILE = "ContentType-File";
    protected static final String APP_CONTENT_TYPE_PREFIX = "ContentType-";
    protected static final String APP_RESPONSE_DISPOSITION = "Content-Disposition";
    protected static final String STR_CLIENT_ABORT_EXCEPTION = "ClientAbortException";

    protected void setContentType(MospParams mospParams, HttpServletResponse response) {
        String key = APP_CONTENT_TYPE_PREFIX + mospParams.getFile().getClass().getName();
        String contentType = mospParams.getApplicationProperty(key);
        response.setContentType(contentType);
    }

    protected void setFileContentType(MospParams mospParams, HttpServletResponse response) {
        String contentType = mospParams.getApplicationProperty(APP_CONTENT_TYPE_FILE);
        response.setContentType(contentType);
    }

    protected void setFileName(MospParams mospParams, HttpServletResponse response) throws MospException {
        String fileName = UserAgentUtility.getExportFileName((MospParams)mospParams);
        String disposition = mospParams.getApplicationProperty(APP_RESPONSE_DISPOSITION);
        response.addHeader(APP_RESPONSE_DISPOSITION, disposition + fileName);
    }

    protected boolean isClientAbortException(Exception e) {
        return e.toString().contains(STR_CLIENT_ABORT_EXCEPTION);
    }
}

