/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospUser;
import jp.mosp.framework.base.RDBMSType;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DatabaseUtility;
import jp.mosp.framework.utils.LogUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseDao
implements BaseDaoInterface {
    protected String colDeleteFlag = "delete_flag";
    protected String colInsertDate = "insert_date";
    protected String colInsertUser = "insert_user";
    protected String colUpdateDate = "update_date";
    protected String colUpdateUser = "update_user";
    protected String userId;
    protected MospParams mospParams;
    protected Connection connection;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected int cnt;
    protected int index;

    protected BaseDao() {
    }

    public void setInitParams(MospParams mospParams, Connection connection) {
        this.mospParams = mospParams;
        MospUser user = mospParams.getUser();
        if (user != null) {
            this.userId = user.getUserId();
        }
        this.connection = connection;
    }

    protected BaseDaoInterface loadDao(Class<?> cls) throws MospException {
        return InstanceFactory.loadDao(cls, (MospParams)this.mospParams, null);
    }

    protected <T extends BaseBeanInterface> T loadBean(Class<T> cls) throws MospException {
        return (T)InstanceFactory.loadBean(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected void releaseResultSet() throws MospException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void prepareStatement(String sql) throws MospException {
        try {
            this.ps = this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void releasePreparedStatement() throws MospException {
        try {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, String param, PreparedStatement ps) throws MospException {
        try {
            ps.setString(index, param);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, int param, PreparedStatement ps) throws MospException {
        try {
            ps.setInt(index, param);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, String param) throws MospException {
        this.setParam(index, param, this.ps);
    }

    protected void setParam(int index, int param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setInt(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, long param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setLong(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, float param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setFloat(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, double param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setDouble(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, byte[] param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setBytes(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, java.util.Date param, boolean isTimeStamp, PreparedStatement ps) throws MospException {
        try {
            if (ps != null) {
                if (param == null) {
                    if (isTimeStamp) {
                        ps.setTimestamp(index, null);
                    } else {
                        ps.setDate(index, null);
                    }
                } else if (isTimeStamp) {
                    ps.setTimestamp(index, new Timestamp(param.getTime()));
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(param);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    ps.setDate(index, new Date(cal.getTimeInMillis()));
                }
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setParam(int index, java.util.Date param, boolean isTimeStamp) throws MospException {
        this.setParam(index, param, isTimeStamp, this.ps);
    }

    protected void setParam(int index, java.util.Date param) throws MospException {
        this.setParam(index, param, false);
    }

    protected void setParam(int index, Time param) throws MospException {
        try {
            if (this.ps != null) {
                this.ps.setTime(index, param);
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void clearParams() throws MospException {
        try {
            if (this.ps != null) {
                this.ps.clearParameters();
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected String getString(String columnLabel) throws MospException {
        try {
            return this.rs.getString(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected int getInt(String columnLabel) throws MospException {
        try {
            return this.rs.getInt(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected long getLong(String columnLabel) throws MospException {
        try {
            return this.rs.getLong(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected double getDouble(String columnLabel) throws MospException {
        try {
            return this.rs.getDouble(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected boolean next() throws MospException {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected java.util.Date getDate(String columnLabel) throws MospException {
        try {
            return this.rs.getDate(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected java.util.Date getTime(String columnLabel) throws MospException {
        try {
            return this.rs.getTime(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected java.util.Date getTimestamp(String columnLabel) throws MospException {
        try {
            return this.rs.getTimestamp(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected byte[] getBytes(String columnLabel) throws MospException {
        try {
            return this.rs.getBytes(columnLabel);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void mappingCommonInfo(BaseDto dto) throws MospException {
        try {
            if (!this.colDeleteFlag.isEmpty()) {
                dto.setDeleteFlag(this.rs.getInt(this.colDeleteFlag));
            }
            if (!this.colInsertDate.isEmpty()) {
                java.util.Date insertDate = new java.util.Date(this.rs.getTimestamp(this.colInsertDate).getTime());
                dto.setInsertDate(insertDate);
            }
            if (!this.colInsertUser.isEmpty()) {
                dto.setInsertUser(this.rs.getString(this.colInsertUser));
            }
            if (!this.colUpdateDate.isEmpty()) {
                java.util.Date updateDate = new java.util.Date(this.rs.getTimestamp(this.colUpdateDate).getTime());
                dto.setUpdateDate(updateDate);
            }
            if (!this.colUpdateUser.isEmpty()) {
                dto.setUpdateUser(this.rs.getString(this.colUpdateUser));
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void setCommonParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        java.util.Date date = new java.util.Date();
        if (!this.colDeleteFlag.isEmpty()) {
            this.setParam(this.index++, baseDto.getDeleteFlag());
        }
        if (isInsert) {
            if (!this.colInsertDate.isEmpty()) {
                this.setParam(this.index++, date, true);
            }
            if (!this.colInsertUser.isEmpty()) {
                this.setParam(this.index++, this.userId);
            }
        }
        if (!this.colUpdateDate.isEmpty()) {
            this.setParam(this.index++, date, true);
        }
        if (!this.colUpdateUser.isEmpty()) {
            this.setParam(this.index++, this.userId);
        }
    }

    protected void chkInsert(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            this.mospParams.setErrorViewUrl();
            throw new MospException("FWE9221");
        }
    }

    protected void chkUpdate(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            this.mospParams.setErrorViewUrl();
            throw new MospException("FWE9222");
        }
    }

    protected void chkDelete(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            this.mospParams.setErrorViewUrl();
            throw new MospException("FWE9223");
        }
    }

    protected long nextValue(String sequence) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.select());
        query.append("NEXTVAL(?)");
        this.prepareStatement(query.toString());
        this.index = 1;
        this.setParam(this.index, sequence);
        this.executeQuery();
        this.next();
        try {
            return this.rs.getLong(1);
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    public long nextRecordId() throws MospException {
        String sequence = this.getTable(this.getClass()) + "_id_seq";
        return this.nextValue(sequence);
    }

    protected void executeQuery() throws MospException {
        try {
            if (this.ps != null) {
                this.rs = this.ps.executeQuery();
                LogUtility.sqlSelect((MospParams)this.mospParams, (String)this.ps.toString());
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientException) {
                throw new MospException((Throwable)e);
            }
            throw new MospException((Throwable)e);
        }
    }

    protected void executeUpdate() throws MospException {
        this.executeUpdate(true);
    }

    protected void executeUpdate(boolean needLog) throws MospException {
        if (this.ps != null) {
            try {
                this.cnt = this.ps.executeUpdate();
                if (needLog) {
                    LogUtility.sqlRegist((MospParams)this.mospParams, (String)this.ps.toString());
                }
            }
            catch (SQLException e) {
                if (e instanceof SQLTransientException) {
                    throw new MospException((Throwable)e);
                }
                throw new MospException((Throwable)e);
            }
        }
    }

    protected void executeUpdate(Class<?> cls, int size, int max, int idx) throws MospException {
        int executeIndex = idx + 1;
        if (executeIndex % max == 0 || executeIndex == size) {
            this.executeUpdate(false);
            this.clearParams();
            this.index = 1;
            if (size - executeIndex < max && executeIndex != size) {
                this.releasePreparedStatement();
                this.prepareStatement(this.getInsertQuery(cls, size - executeIndex, max));
            }
        } else {
            this.cnt = 0;
        }
    }

    public List<?> findAll() throws MospException {
        try {
            StringBuffer sb = this.getSelectQuery(this.getClass());
            if (!this.colDeleteFlag.isEmpty()) {
                sb.append(BaseDao.where());
                sb.append(this.deleteFlagOff());
            }
            this.prepareStatement(sb.toString());
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public BaseDto findForKey(long id, boolean isUpdate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getSelectQuery(this.getClass()));
            sb.append(this.getConditionForKey(this.getClass()));
            if (isUpdate) {
                sb.append(BaseDao.getForUpdate());
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, id);
            this.executeQuery();
            BaseDto dto = null;
            if (this.rs.next()) {
                dto = this.mapping();
            }
            BaseDto baseDto = dto;
            return baseDto;
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int insert(BaseDtoInterface baseDto) throws MospException {
        this.index = 1;
        this.prepareStatement(this.getInsertQuery(this.getClass()));
        this.setParams(baseDto, true);
        this.executeUpdate();
        this.chkInsert(1);
        return this.cnt;
    }

    protected StringBuffer getSelectQuery(Class<?> cls) throws MospException {
        String table = this.getTable(cls);
        List columnList = this.getColumnList(cls);
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectStatement(columnList));
        query.append(BaseDao.from((String)table));
        return query;
    }

    protected StringBuffer getSelectDistinctQuery(String table, String column) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectDistinctStatement(column));
        query.append(BaseDao.from((String)table));
        return query;
    }

    protected String getSelectStatement(List<String> columnList) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.select());
        for (String column : columnList) {
            query.append(column);
            query.append(BaseDao.comma());
        }
        query.append(this.getCommonColumn());
        query.delete(query.length() - 2, query.length() - 1);
        return query.toString();
    }

    protected String getSelectDistinctStatement(String column) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.select());
        query.append(BaseDao.distinct());
        query.append(column);
        return query.toString();
    }

    protected String getSelectStatement(Class<?> cls, boolean needTableName) throws MospException {
        String table = this.getTable(cls);
        List columnList = this.getColumnList(cls);
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.select());
        for (String column : columnList) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(column);
            query.append(BaseDao.comma());
        }
        query.append(this.getCommonColumn(cls, needTableName));
        query.delete(query.length() - 2, query.length() - 1);
        return query.toString();
    }

    protected String getSelectCountQuery(Class<?> cls) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectCountStatement());
        query.append(BaseDao.from((String)this.getTable(cls)));
        return query.toString();
    }

    protected String getSelectCountStatement() {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.select());
        query.append(" COUNT(*) ");
        return query.toString();
    }

    protected String getInsertQuery(Class<?> cls) throws MospException {
        String table = this.getTable(cls);
        List columnList = this.getColumnList(cls);
        StringBuffer query = new StringBuffer();
        query.append(this.getInsertQueryBase(table, columnList));
        query.append(this.getInsertQueryParams(columnList));
        return query.toString();
    }

    protected String getInsertQueryParams(List<String> columnList) {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.leftParenthesis());
        for (int i = 0; i < columnList.size(); ++i) {
            query.append("?, ");
        }
        query.append(this.getCommonParams());
        query.delete(query.length() - 2, query.length());
        query.append(BaseDao.rightParenthesis());
        return query.toString();
    }

    protected String getInsertQueryBase(String table, List<String> columnList) {
        StringBuffer query = new StringBuffer();
        query.append("INSERT INTO ");
        query.append(table);
        query.append(BaseDao.leftParenthesis());
        for (String column : columnList) {
            query.append(column);
            query.append(", ");
        }
        query.append(this.getCommonColumn());
        query.delete(query.length() - 2, query.length() - 1);
        query.append(BaseDao.rightParenthesis());
        query.append(" VALUES");
        return query.toString();
    }

    protected String getUpdateQuery(Class<?> cls) throws MospException {
        String table = this.getTable(cls);
        List columnList = this.getColumnList(cls);
        StringBuffer query = new StringBuffer();
        query.append("UPDATE ");
        query.append(table);
        query.append(" SET ");
        for (String column : columnList) {
            query.append(BaseDao.equal((String)column));
            query.append(BaseDao.comma());
        }
        if (!this.colDeleteFlag.isEmpty()) {
            query.append(BaseDao.equal((String)this.colDeleteFlag));
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateDate.isEmpty()) {
            query.append(BaseDao.equal((String)this.colUpdateDate));
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateUser.isEmpty()) {
            query.append(BaseDao.equal((String)this.colUpdateUser));
            query.append(BaseDao.comma());
        }
        query.delete(query.length() - 2, query.length() - 1);
        query.append(this.getConditionForKey(cls));
        return query.toString();
    }

    protected String getPhysicalDeleteQuery(Class<?> cls) throws MospException {
        String table = this.getTable(cls);
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append(table);
        query.append(this.getConditionForKey(cls));
        return query.toString();
    }

    protected String getDeleteQuery(Class<?> cls) throws MospException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE ");
        query.append(BaseDao.from((String)this.getTable(cls)));
        query.append(this.getConditionForKey(cls));
        return query.toString();
    }

    protected String getConditionForKey(Class<?> cls) throws MospException {
        List keyList = this.getKeyList(cls);
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.where());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            query.append(BaseDao.equal((String)((String)it.next())));
            if (!it.hasNext()) continue;
            query.append(BaseDao.and());
        }
        query.append(" ");
        return query.toString();
    }

    protected String getOrderForKey(Class<?> cls) throws MospException {
        List keyList = this.getKeyList(cls);
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.getOrderBy());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            query.append((String)it.next());
            if (!it.hasNext()) continue;
            query.append(BaseDao.comma());
        }
        query.append(" ");
        return query.toString();
    }

    protected String getInsertQuery(Class<?> cls, int size, int max) throws MospException {
        String table = this.getTable(cls);
        List columnList = this.getColumnList(cls);
        StringBuffer query = new StringBuffer();
        query.append(this.getInsertQueryBase(table, columnList));
        StringBuffer sb = new StringBuffer(this.getInsertQueryParams(columnList));
        sb.append("), ");
        for (int i = 0; i < size && i != max; ++i) {
            query.append(sb);
        }
        query.delete(query.length() - 2, query.length());
        return query.toString();
    }

    protected String getPageStatement(String sortKey, boolean isAscending) {
        StringBuffer query = new StringBuffer();
        query.append(BaseDao.getOrderBy() + sortKey + " ");
        if (!isAscending) {
            query.append(BaseDao.getDesc());
        }
        query.append(BaseDao.getLimit() + "? ");
        query.append(BaseDao.getOffset() + "? ");
        return query.toString();
    }

    private String getCommonColumn() {
        StringBuffer query = new StringBuffer();
        if (!this.colDeleteFlag.isEmpty()) {
            query.append(this.colDeleteFlag);
            query.append(BaseDao.comma());
        }
        if (!this.colInsertDate.isEmpty()) {
            query.append(this.colInsertDate);
            query.append(BaseDao.comma());
        }
        if (!this.colInsertUser.isEmpty()) {
            query.append(this.colInsertUser);
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateDate.isEmpty()) {
            query.append(this.colUpdateDate);
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateUser.isEmpty()) {
            query.append(this.colUpdateUser);
            query.append(BaseDao.comma());
        }
        return query.toString();
    }

    private String getCommonColumn(Class<?> cls, boolean needTableName) throws MospException {
        String table = this.getTable(cls);
        StringBuffer query = new StringBuffer();
        if (!this.colDeleteFlag.isEmpty()) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(this.colDeleteFlag);
            query.append(BaseDao.comma());
        }
        if (!this.colInsertDate.isEmpty()) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(this.colInsertDate);
            query.append(BaseDao.comma());
        }
        if (!this.colInsertUser.isEmpty()) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(this.colInsertUser);
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateDate.isEmpty()) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(this.colUpdateDate);
            query.append(BaseDao.comma());
        }
        if (!this.colUpdateUser.isEmpty()) {
            if (needTableName) {
                query.append(table + ".");
            }
            query.append(this.colUpdateUser);
            query.append(BaseDao.comma());
        }
        return query.toString();
    }

    private String getCommonParams() {
        StringBuffer query = new StringBuffer();
        if (!this.colDeleteFlag.isEmpty()) {
            query.append("?, ");
        }
        if (!this.colInsertDate.isEmpty()) {
            query.append("?, ");
        }
        if (!this.colInsertUser.isEmpty()) {
            query.append("?, ");
        }
        if (!this.colUpdateDate.isEmpty()) {
            query.append("?, ");
        }
        if (!this.colUpdateUser.isEmpty()) {
            query.append("?, ");
        }
        return query.toString();
    }

    protected static String deleteFlagOff(String colDeleteFlag) {
        if (colDeleteFlag.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(colDeleteFlag);
        sb.append(" = ");
        sb.append(0);
        sb.append(" ");
        return sb.toString();
    }

    protected static String flagOff(String colFlag) {
        if (colFlag.isEmpty()) {
            return "";
        }
        return BaseDao.equal((String)colFlag, (long)0L);
    }

    protected String deleteFlagOff() {
        return BaseDao.deleteFlagOff((String)this.colDeleteFlag);
    }

    protected List<String> getColumnList(Class<?> cls) throws MospException {
        return this.getFieldList(cls, "COL_");
    }

    protected List<String> getKeyList(Class<?> cls) throws MospException {
        return this.getFieldList(cls, "KEY_");
    }

    protected List<String> getFieldList(Class<?> cls, String prefix) throws MospException {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields = cls.getFields()) {
            if (field.getName().indexOf(prefix) != 0) continue;
            list.add(this.getFieldValue(field));
        }
        return list;
    }

    protected String getFieldValue(Field field) throws MospException {
        try {
            return (String)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e);
        }
    }

    public String getTable(Class<?> cls) throws MospException {
        try {
            Field table = cls.getField("TABLE");
            return (String)table.get(null);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new MospException((Throwable)e);
        }
    }

    protected static String getExplicitTableColumn(String tableName, String column) {
        return tableName + "." + column;
    }

    protected static String asTmpTable(String tableName) {
        return " AS " + BaseDao.getTmpTable((String)tableName);
    }

    protected static String getTmpTable(String tableName) {
        return "tmp_" + tableName;
    }

    protected static String getTmpColumn(String column) {
        return "tmp_" + column;
    }

    protected static String getTmpTableColumn(String tableName, String column) {
        return BaseDao.getExplicitTableColumn((String)BaseDao.getTmpTable((String)tableName), (String)column);
    }

    protected static String equalTmpColumn(String tableName, String column) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getExplicitTableColumn((String)tableName, (String)column));
        sb.append(BaseDao.equal());
        sb.append(BaseDao.getTmpTableColumn((String)tableName, (String)column));
        return sb.toString();
    }

    protected static String getForUpdate() {
        return " FOR UPDATE";
    }

    protected static String getOrderBy() {
        return " ORDER BY ";
    }

    protected static String getDesc() {
        return " DESC ";
    }

    protected static String getDescLimit1() {
        return " DESC LIMIT 1";
    }

    protected static String getLimit() {
        return " LIMIT ";
    }

    protected static String getOffset() {
        return " OFFSET ";
    }

    protected static String where() {
        return " WHERE ";
    }

    protected static String join() {
        return " JOIN ";
    }

    protected static String leftJoin() {
        return " LEFT JOIN ";
    }

    protected static String distinct() {
        return " DISTINCT ";
    }

    protected static String startWithParam(String param) {
        return param + "%";
    }

    protected static String endWithParam(String param) {
        return "%" + param;
    }

    protected static String containsParam(String param) {
        return "%" + param + "%";
    }

    protected static String boxedByCommaParam(String param, boolean isContain) throws MospException {
        StringBuffer sb = new StringBuffer();
        if (param != null) {
            if (!param.startsWith(",")) {
                sb.append(",");
            }
            sb.append(param);
            if (!param.endsWith(",")) {
                sb.append(",");
            }
            if (isContain) {
                return BaseDao.containsParam((String)sb.toString());
            }
        }
        return sb.toString();
    }

    protected static String isNull(String column) {
        return " " + column + " IS NULL ";
    }

    protected static String isNotNull(String column) {
        return " " + column + " IS NOT NULL ";
    }

    protected static String selectMax(String column) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(BaseDao.max((String)column));
        return sb.toString();
    }

    protected static String max(String column) {
        StringBuffer sb = new StringBuffer();
        sb.append("MAX(");
        sb.append(column);
        sb.append(") ");
        return sb.toString();
    }

    protected static String maxAs(String column) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.max((String)column));
        sb.append(" AS ");
        sb.append(BaseDao.getMaxColumn((String)column));
        return sb.toString();
    }

    protected static String getMaxColumn(String column) {
        return "max_" + column;
    }

    protected static String min(String column) {
        StringBuilder sb = new StringBuilder();
        sb.append("MIN(");
        sb.append(column);
        sb.append(") ");
        return sb.toString();
    }

    protected static String from(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" FROM ");
        sb.append(tableName);
        sb.append(" ");
        return sb.toString();
    }

    protected static String and() {
        return " AND ";
    }

    protected static String or() {
        return " OR ";
    }

    protected static String on() {
        return " ON ";
    }

    protected static String in() {
        return " IN ";
    }

    protected static String notIn() {
        return " NOT IN ";
    }

    protected static String leftParenthesis() {
        return " ( ";
    }

    protected static String rightParenthesis() {
        return " ) ";
    }

    protected static String select() {
        return " SELECT ";
    }

    protected static String blank() {
        return "' '";
    }

    protected static String comma() {
        return ", ";
    }

    protected static String concat(String column1, String column2) {
        return column1 + " || " + column2;
    }

    protected static String concat(String column1, String column2, String column3) {
        return column1 + " || " + column2 + " || " + column3;
    }

    protected static String equal() {
        return " = ";
    }

    protected static String equal(String column) {
        return column + " = ? ";
    }

    protected static String equal(String column, long value) {
        return column + " = " + value + " ";
    }

    protected static String equal(String column, String value) {
        return column + " = '" + value + "' ";
    }

    protected static String like() {
        return " LIKE ";
    }

    protected static String like(String column) {
        return column + BaseDao.like() + " ? ";
    }

    protected static String greater(String column) {
        return column + BaseDao.greater() + " ? ";
    }

    protected static String greater() {
        return " > ";
    }

    protected static String greaterEqual() {
        return " >= ";
    }

    protected static String greaterEqual(String column) {
        return column + " >= ? ";
    }

    protected static String less() {
        return " < ";
    }

    protected static String less(String column) {
        return column + BaseDao.less() + " ? ";
    }

    protected static String lessEqual() {
        return " <= ";
    }

    protected static String lessEqual(String column) {
        return column + " <= ? ";
    }

    protected static String notEqual(String column) {
        return column + " <> ? ";
    }

    protected static String notEqual(String column, long value) {
        return column + " <> " + value + " ";
    }

    protected static String notEqual(String column, String value) {
        return column + " <> '" + value + "' ";
    }

    protected static String getOrderByColumn(String column) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getOrderBy());
        sb.append(column);
        sb.append(" ");
        return sb.toString();
    }

    protected static String getOrderByColumn(String column1, String column2) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getOrderBy());
        sb.append(column1);
        sb.append(", ");
        sb.append(column2);
        sb.append(" ");
        return sb.toString();
    }

    protected static String getOrderByColumns(String ... columns) {
        if (columns.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getOrderBy());
        for (String column : columns) {
            if (column.isEmpty()) continue;
            sb.append(column);
            sb.append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
        return sb.toString();
    }

    protected static String getOrderByColumnDescLimit1(String column) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getOrderByColumn((String)column));
        sb.append(BaseDao.getDescLimit1());
        return sb.toString();
    }

    protected static String getOrderByColumnDesc(String column1, String column2) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getOrderBy());
        sb.append(column1);
        sb.append(BaseDao.getDesc());
        sb.append(", ");
        sb.append(column2);
        sb.append(BaseDao.getDesc());
        return sb.toString();
    }

    public static String exists() {
        return " EXISTS ";
    }

    public static String notExists() {
        return " NOT EXISTS ";
    }

    protected static String groupBy() {
        return " GROUP BY ";
    }

    protected static String limitOne() {
        return " LIMIT 1 ";
    }

    protected static String groupBy(String ... columns) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.groupBy());
        Iterator<String> it = Arrays.asList(columns).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(BaseDao.comma());
        }
        sb.append(" ");
        return sb.toString();
    }

    protected RDBMSType getRdbmsType() throws MospException {
        RDBMSType type = DatabaseUtility.getRDBMS((Connection)this.connection);
        if (type != null) {
            return type;
        }
        this.mospParams.setErrorViewUrl();
        throw new MospException("FWE9211");
    }

    protected <T> T cast(BaseDtoInterface baseDto) {
        return (T)baseDto;
    }

    protected static String inactivateFlagOff() {
        String COL_INACTIVATE_FLAG = "inactivate_flag";
        return BaseDao.equal((String)"inactivate_flag", (long)0L);
    }

    public static String parenthesis(Object ... phrases) {
        StringBuffer sb = new StringBuffer();
        if (phrases != null) {
            sb.append(BaseDao.leftParenthesis());
            for (Object phrase : phrases) {
                if (phrase == null) continue;
                sb.append(phrase);
            }
            sb.append(BaseDao.rightParenthesis());
        }
        return sb.toString();
    }

    public static String as(String phrase) {
        return " AS " + phrase;
    }

    public static String using(String ... columns) {
        StringBuffer sb = new StringBuffer();
        if (columns != null) {
            sb.append(" USING ");
            sb.append(BaseDao.leftParenthesis());
            Iterator<String> iterator = Arrays.asList(columns).iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(BaseDao.rightParenthesis());
        }
        return sb.toString();
    }

    public static String eq(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.getExplicitTableColumn((String)leftTable, (String)leftColumn));
        sb.append(" = ");
        sb.append(BaseDao.getExplicitTableColumn((String)rightTable, (String)rightColumn));
        return sb.toString();
    }

    public static String in(String column, int size) {
        if (size == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.and());
        sb.append(column);
        sb.append(BaseDao.in());
        sb.append(BaseDao.leftParenthesis());
        for (int i = 0; i < size - 1; ++i) {
            sb.append(" ?,");
        }
        sb.append(" ? ");
        sb.append(BaseDao.rightParenthesis());
        return sb.toString();
    }

    public static String notIn(String column, int size) {
        if (size == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BaseDao.and());
        sb.append(column);
        sb.append(" NOT ");
        sb.append(BaseDao.in());
        sb.append(BaseDao.leftParenthesis());
        for (int i = 0; i < size - 1; ++i) {
            sb.append(" ?,");
        }
        sb.append(" ? ");
        sb.append(BaseDao.rightParenthesis());
        return sb.toString();
    }

    protected static String sum(String condition, String columnName) {
        return " SUM (" + condition + ") AS " + columnName;
    }

    protected void setParamsIn(String ... contents) throws MospException {
        for (String content : contents) {
            this.setParam(this.index++, content);
        }
    }

    protected void setParamsIn(Set<Long> set) throws MospException {
        for (long id : set) {
            this.setParam(this.index++, id);
        }
    }

    protected void setParamsIn(int ... contents) throws MospException {
        for (int content : contents) {
            this.setParam(this.index++, content);
        }
    }
}

