/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.addon.ldap.bean.impl;

import java.sql.Connection;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.AuthBeanInterface;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.portal.impl.AuthBean;

public class ActiveDirectoryAuthBean
extends PlatformBean
implements AuthBeanInterface {
    public static final String APP_LDAP_PROVIDER_URL = "LdapProviderUrl";
    public static final String APP_LDAP_DIR_NAME = "LdapDirName";
    public static final String APP_LDAP_BIND_DN = "LdapBindDN";
    public static final String APP_LDAP_SEARCH_USER = "LdapSearchUser";
    public static final String APP_LDAP_SEARCH_PASS = "LdapSearchPass";
    protected static final String REPLACE_CHARACTER = "%";

    public ActiveDirectoryAuthBean() {
    }

    public ActiveDirectoryAuthBean(MospParams actionInfo, Connection connection) {
        super(actionInfo, connection);
    }

    public void initBean() {
    }

    public void authenticate(String userId, String password) throws MospException {
        boolean isUserExist = false;
        try {
            isUserExist = this.isUserExist(userId);
        }
        catch (MospException e) {
            this.mospParams.addErrorMessage("FWE9212", new String[0]);
            return;
        }
        if (isUserExist) {
            if (!this.isPasswordValid(userId, password)) {
                this.mospParams.addErrorMessage("PFW9111", new String[0]);
            }
            return;
        }
        AuthBean mospAuth = (AuthBean)this.createBean(AuthBean.class.getCanonicalName());
        PasswordCheckBeanInterface check = (PasswordCheckBeanInterface)this.createBean(PasswordCheckBeanInterface.class);
        mospAuth.authenticate(userId, check.encrypt(password));
    }

    protected boolean isUserExist(String userId) throws MospException {
        InitialDirContext dirContext = null;
        String ldapProviderUrl = this.mospParams.getApplicationProperty(APP_LDAP_PROVIDER_URL);
        String ldapDirName = this.mospParams.getApplicationProperty(APP_LDAP_DIR_NAME);
        String ldapBindDN = this.mospParams.getApplicationProperty(APP_LDAP_BIND_DN);
        String ldapSearchUser = this.mospParams.getApplicationProperty(APP_LDAP_SEARCH_USER);
        String ldapSearchPass = this.mospParams.getApplicationProperty(APP_LDAP_SEARCH_PASS);
        ldapBindDN = ldapBindDN.replaceAll(REPLACE_CHARACTER, ldapSearchUser);
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapProviderUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapBindDN);
        env.put("java.naming.security.credentials", ldapSearchPass);
        try {
            dirContext = new InitialDirContext(env);
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            String filter = "sAMAccountName=" + userId;
            NamingEnumeration<SearchResult> result = dirContext.search(ldapDirName, filter, ctrl);
            if (result.hasMoreElements()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            throw new MospException(t);
        }
        finally {
            if (dirContext != null) {
                try {
                    dirContext.close();
                }
                catch (Throwable t) {
                    LogUtility.error((MospParams)this.mospParams, (Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPasswordValid(String userId, String password) {
        InitialDirContext dirContext = null;
        String ldapProviderUrl = this.mospParams.getApplicationProperty(APP_LDAP_PROVIDER_URL);
        String ldapBindDN = this.mospParams.getApplicationProperty(APP_LDAP_BIND_DN);
        ldapBindDN = ldapBindDN.replaceAll(REPLACE_CHARACTER, userId);
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapProviderUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapBindDN);
        env.put("java.naming.security.credentials", password);
        try {
            dirContext = new InitialDirContext(env);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LogUtility.application((MospParams)this.mospParams, (String)this.getLdapAuthFailedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (dirContext != null) {
                try {
                    dirContext.close();
                }
                catch (Throwable t) {
                    LogUtility.error((MospParams)this.mospParams, (Throwable)t);
                }
            }
        }
    }

    protected String getLdapAuthFailedMessage() {
        return this.mospParams.getName("ldapAuthFailed");
    }
}

