/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dao.settings.impl;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceDto;

/**
 * 勤怠データDAOクラス。
 */
public class TmdAttendanceDao extends PlatformDao implements AttendanceDaoInterface {
	
	/**
	 * 勤怠データマスタ。
	 */
	public static final String		TABLE						= "tmd_attendance";
	
	/**
	 * レコード識別ID。
	 */
	public static final String		COL_TMD_ATTENDANCE_ID		= "tmd_attendance_id";
	
	/**
	 * 個人ID。
	 */
	public static final String		COL_PERSONAL_ID				= "personal_id";
	
	/**
	 * 勤務日。
	 */
	public static final String		COL_WORK_DATE				= "work_date";
	
	/**
	 * 勤務回数。
	 */
	public static final String		COL_TIMES_WORK				= "times_work";
	
	/**
	 * 勤務形態コード。
	 */
	public static final String		COL_WORK_TYPE_CODE			= "work_type_code";
	
	/**
	 * 直行。
	 */
	public static final String		COL_DIRECT_START			= "direct_start";
	
	/**
	 * 直帰。
	 */
	public static final String		COL_DIRECT_END				= "direct_end";
	
	/**
	 * 出勤時刻。
	 */
	public static final String		COL_START_TIME				= "start_time";
	
	/**
	 * 退勤時刻。
	 */
	public static final String		COL_END_TIME				= "end_time";
	
	/**
	 * 遅刻時間。
	 */
	public static final String		COL_LATE_TIME				= "late_time";
	
	/**
	 * 遅刻理由。
	 */
	public static final String		COL_LATE_REASON				= "late_reason";
	
	/**
	 * 遅刻証明書。
	 */
	public static final String		COL_LATE_CERTIFICATE		= "late_certificate";
	
	/**
	 * 遅刻コメント。
	 */
	public static final String		COL_LATE_COMMENT			= "late_comment";
	
	/**
	 * 早退時間。
	 */
	public static final String		COL_LEAVE_EARLY_TIME		= "leave_early_time";
	
	/**
	 * 早退理由。
	 */
	public static final String		COL_LEAVE_EARLY_REASON		= "leave_early_reason";
	
	/**
	 * 早退証明書。
	 */
	public static final String		COL_LEAVE_EARLY_CERTIFICATE	= "leave_early_certificate";
	
	/**
	 * 早退コメント。
	 */
	public static final String		COL_LEAVE_EARLY_COMMENT		= "leave_early_comment";
	
	/**
	 * 勤務時間。
	 */
	public static final String		COL_WORK_TIME				= "work_time";
	
	/**
	 * 所定労働時間。
	 */
	public static final String		COL_GENERAL_WORK_TIME		= "general_work_time";
	
	/**
	 * 休憩時間。
	 */
	public static final String		COL_REST_TIME				= "rest_time";
	
	/**
	 * 法定外休憩時間。
	 */
	public static final String		COL_OVER_REST_TIME			= "over_rest_time";
	
	/**
	 * 深夜休憩時間。
	 */
	public static final String		COL_NIGHT_REST_TIME			= "night_rest_time";
	
	/**
	 * 公用外出時間。
	 */
	public static final String		COL_PUBLIC_TIME				= "public_time";
	
	/**
	 * 私用外出時間。
	 */
	public static final String		COL_PRIVATE_TIME			= "private_time";
	
	/**
	 * 残業時間。
	 */
	public static final String		COL_OVERTIME				= "overtime";
	
	/**
	 * 前残業時間。
	 */
	public static final String		COL_OVERTIME_BEFORE			= "overtime_Before";
	
	/**
	 * 後残業時間。
	 */
	public static final String		COL_OVERTIME_AFTER			= "overtime_After";
	
	/**
	 * 法定内残業時間。
	 */
	public static final String		COL_OVERTIME_IN				= "overtime_in";
	
	/**
	 * 法定外残業時間。
	 */
	public static final String		COL_OVERTIME_OUT			= "overtime_out";
	
	/**
	 * 深夜勤務時間。
	 */
	public static final String		COL_LATE_NIGHT_TIME			= "late_night_time";
	
	/**
	 * 所定休日勤務時間。
	 */
	public static final String		COL_SPECIFIC_WORK_TIME		= "specific_work_time";
	
	/**
	 * 法定休日勤務時間。
	 */
	public static final String		COL_LEGAL_WORK_TIME			= "legal_work_time";
	
	/**
	 * 減額対象時間。
	 */
	public static final String		COL_DECREASE_TIME			= "decrease_time";
	
	/**
	 * 勤怠コメント。
	 */
	public static final String		COL_TIME_COMMENT			= "time_comment";
	
	/**
	 * ワークフロー番号。
	 */
	public static final String		COL_WORKFLOW				= "workflow";
	
	/**
	 * キー。
	 */
	public static final String		KEY_1						= COL_TMD_ATTENDANCE_ID;
	
	private WorkflowDaoInterface	workflowDao;
	

	/**
	 * コンストラクタ。
	 */
	public TmdAttendanceDao() {
	}
	
	public void initDao() throws MospException {
		workflowDao = (WorkflowDaoInterface)loadDao(WorkflowDaoInterface.class);
	}
	
	@Override
	public BaseDto mapping() throws MospException {
		TmdAttendanceDto dto = new TmdAttendanceDto();
		dto.setTmdAttendanceId(getLong(COL_TMD_ATTENDANCE_ID));
		dto.setPersonalId(getString(COL_PERSONAL_ID));
		dto.setWorkDate(getDate(COL_WORK_DATE));
		dto.setTimesWork(getInt(COL_TIMES_WORK));
		dto.setWorkTypeCode(getString(COL_WORK_TYPE_CODE));
		dto.setDirectStart(getInt(COL_DIRECT_START));
		dto.setDirectEnd(getInt(COL_DIRECT_END));
		dto.setStartTime(getTimestamp(COL_START_TIME));
		dto.setEndTime(getTimestamp(COL_END_TIME));
		dto.setLateTime(getInt(COL_LATE_TIME));
		dto.setLateReason(getString(COL_LATE_REASON));
		dto.setLateCertificate(getString(COL_LATE_CERTIFICATE));
		dto.setLateComment(getString(COL_LATE_COMMENT));
		dto.setLeaveEarlyTime(getInt(COL_LEAVE_EARLY_TIME));
		dto.setLeaveEarlyReason(getString(COL_LEAVE_EARLY_REASON));
		dto.setLeaveEarlyCertificate(getString(COL_LEAVE_EARLY_CERTIFICATE));
		dto.setLeaveEarlyComment(getString(COL_LEAVE_EARLY_COMMENT));
		dto.setWorkTime(getInt(COL_WORK_TIME));
		dto.setGeneralWorkTime(getInt(COL_GENERAL_WORK_TIME));
		dto.setRestTime(getInt(COL_REST_TIME));
		dto.setOverRestTime(getInt(COL_OVER_REST_TIME));
		dto.setNightRestTime(getInt(COL_NIGHT_REST_TIME));
		dto.setPublicTime(getInt(COL_PUBLIC_TIME));
		dto.setPrivateTime(getInt(COL_PRIVATE_TIME));
		dto.setOvertime(getInt(COL_OVERTIME));
		dto.setOvertimeBefore(getInt(COL_OVERTIME_BEFORE));
		dto.setOvertimeAfter(getInt(COL_OVERTIME_AFTER));
		dto.setOvertimeIn(getInt(COL_OVERTIME_IN));
		dto.setOvertimeOut(getInt(COL_OVERTIME_OUT));
		dto.setLateNightTime(getInt(COL_LATE_NIGHT_TIME));
		dto.setSpecificWorkTime(getInt(COL_SPECIFIC_WORK_TIME));
		dto.setLegalWorkTime(getInt(COL_LEGAL_WORK_TIME));
		dto.setDecreaseTime(getInt(COL_DECREASE_TIME));
		dto.setTimeComment(getString(COL_TIME_COMMENT));
		dto.setWorkflow(getLong(COL_WORKFLOW));
		mappingCommonInfo(dto);
		return dto;
	}
	
	@Override
	public List<AttendanceDtoInterface> mappingAll() throws MospException {
		List<AttendanceDtoInterface> all = new ArrayList<AttendanceDtoInterface>();
		while (next()) {
			all.add((AttendanceDtoInterface)mapping());
		}
		return all;
	}
	
	@Override
	public int update(BaseDtoInterface baseDto) throws MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(baseDto, false);
			AttendanceDtoInterface dto = (AttendanceDtoInterface)baseDto;
			setParam(index++, dto.getTmdAttendanceId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public int delete(BaseDtoInterface baseDto) {
		// 処理無し
		return 0;
	}
	
	@Override
	public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
		AttendanceDtoInterface dto = (AttendanceDtoInterface)baseDto;
		setParam(index++, dto.getTmdAttendanceId());
		setParam(index++, dto.getPersonalId());
		setParam(index++, dto.getWorkDate());
		setParam(index++, dto.getTimesWork());
		setParam(index++, dto.getWorkTypeCode());
		setParam(index++, dto.getDirectStart());
		setParam(index++, dto.getDirectEnd());
		setParam(index++, dto.getStartTime() == null ? null : new Time(dto.getStartTime().getTime()), true);
		setParam(index++, dto.getEndTime() == null ? null : new Time(dto.getEndTime().getTime()), true);
		setParam(index++, dto.getLateTime());
		setParam(index++, dto.getLateReason());
		setParam(index++, dto.getLateCertificate());
		setParam(index++, dto.getLateComment());
		setParam(index++, dto.getLeaveEarlyTime());
		setParam(index++, dto.getLeaveEarlyReason());
		setParam(index++, dto.getLeaveEarlyCertificate());
		setParam(index++, dto.getLeaveEarlyComment());
		setParam(index++, dto.getWorkTime());
		setParam(index++, dto.getGeneralWorkTime());
		setParam(index++, dto.getRestTime());
		setParam(index++, dto.getOverRestTime());
		setParam(index++, dto.getNightRestTime());
		setParam(index++, dto.getPublicTime());
		setParam(index++, dto.getPrivateTime());
		setParam(index++, dto.getOvertime());
		setParam(index++, dto.getOvertimeBefore());
		setParam(index++, dto.getOvertimeAfter());
		setParam(index++, dto.getOvertimeIn());
		setParam(index++, dto.getOvertimeOut());
		setParam(index++, dto.getLateNightTime());
		setParam(index++, dto.getSpecificWorkTime());
		setParam(index++, dto.getLegalWorkTime());
		setParam(index++, dto.getDecreaseTime());
		setParam(index++, dto.getTimeComment());
		setParam(index++, dto.getWorkflow());
		setCommonParams(baseDto, isInsert);
	}
	
	@Override
	public Map<String, Object> getParamsMap() {
		return new HashMap<String, Object>();
	}
	
	@Override
	public List<AttendanceDtoInterface> findForHistory(String personalId, Date workDate, int timesWork)
			throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_PERSONAL_ID));
			sb.append(and());
			sb.append(equal(COL_WORK_DATE));
			sb.append(and());
			sb.append(equal(COL_TIMES_WORK));
			prepareStatement(sb.toString());
			setParam(index++, personalId);
			setParam(index++, workDate);
			setParam(index++, timesWork);
			executeQuery();
			return mappingAll();
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public AttendanceDtoInterface findForKey(String personalId, Date workDate, int timesWork) throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_PERSONAL_ID));
			sb.append(and());
			sb.append(equal(COL_WORK_DATE));
			sb.append(and());
			sb.append(equal(COL_TIMES_WORK));
			prepareStatement(sb.toString());
			setParam(index++, personalId);
			setParam(index++, workDate);
			setParam(index++, timesWork);
			executeQuery();
			AttendanceDtoInterface dto = null;
			if (next()) {
				dto = (AttendanceDtoInterface)mapping();
			}
			return dto;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public List<AttendanceDtoInterface> findForList(String personalId, Date startDate, Date endDate)
			throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_PERSONAL_ID));
			sb.append(and());
			sb.append(greaterEqual(COL_WORK_DATE));
			sb.append(and());
			sb.append(lessEqual(COL_WORK_DATE));
			prepareStatement(sb.toString());
			setParam(index++, personalId);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			return mappingAll();
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public AttendanceDtoInterface findForWorkflow(long workflow) throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_WORKFLOW));
			prepareStatement(sb.toString());
			setParam(index++, workflow);
			executeQuery();
			AttendanceDtoInterface dto = null;
			if (next()) {
				dto = (AttendanceDtoInterface)mapping();
			}
			return dto;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public List<AttendanceDtoInterface> findForWorkflowStatus(String personalId, int workflowStage,
			String workflowStatus, String routeCode) throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_PERSONAL_ID));
			sb.append(and());
			sb.append(COL_WORKFLOW);
			sb.append(in());
			sb.append(leftParenthesis());
			boolean useRoute = routeCode != null && routeCode.length() != 0;
			sb.append(workflowDao.getSubQueryForSetting(true, true, useRoute, true));
			sb.append(rightParenthesis());
			prepareStatement(sb.toString());
			setParam(index++, personalId);
			setParam(index++, workflowStage);
			setParam(index++, workflowStatus);
			if (useRoute) {
				setParam(index++, routeCode);
			}
			setParam(index++, TimeConst.CODE_FUNCTION_WORK_MANGE);
			executeQuery();
			return mappingAll();
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
		
	}
}
